/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ConfigurationInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Configuration;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ConfigurationDataType;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ConfigurationForUpdate;

public final class ConfigurationImpl
implements Configuration,
Configuration.Definition,
Configuration.Update {
    private ConfigurationInner innerObject;
    private final PostgreSqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private String configurationName;
    private ConfigurationForUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String value() {
        return this.innerModel().value();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String defaultValue() {
        return this.innerModel().defaultValue();
    }

    @Override
    public ConfigurationDataType dataType() {
        return this.innerModel().dataType();
    }

    @Override
    public String allowedValues() {
        return this.innerModel().allowedValues();
    }

    @Override
    public String source() {
        return this.innerModel().source();
    }

    @Override
    public Boolean isDynamicConfig() {
        return this.innerModel().isDynamicConfig();
    }

    @Override
    public Boolean isReadOnly() {
        return this.innerModel().isReadOnly();
    }

    @Override
    public Boolean isConfigPendingRestart() {
        return this.innerModel().isConfigPendingRestart();
    }

    @Override
    public String unit() {
        return this.innerModel().unit();
    }

    @Override
    public String documentationLink() {
        return this.innerModel().documentationLink();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ConfigurationInner innerModel() {
        return this.innerObject;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigurationImpl withExistingFlexibleServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    @Override
    public Configuration create() {
        this.innerObject = this.serviceManager.serviceClient().getConfigurations().put(this.resourceGroupName, this.serverName, this.configurationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Configuration create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getConfigurations().put(this.resourceGroupName, this.serverName, this.configurationName, this.innerModel(), context);
        return this;
    }

    ConfigurationImpl(String name, PostgreSqlManager serviceManager) {
        this.innerObject = new ConfigurationInner();
        this.serviceManager = serviceManager;
        this.configurationName = name;
    }

    @Override
    public ConfigurationImpl update() {
        this.updateParameters = new ConfigurationForUpdate();
        return this;
    }

    @Override
    public Configuration apply() {
        this.innerObject = this.serviceManager.serviceClient().getConfigurations().update(this.resourceGroupName, this.serverName, this.configurationName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public Configuration apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getConfigurations().update(this.resourceGroupName, this.serverName, this.configurationName, this.updateParameters, context);
        return this;
    }

    ConfigurationImpl(ConfigurationInner innerObject, PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "flexibleServers");
        this.configurationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "configurations");
    }

    @Override
    public Configuration refresh() {
        this.innerObject = (ConfigurationInner)((Object)this.serviceManager.serviceClient().getConfigurations().getWithResponse(this.resourceGroupName, this.serverName, this.configurationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Configuration refresh(Context context) {
        this.innerObject = (ConfigurationInner)((Object)this.serviceManager.serviceClient().getConfigurations().getWithResponse(this.resourceGroupName, this.serverName, this.configurationName, context).getValue());
        return this;
    }

    @Override
    public ConfigurationImpl withValue(String value) {
        if (this.isInCreateMode()) {
            this.innerModel().withValue(value);
            return this;
        }
        this.updateParameters.withValue(value);
        return this;
    }

    @Override
    public ConfigurationImpl withSource(String source) {
        if (this.isInCreateMode()) {
            this.innerModel().withSource(source);
            return this;
        }
        this.updateParameters.withSource(source);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

