/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.VirtualEndpointResourceProperties;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpointResourceForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.VirtualEndpointType;
import java.io.IOException;
import java.util.List;

public final class VirtualEndpointResourceInner
extends VirtualEndpointResourceForPatch {
    private String id;
    private String name;
    private String type;
    private SystemData systemData;
    private VirtualEndpointResourceProperties innerProperties;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    private VirtualEndpointResourceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public VirtualEndpointType endpointType() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointType();
    }

    @Override
    public VirtualEndpointResourceInner withEndpointType(VirtualEndpointType endpointType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualEndpointResourceProperties();
        }
        this.innerProperties().withEndpointType(endpointType);
        return this;
    }

    @Override
    public List<String> members() {
        return this.innerProperties() == null ? null : this.innerProperties().members();
    }

    @Override
    public VirtualEndpointResourceInner withMembers(List<String> members) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualEndpointResourceProperties();
        }
        this.innerProperties().withMembers(members);
        return this;
    }

    @Override
    public List<String> virtualEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualEndpoints();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties());
        return jsonWriter.writeEndObject();
    }

    public static VirtualEndpointResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualEndpointResourceInner)jsonReader.readObject(reader -> {
            VirtualEndpointResourceInner deserializedVirtualEndpointResourceInner = new VirtualEndpointResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedVirtualEndpointResourceInner.innerProperties = VirtualEndpointResourceProperties.fromJson(reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedVirtualEndpointResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualEndpointResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualEndpointResourceInner.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedVirtualEndpointResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualEndpointResourceInner;
        });
    }
}

