/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CancelEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.LogicalReplicationOnSourceDbEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrateRolesEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationMode;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationSecretParameters;
import com.azure.resourcemanager.postgresqlflexibleserver.models.OverwriteDbsInTargetEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.StartDataMigrationEnum;
import com.azure.resourcemanager.postgresqlflexibleserver.models.TriggerCutoverEnum;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class MigrationResourcePropertiesForPatch
implements JsonSerializable<MigrationResourcePropertiesForPatch> {
    private String sourceDbServerResourceId;
    private String sourceDbServerFullyQualifiedDomainName;
    private String targetDbServerFullyQualifiedDomainName;
    private MigrationSecretParameters secretParameters;
    private List<String> dbsToMigrate;
    private LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded;
    private OverwriteDbsInTargetEnum overwriteDbsInTarget;
    private OffsetDateTime migrationWindowStartTimeInUtc;
    private MigrateRolesEnum migrateRoles;
    private StartDataMigrationEnum startDataMigration;
    private TriggerCutoverEnum triggerCutover;
    private List<String> dbsToTriggerCutoverOn;
    private CancelEnum cancel;
    private List<String> dbsToCancelMigrationOn;
    private MigrationMode migrationMode;

    public String sourceDbServerResourceId() {
        return this.sourceDbServerResourceId;
    }

    public MigrationResourcePropertiesForPatch withSourceDbServerResourceId(String sourceDbServerResourceId) {
        this.sourceDbServerResourceId = sourceDbServerResourceId;
        return this;
    }

    public String sourceDbServerFullyQualifiedDomainName() {
        return this.sourceDbServerFullyQualifiedDomainName;
    }

    public MigrationResourcePropertiesForPatch withSourceDbServerFullyQualifiedDomainName(String sourceDbServerFullyQualifiedDomainName) {
        this.sourceDbServerFullyQualifiedDomainName = sourceDbServerFullyQualifiedDomainName;
        return this;
    }

    public String targetDbServerFullyQualifiedDomainName() {
        return this.targetDbServerFullyQualifiedDomainName;
    }

    public MigrationResourcePropertiesForPatch withTargetDbServerFullyQualifiedDomainName(String targetDbServerFullyQualifiedDomainName) {
        this.targetDbServerFullyQualifiedDomainName = targetDbServerFullyQualifiedDomainName;
        return this;
    }

    public MigrationSecretParameters secretParameters() {
        return this.secretParameters;
    }

    public MigrationResourcePropertiesForPatch withSecretParameters(MigrationSecretParameters secretParameters) {
        this.secretParameters = secretParameters;
        return this;
    }

    public List<String> dbsToMigrate() {
        return this.dbsToMigrate;
    }

    public MigrationResourcePropertiesForPatch withDbsToMigrate(List<String> dbsToMigrate) {
        this.dbsToMigrate = dbsToMigrate;
        return this;
    }

    public LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded() {
        return this.setupLogicalReplicationOnSourceDbIfNeeded;
    }

    public MigrationResourcePropertiesForPatch withSetupLogicalReplicationOnSourceDbIfNeeded(LogicalReplicationOnSourceDbEnum setupLogicalReplicationOnSourceDbIfNeeded) {
        this.setupLogicalReplicationOnSourceDbIfNeeded = setupLogicalReplicationOnSourceDbIfNeeded;
        return this;
    }

    public OverwriteDbsInTargetEnum overwriteDbsInTarget() {
        return this.overwriteDbsInTarget;
    }

    public MigrationResourcePropertiesForPatch withOverwriteDbsInTarget(OverwriteDbsInTargetEnum overwriteDbsInTarget) {
        this.overwriteDbsInTarget = overwriteDbsInTarget;
        return this;
    }

    public OffsetDateTime migrationWindowStartTimeInUtc() {
        return this.migrationWindowStartTimeInUtc;
    }

    public MigrationResourcePropertiesForPatch withMigrationWindowStartTimeInUtc(OffsetDateTime migrationWindowStartTimeInUtc) {
        this.migrationWindowStartTimeInUtc = migrationWindowStartTimeInUtc;
        return this;
    }

    public MigrateRolesEnum migrateRoles() {
        return this.migrateRoles;
    }

    public MigrationResourcePropertiesForPatch withMigrateRoles(MigrateRolesEnum migrateRoles) {
        this.migrateRoles = migrateRoles;
        return this;
    }

    public StartDataMigrationEnum startDataMigration() {
        return this.startDataMigration;
    }

    public MigrationResourcePropertiesForPatch withStartDataMigration(StartDataMigrationEnum startDataMigration) {
        this.startDataMigration = startDataMigration;
        return this;
    }

    public TriggerCutoverEnum triggerCutover() {
        return this.triggerCutover;
    }

    public MigrationResourcePropertiesForPatch withTriggerCutover(TriggerCutoverEnum triggerCutover) {
        this.triggerCutover = triggerCutover;
        return this;
    }

    public List<String> dbsToTriggerCutoverOn() {
        return this.dbsToTriggerCutoverOn;
    }

    public MigrationResourcePropertiesForPatch withDbsToTriggerCutoverOn(List<String> dbsToTriggerCutoverOn) {
        this.dbsToTriggerCutoverOn = dbsToTriggerCutoverOn;
        return this;
    }

    public CancelEnum cancel() {
        return this.cancel;
    }

    public MigrationResourcePropertiesForPatch withCancel(CancelEnum cancel) {
        this.cancel = cancel;
        return this;
    }

    public List<String> dbsToCancelMigrationOn() {
        return this.dbsToCancelMigrationOn;
    }

    public MigrationResourcePropertiesForPatch withDbsToCancelMigrationOn(List<String> dbsToCancelMigrationOn) {
        this.dbsToCancelMigrationOn = dbsToCancelMigrationOn;
        return this;
    }

    public MigrationMode migrationMode() {
        return this.migrationMode;
    }

    public MigrationResourcePropertiesForPatch withMigrationMode(MigrationMode migrationMode) {
        this.migrationMode = migrationMode;
        return this;
    }

    public void validate() {
        if (this.secretParameters() != null) {
            this.secretParameters().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceDbServerResourceId", this.sourceDbServerResourceId);
        jsonWriter.writeStringField("sourceDbServerFullyQualifiedDomainName", this.sourceDbServerFullyQualifiedDomainName);
        jsonWriter.writeStringField("targetDbServerFullyQualifiedDomainName", this.targetDbServerFullyQualifiedDomainName);
        jsonWriter.writeJsonField("secretParameters", (JsonSerializable)this.secretParameters);
        jsonWriter.writeArrayField("dbsToMigrate", this.dbsToMigrate, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("setupLogicalReplicationOnSourceDbIfNeeded", this.setupLogicalReplicationOnSourceDbIfNeeded == null ? null : this.setupLogicalReplicationOnSourceDbIfNeeded.toString());
        jsonWriter.writeStringField("overwriteDbsInTarget", this.overwriteDbsInTarget == null ? null : this.overwriteDbsInTarget.toString());
        jsonWriter.writeStringField("migrationWindowStartTimeInUtc", this.migrationWindowStartTimeInUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.migrationWindowStartTimeInUtc));
        jsonWriter.writeStringField("migrateRoles", this.migrateRoles == null ? null : this.migrateRoles.toString());
        jsonWriter.writeStringField("startDataMigration", this.startDataMigration == null ? null : this.startDataMigration.toString());
        jsonWriter.writeStringField("triggerCutover", this.triggerCutover == null ? null : this.triggerCutover.toString());
        jsonWriter.writeArrayField("dbsToTriggerCutoverOn", this.dbsToTriggerCutoverOn, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("cancel", this.cancel == null ? null : this.cancel.toString());
        jsonWriter.writeArrayField("dbsToCancelMigrationOn", this.dbsToCancelMigrationOn, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("migrationMode", this.migrationMode == null ? null : this.migrationMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static MigrationResourcePropertiesForPatch fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationResourcePropertiesForPatch)jsonReader.readObject(reader -> {
            MigrationResourcePropertiesForPatch deserializedMigrationResourcePropertiesForPatch = new MigrationResourcePropertiesForPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceDbServerResourceId".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.sourceDbServerResourceId = reader.getString();
                    continue;
                }
                if ("sourceDbServerFullyQualifiedDomainName".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.sourceDbServerFullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("targetDbServerFullyQualifiedDomainName".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.targetDbServerFullyQualifiedDomainName = reader.getString();
                    continue;
                }
                if ("secretParameters".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.secretParameters = MigrationSecretParameters.fromJson(reader);
                    continue;
                }
                if ("dbsToMigrate".equals(fieldName)) {
                    List dbsToMigrate;
                    deserializedMigrationResourcePropertiesForPatch.dbsToMigrate = dbsToMigrate = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("setupLogicalReplicationOnSourceDbIfNeeded".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.setupLogicalReplicationOnSourceDbIfNeeded = LogicalReplicationOnSourceDbEnum.fromString(reader.getString());
                    continue;
                }
                if ("overwriteDbsInTarget".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.overwriteDbsInTarget = OverwriteDbsInTargetEnum.fromString(reader.getString());
                    continue;
                }
                if ("migrationWindowStartTimeInUtc".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.migrationWindowStartTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("migrateRoles".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.migrateRoles = MigrateRolesEnum.fromString(reader.getString());
                    continue;
                }
                if ("startDataMigration".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.startDataMigration = StartDataMigrationEnum.fromString(reader.getString());
                    continue;
                }
                if ("triggerCutover".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.triggerCutover = TriggerCutoverEnum.fromString(reader.getString());
                    continue;
                }
                if ("dbsToTriggerCutoverOn".equals(fieldName)) {
                    List dbsToTriggerCutoverOn;
                    deserializedMigrationResourcePropertiesForPatch.dbsToTriggerCutoverOn = dbsToTriggerCutoverOn = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("cancel".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.cancel = CancelEnum.fromString(reader.getString());
                    continue;
                }
                if ("dbsToCancelMigrationOn".equals(fieldName)) {
                    List dbsToCancelMigrationOn;
                    deserializedMigrationResourcePropertiesForPatch.dbsToCancelMigrationOn = dbsToCancelMigrationOn = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("migrationMode".equals(fieldName)) {
                    deserializedMigrationResourcePropertiesForPatch.migrationMode = MigrationMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationResourcePropertiesForPatch;
        });
    }
}

