/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.sql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.netezza.error.NzFeatureNotSupportedException;
import org.netezza.error.NzSQLException;
import org.netezza.internal.ColumnMetadata;
import org.netezza.internal.PgType;
import org.netezza.sql.NzConnection;

public class NzResultSetMetadata
implements ResultSetMetaData {
    private final NzConnection connection;
    private final ColumnMetadata[] columnMetadatas;
    private int version;
    private int nullsAllowed;
    private int sizeWord;
    private int sizeWordSize;
    private int numFixedFields;
    private int numVaryingFields;
    private int fixedFieldsSize;
    private int maxRecordSize;
    private int numFields;
    private int DateStyle;
    private int EuroDates;
    private int dbCharset;
    private int EnableTime24;

    public NzResultSetMetadata(NzConnection nzConnection, ColumnMetadata[] metadatas) {
        this.connection = nzConnection;
        this.columnMetadatas = metadatas;
    }

    public ColumnMetadata getColumnMetadata(int columnNumber) throws SQLException {
        String method = "getColumnMetadata";
        this.connection.LOGGER.entry(this.getClass(), method, columnNumber);
        if (columnNumber < 1 || columnNumber > this.columnMetadatas.length) {
            NzSQLException ex = new NzSQLException("netezza.col.idx.out.of.range", "07009", 11430, columnNumber);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        ColumnMetadata metadata = this.columnMetadatas[columnNumber - 1];
        this.connection.LOGGER.exit(this.getClass(), method, metadata);
        return metadata;
    }

    public void addColumnMetadata(int index, ColumnMetadata metadata) throws SQLException {
        String method = "addColumnMetadata";
        this.connection.LOGGER.entry(this.getClass(), method, index, metadata);
        if (index < 0 || index >= this.columnMetadatas.length) {
            NzSQLException ex = new NzSQLException("netezza.idx.out.of.range", "HY000", 1021, index);
            this.connection.LOGGER.fatal(this.getClass(), method, ex);
            throw ex;
        }
        this.columnMetadatas[index] = metadata;
    }

    public int getFixedFieldsSize() {
        return this.fixedFieldsSize;
    }

    public void setFixedFieldsSize(int fixedFieldsSize) {
        this.fixedFieldsSize = fixedFieldsSize;
    }

    public int getMaxRecordSize() {
        return this.maxRecordSize;
    }

    public void setMaxRecordSize(int maxRecordSize) {
        this.maxRecordSize = maxRecordSize;
    }

    public int getNullsAllowed() {
        return this.nullsAllowed;
    }

    public void setNullsAllowed(int nullsAllowed) {
        this.nullsAllowed = nullsAllowed;
    }

    public int getNumFields() {
        return this.numFields;
    }

    public void setNumFields(int numFields) {
        this.numFields = numFields;
    }

    public int getNumFixedFields() {
        return this.numFixedFields;
    }

    public void setNumFixedFields(int numFixedFields) {
        this.numFixedFields = numFixedFields;
    }

    public int getNumVaryingFields() {
        return this.numVaryingFields;
    }

    public void setNumVaryingFields(int numVaryingFields) {
        this.numVaryingFields = numVaryingFields;
    }

    public int getSizeWord() {
        return this.sizeWord;
    }

    public void setSizeWord(int sizeWord) {
        this.sizeWord = sizeWord;
    }

    public int getSizeWordSize() {
        return this.sizeWordSize;
    }

    public void setSizeWordSize(int sizeWordSize) {
        this.sizeWordSize = sizeWordSize;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public NzConnection getConnection() {
        return this.connection;
    }

    public int getDateStyle() {
        return this.DateStyle;
    }

    public void setDateStyle(int dateStyle) {
        this.DateStyle = dateStyle;
    }

    public int getDbCharset() {
        return this.dbCharset;
    }

    public void setDbCharset(int dbCharset) {
        this.dbCharset = dbCharset;
    }

    public int getEuroDates() {
        return this.EuroDates;
    }

    public void setEuroDates(int euroDates) {
        this.EuroDates = euroDates;
    }

    public int getEnableTime24() {
        return this.EnableTime24;
    }

    public void setEnableTime24(int enable_time24) {
        this.EnableTime24 = enable_time24;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getColumnMetadata(column).getPgType().getClassName();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnMetadatas.length;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int colSize;
        ColumnMetadata meta = this.getColumnMetadata(column);
        PgType pgType = meta.getPgType();
        int colTypeModifier = meta.getModifier() - 12;
        int colLength = meta.getLength();
        int colTypeID = pgType.getOid();
        if (colTypeModifier < 0) {
            colTypeModifier = -1;
        }
        if (pgType == PgType.PG_TEXT) {
            colLength = 4096;
        }
        switch (pgType) {
            case PG_UNKNOWN: {
                colSize = colTypeModifier;
                break;
            }
            case PG_NUMERIC: {
                colSize = (colTypeModifier >> 16 & 0x7F) + 2;
                break;
            }
            case PG_TEXT: 
            case PG_NAME: 
            case PG_BOOLEAN: 
            case PG_CHAR: 
            case PG_BPCHAR: 
            case PG_VARCHAR: 
            case PG_NVARCHAR: 
            case PG_NCHAR: 
            case PG_GEOMETRY: 
            case PG_VARBINARY: {
                if (colTypeModifier == -1) {
                    colSize = colLength;
                    break;
                }
                colSize = colTypeModifier;
                break;
            }
            default: {
                colSize = pgType.getSize();
            }
        }
        return colSize;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnMetadata(column).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        this.connection.LOGGER.debug(this.getClass(), "** TEST ****", this.getColumnMetadata(column).getName());
        return this.getColumnMetadata(column).getName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        PgType type = this.getColumnMetadata(column).getPgType();
        if ((double)NzConnection.JDBC_SPEC_VERSION >= 1.6) {
            switch (type) {
                case PG_TEXT: 
                case PG_NAME: 
                case PG_NVARCHAR: 
                case PG_INT2VECTOR: {
                    return -9;
                }
                case PG_NCHAR: {
                    return -15;
                }
            }
        }
        return type.getSqlType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumnMetadata(column).getPgType().getName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        int precision;
        ColumnMetadata meta = this.getColumnMetadata(column);
        PgType pgType = meta.getPgType();
        int colTypeModifier = meta.getModifier() - 12;
        int colLength = meta.getLength();
        if (colTypeModifier < 0) {
            colTypeModifier = -1;
        }
        if (pgType == PgType.PG_TEXT) {
            colLength = 4096;
        }
        switch (pgType) {
            case PG_UNKNOWN: {
                precision = colTypeModifier;
                break;
            }
            case PG_NUMERIC: {
                precision = colTypeModifier >> 16 & 0x7F;
                break;
            }
            case PG_TEXT: 
            case PG_NAME: 
            case PG_BOOLEAN: 
            case PG_CHAR: 
            case PG_BPCHAR: 
            case PG_VARCHAR: 
            case PG_NVARCHAR: 
            case PG_NCHAR: 
            case PG_GEOMETRY: 
            case PG_VARBINARY: {
                if (colTypeModifier == -1) {
                    precision = colLength;
                    break;
                }
                precision = colTypeModifier;
                break;
            }
            default: {
                precision = pgType.getPrecision();
            }
        }
        return precision;
    }

    @Override
    public int getScale(int column) throws SQLException {
        int scale;
        ColumnMetadata meta = this.getColumnMetadata(column);
        PgType pgType = meta.getPgType();
        int colTypeModifier = meta.getModifier() - 12;
        if (colTypeModifier < 0) {
            colTypeModifier = -1;
        }
        switch (pgType) {
            case PG_NUMERIC: {
                scale = colTypeModifier & 0xFF;
                break;
            }
            default: {
                scale = pgType.getScale();
            }
        }
        return scale;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.getColumnMetadata(column).getPgType().isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumnMetadata(column).getNullAllowed();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.getColumnMetadata(column).getPgType().isSearchable();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumnMetadata(column).getPgType().isSigned();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return !this.isReadOnly(column);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("isWrapperFor");
        this.connection.LOGGER.fatal(this.getClass(), "isWrapperFor", etothrow);
        throw etothrow;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        NzFeatureNotSupportedException etothrow = new NzFeatureNotSupportedException("unwrap");
        this.connection.LOGGER.fatal(this.getClass(), "unwrap", etothrow);
        throw etothrow;
    }
}

