/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.rte.comm;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.rte.comm.BasicSocketComm;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.Tracer;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class SecureCommunication
extends BasicSocketComm {
    public static final JdbcCommFactory factory = new JdbcCommFactory(){

        public JdbcCommunication open(String host, String dbname, Properties properties, Tracer tracer) throws RTEException {
            SecureCommunication sc = new SecureCommunication(host, properties, 0, tracer);
            sc.connectDB(dbname);
            return sc;
        }

        public JdbcCommunication xopen(String host, String db, String dbroot, String pgm, Properties properties, Tracer tracer) throws RTEException {
            SecureCommunication sc = new SecureCommunication(host, properties, 4, tracer);
            sc.connectAdmin(db, dbroot, pgm);
            return sc;
        }
    };
    private boolean ignoreServerCertificate;
    private boolean ignoreHostNameInCertificate;

    private SecureCommunication(String hostPort, Properties properties, int aServiceType, Tracer tracer) throws RTEException {
        super(hostPort, properties, aServiceType, tracer);
        this.ignoreHostNameInCertificate = DriverSapDB.getBooleanProperty(properties, "ignoreHostNameInCert", false);
        this.ignoreServerCertificate = DriverSapDB.getBooleanProperty(properties, "acceptServerCertAlways", false);
        this.openSocket();
    }

    protected void openSocket() throws RTEException {
        try {
            SSLContext sc = null;
            SSLSocketFactory factory = null;
            if (this.ignoreServerCertificate) {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                factory = sc.getSocketFactory();
            } else {
                factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            this.socket = factory.createSocket(this.host, this.lookupPort());
            SSLSocket sslsocket = (SSLSocket)this.socket;
            sslsocket.startHandshake();
            if (!this.ignoreHostNameInCertificate) {
                Certificate[] certs = sslsocket.getSession().getPeerCertificates();
                if (certs.length == 0) {
                    throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, "No certificate in SSL session", new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5);
                }
                try {
                    X509Certificate x509cert = (X509Certificate)certs[0];
                    X500Principal principal = x509cert.getSubjectX500Principal();
                    String rfc2253name = principal.getName("RFC2253");
                    if (!this.validate(rfc2253name, this.host)) {
                        throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, "Host name verification failed, found " + rfc2253name + ", expected CN=" + this.host, new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5);
                    }
                }
                catch (ClassCastException classCastEx) {
                    throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, "SSL connection works currently only with X509 certificates", new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5);
                }
            }
            try {
                sslsocket.setSoTimeout(this.socketTimeOut);
                sslsocket.setTcpNoDelay(true);
                sslsocket.setReceiveBufferSize(36864);
                sslsocket.setSendBufferSize(36864);
            }
            catch (SocketException socketEx) {
                // empty catch block
            }
            this.instream = this.socket.getInputStream();
            this.outstream = this.socket.getOutputStream();
        }
        catch (NoSuchAlgorithmException noSuchAlg) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, noSuchAlg.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5);
        }
        catch (KeyManagementException keyManagementEx) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host, keyManagementEx.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 5);
        }
        catch (UnknownHostException uhexc) {
            throw new RTEException(MessageTranslator.translate("error.unknown.host", this.host, uhexc.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[13])), RteC.CommunicationErrorCodeMap_C[13], this.m_tracer, 13);
        }
        catch (IOException ioexc) {
            throw new RTEException(MessageTranslator.translate("error.host.connect", this.host + ":" + this.port, ioexc.getMessage(), new Integer(RteC.CommunicationErrorCodeMap_C[5])), RteC.CommunicationErrorCodeMap_C[5], this.m_tracer, 13);
        }
    }

    private boolean validate(String rfc2253name, String host) {
        int comma = rfc2253name.indexOf(",");
        String commonNamePart = rfc2253name.substring(0, comma).toUpperCase();
        String compare = ("CN=" + host).toUpperCase();
        return compare.equals(commonNamePart);
    }

    protected BasicSocketComm getNewCommunication() throws RTEException {
        return new SecureCommunication(this.host + ":" + this.port, null, this.m_serviceType, this.m_tracer);
    }

    protected int getDefaultPort() {
        return 7270;
    }

    protected boolean supportsInfoRequest() {
        return true;
    }
}

