/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.tableau.editor;

import com.dbeaver.model.tableau.navigator.DBNTableauConnectionRelationNode;
import com.dbeaver.model.tableau.tds.TDSRelation;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.ui.editors.AbstractStorageEditorInput;
import org.jkiss.dbeaver.ui.editors.INavigatorEditorInput;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class TableauCustomQueryEditorInput
extends AbstractStorageEditorInput
implements INavigatorEditorInput {
    private final DBNTableauConnectionRelationNode node;

    public TableauCustomQueryEditorInput(@NotNull DBNTableauConnectionRelationNode node) {
        super(node.getNodeObject().getName(), (CharSequence)node.getNodeObject().getCustomQueryText(), false, StandardCharsets.UTF_8.displayName());
        this.node = node;
    }

    @NotNull
    public DBNTableauConnectionRelationNode getNavigatorNode() {
        return this.node;
    }

    public DBPProject getProject() {
        return this.node.getOwnerProject();
    }

    public TDSRelation getRelation() {
        return this.node.getNodeObject();
    }

    protected void handleContentSave(IProgressMonitor monitor) throws CoreException {
        try {
            this.node.getParentNode().getParentNode().getDataSource().updateCustomQueryText((DBRProgressMonitor)new DefaultProgressMonitor(monitor), this.node.getNodeObject(), this.getBuffer().toString());
        }
        catch (DBException e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof TableauCustomQueryEditorInput && CommonUtils.equalObjects((Object)((TableauCustomQueryEditorInput)((Object)obj)).getRelation(), (Object)this.getRelation());
    }
}

