/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.tools;

import com.dbeaver.data.compare.model.DCChangeOrder;
import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.DCRegistry;
import com.dbeaver.data.compare.model.exporter.DCExporterDescriptor;
import com.dbeaver.data.compare.model.tasks.DCCompareTaskSettings;
import com.dbeaver.data.compare.ui.internal.DCMessages;
import com.dbeaver.data.compare.ui.tools.DCCompareTaskWizard;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFileRemote;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DCCompareTaskWizardPageSettings
extends ActiveWizardPage<DCCompareTaskWizard> {
    private Button openViewerOnFinishCheckbox;
    private Button exportChangesCheckbox;
    private Button sourceTableButton;
    private Button targetTableButton;
    private Combo outputFormatCombo;
    private Combo outputOrderCombo;
    private TextWithOpenFile outputFileText;
    private Button limitComparedRowsCheckbox;
    private Spinner limitComparedRowsToSpinner;
    private Button limitDifferentRowsCheckbox;
    private Spinner limitDifferentRowsToSpinner;
    private Button limitFetchSizeCheckbox;
    private Spinner limitFetchSizeToSpinner;
    private Button showModifiedRowsCheckbox;
    private Button showDeletedRowsCheckbox;
    private Button showInsertedRowsCheckbox;
    private Button storeResultsInMemoryCheckbox;
    private Button openNewConnectionCheckbox;
    private Button queryRowsCountCheckbox;

    protected DCCompareTaskWizardPageSettings() {
        super(DCMessages.data_compare_wizard_name);
        this.setTitle(DCMessages.data_compare_wizard_settings_title);
        this.setDescription(DCMessages.data_compare_wizard_settings_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> this.updatePageCompletion());
        Group group = UIUtils.createControlGroup((Composite)composite, (String)DCMessages.data_compare_wizard_settings_group_general_title, (int)3, (int)768, (int)0);
        ((GridData)group.getLayoutData()).horizontalSpan = 2;
        this.openViewerOnFinishCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_general_open_compare_viewer_label, (String)DCMessages.data_compare_wizard_settings_group_general_open_compare_viewer_tip, (boolean)false, (int)3);
        this.openViewerOnFinishCheckbox.addSelectionListener(listener);
        this.exportChangesCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_general_export_to_file_label, (String)DCMessages.data_compare_wizard_settings_group_general_export_to_file_tip, (boolean)false, (int)3);
        this.exportChangesCheckbox.addSelectionListener(listener);
        UIUtils.createControlLabel((Composite)group, (String)"Apply changes to", (int)1).setLayoutData((Object)GridDataFactory.swtDefaults().indent(LayoutConstants.getIndent(), 0).create());
        this.sourceTableButton = UIUtils.createRadioButton((Composite)group, (String)"&Source table", (Object)true, null);
        this.targetTableButton = UIUtils.createRadioButton((Composite)group, (String)"&Target table", (Object)false, null);
        UIUtils.createControlLabel((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_general_output_order_label, (int)1).setLayoutData((Object)GridDataFactory.swtDefaults().indent(LayoutConstants.getIndent(), 0).create());
        this.outputOrderCombo = new Combo((Composite)group, 12);
        this.outputOrderCombo.setToolTipText(DCMessages.data_compare_wizard_settings_group_general_output_order_tip);
        this.outputOrderCombo.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        DCChangeOrder[] dCChangeOrderArray = DCChangeOrder.values();
        int n = dCChangeOrderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DCChangeOrder value = dCChangeOrderArray[n2];
            this.outputOrderCombo.add(value.localizedName());
            ++n2;
        }
        UIUtils.createControlLabel((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_general_output_format_label, (int)1).setLayoutData((Object)GridDataFactory.swtDefaults().indent(LayoutConstants.getIndent(), 0).create());
        this.outputFormatCombo = new Combo((Composite)group, 12);
        this.outputFormatCombo.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        this.outputFormatCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DCExporterDescriptor descriptor = (DCExporterDescriptor)this.outputFormatCombo.getData(this.outputFormatCombo.getText());
            this.outputFileText.setFilterExtensions(new String[]{"*." + descriptor.getExtension()});
            String path = IOUtils.getPathWithoutFileExtension((String)this.outputFileText.getText().trim());
            if (!path.isEmpty()) {
                this.outputFileText.setText(path + "." + descriptor.getExtension());
            }
        }));
        for (DCExporterDescriptor exporter : DCRegistry.getInstance().getExporters()) {
            this.outputFormatCombo.add(exporter.getName());
            this.outputFormatCombo.setData(exporter.getName(), (Object)exporter);
        }
        UIUtils.createControlLabel((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_general_output_file_label).setLayoutData((Object)GridDataFactory.swtDefaults().indent(LayoutConstants.getIndent(), 0).create());
        this.outputFileText = new TextWithOpenFileRemote((Composite)group, DCMessages.data_compare_wizard_settings_group_general_output_file_title, new String[]{"*.*"}, 8196, false, ((DCCompareTaskWizard)this.getWizard()).getProject());
        this.outputFileText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(UIUtils.getFontHeight((Control)group) * 50, -1).create());
        this.outputFileText.getTextControl().addModifyListener(e -> this.updatePageCompletion());
        group = UIUtils.createControlGroup((Composite)composite, (String)DCMessages.data_compare_wizard_settings_group_results_title, (int)2, (int)2, (int)0);
        this.limitComparedRowsCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_results_compared_rows_limit_label, (String)DCMessages.data_compare_wizard_settings_group_results_compared_rows_limit_tip, (boolean)false, (int)1);
        this.limitComparedRowsCheckbox.addSelectionListener(listener);
        GridData gd = GridDataFactory.fillDefaults().grab(true, false).hint(UIUtils.getFontHeight((Control)group) * 10, -1).create();
        this.limitComparedRowsToSpinner = UIUtils.createSpinner((Composite)group, null, (int)10000, (int)1, (int)Integer.MAX_VALUE);
        this.limitComparedRowsToSpinner.setLayoutData((Object)gd);
        this.limitDifferentRowsCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_results_different_rows_limit_label, (String)DCMessages.data_compare_wizard_settings_group_results_different_rows_limit_tip, (boolean)false, (int)1);
        this.limitDifferentRowsCheckbox.addSelectionListener(listener);
        this.limitDifferentRowsToSpinner = UIUtils.createSpinner((Composite)group, null, (int)10000, (int)1, (int)Integer.MAX_VALUE);
        this.limitDifferentRowsToSpinner.setLayoutData((Object)gd);
        this.limitFetchSizeCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_performance_fetch_size_label, (String)DCMessages.data_compare_wizard_settings_group_performance_fetch_size_tip, (boolean)false, (int)1);
        this.limitFetchSizeCheckbox.addSelectionListener(listener);
        this.limitFetchSizeToSpinner = UIUtils.createSpinner((Composite)group, null, (int)10000, (int)100, (int)Integer.MAX_VALUE);
        this.limitFetchSizeToSpinner.setLayoutData((Object)gd);
        this.showModifiedRowsCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_results_show_modified_rows_label, (String)DCMessages.data_compare_wizard_settings_group_results_show_modified_rows_tip, (boolean)false, (int)2);
        this.showModifiedRowsCheckbox.addSelectionListener(listener);
        this.showDeletedRowsCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_results_show_deleted_rows_label, (String)DCMessages.data_compare_wizard_settings_group_results_show_deleted_rows_tip, (boolean)false, (int)2);
        this.showDeletedRowsCheckbox.addSelectionListener(listener);
        this.showInsertedRowsCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_results_show_inserted_rows_label, (String)DCMessages.data_compare_wizard_settings_group_results_show_inserted_rows_tip, (boolean)false, (int)2);
        this.showInsertedRowsCheckbox.addSelectionListener(listener);
        group = UIUtils.createControlGroup((Composite)composite, (String)DCMessages.data_compare_wizard_settings_group_performance_title, (int)2, (int)2, (int)0);
        this.storeResultsInMemoryCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_performance_store_results_in_memory_label, (String)DCMessages.data_compare_wizard_settings_group_performance_store_results_in_memory_tip, (boolean)false, (int)2);
        this.openNewConnectionCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_performance_open_new_connections_label, (String)DCMessages.data_compare_wizard_settings_group_performance_open_new_connections_tip, (boolean)false, (int)2);
        this.queryRowsCountCheckbox = UIUtils.createCheckbox((Composite)group, (String)DCMessages.data_compare_wizard_settings_group_performance_query_rows_count_label, (String)DCMessages.data_compare_wizard_settings_group_performance_query_rows_count_tip, (boolean)false, (int)2);
        this.setControl((Control)composite);
    }

    public void activatePage() {
        DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        String outputFile = settings.getOutputFilePath();
        this.openViewerOnFinishCheckbox.setSelection(settings.isOpenViewerOnFinish());
        this.exportChangesCheckbox.setSelection(outputFile != null);
        this.outputFileText.setText(outputFile != null ? outputFile : "");
        this.sourceTableButton.setSelection(settings.getOutputRelation() == DCChangeRelation.SOURCE);
        this.targetTableButton.setSelection(settings.getOutputRelation() == DCChangeRelation.TARGET);
        this.outputOrderCombo.select(settings.getOutputOrder().ordinal());
        this.outputFormatCombo.setText(settings.getExporterDescriptor().getName());
        this.outputFormatCombo.notifyListeners(13, new Event());
        if (settings.getComparedRowsLimit() > 0) {
            this.limitComparedRowsCheckbox.setSelection(true);
            this.limitComparedRowsToSpinner.setSelection(settings.getComparedRowsLimit());
        } else {
            this.limitComparedRowsCheckbox.setSelection(false);
        }
        if (settings.getDifferentRowsLimit() > 0) {
            this.limitDifferentRowsCheckbox.setSelection(true);
            this.limitDifferentRowsToSpinner.setSelection(settings.getDifferentRowsLimit());
        } else {
            this.limitDifferentRowsCheckbox.setSelection(false);
        }
        if (settings.getFetchSize() > 0) {
            this.limitFetchSizeCheckbox.setSelection(true);
            this.limitFetchSizeToSpinner.setSelection(settings.getFetchSize());
        } else {
            this.limitFetchSizeCheckbox.setSelection(false);
        }
        this.storeResultsInMemoryCheckbox.setSelection(settings.isStoreResultsInMemory());
        this.showModifiedRowsCheckbox.setSelection(settings.isIncludeModifiedRows());
        this.showDeletedRowsCheckbox.setSelection(settings.isIncludeDeletedRows());
        this.showInsertedRowsCheckbox.setSelection(settings.isIncludeInsertedRows());
        this.openNewConnectionCheckbox.setSelection(settings.isOpenNewConnections());
        this.queryRowsCountCheckbox.setSelection(settings.isQueryRowsCount());
        this.updatePageCompletion();
    }

    public void deactivatePage() {
        DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        settings.setOpenViewerOnFinish(this.openViewerOnFinishCheckbox.getSelection());
        settings.setOutputFilePath(this.exportChangesCheckbox.getSelection() ? this.outputFileText.getText() : null);
        settings.setOutputRelation(this.sourceTableButton.getSelection() ? DCChangeRelation.SOURCE : DCChangeRelation.TARGET);
        settings.setOutputOrder(DCChangeOrder.values()[this.outputOrderCombo.getSelectionIndex()]);
        settings.setExporterDescriptor((DCExporterDescriptor)this.outputFormatCombo.getData(this.outputFormatCombo.getText()));
        settings.setComparedRowsLimit(this.limitComparedRowsCheckbox.getSelection() ? this.limitComparedRowsToSpinner.getSelection() : 0);
        settings.setDifferentRowsLimit(this.limitDifferentRowsCheckbox.getSelection() ? this.limitDifferentRowsToSpinner.getSelection() : 0);
        settings.setFetchSize(this.limitFetchSizeCheckbox.getSelection() ? this.limitFetchSizeToSpinner.getSelection() : 0);
        settings.setIncludeModifiedRows(this.showModifiedRowsCheckbox.getSelection());
        settings.setIncludeDeletedRows(this.showDeletedRowsCheckbox.getSelection());
        settings.setIncludeInsertedRows(this.showInsertedRowsCheckbox.getSelection());
        settings.setStoreResultsInMemory(this.storeResultsInMemoryCheckbox.getSelection());
        settings.setOpenNewConnections(this.openNewConnectionCheckbox.getSelection());
        settings.setQueryRowsCount(this.queryRowsCountCheckbox.getSelection());
    }

    public void performHelp() {
        ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Data-compare"));
    }

    protected void updatePageCompletion() {
        super.updatePageCompletion();
        this.outputFileText.setEnabled(this.exportChangesCheckbox.getSelection());
        this.sourceTableButton.setEnabled(this.exportChangesCheckbox.getSelection());
        this.targetTableButton.setEnabled(this.exportChangesCheckbox.getSelection());
        this.outputFormatCombo.setEnabled(this.exportChangesCheckbox.getSelection());
        this.outputOrderCombo.setEnabled(this.exportChangesCheckbox.getSelection());
        this.limitComparedRowsToSpinner.setEnabled(this.limitComparedRowsCheckbox.getSelection());
        this.limitDifferentRowsToSpinner.setEnabled(this.limitDifferentRowsCheckbox.getSelection());
        this.limitFetchSizeToSpinner.setEnabled(this.limitFetchSizeCheckbox.getSelection());
        ((DCCompareTaskWizard)this.getWizard()).updateTaskButtons();
    }

    protected boolean determinePageCompletion() {
        if (!this.openViewerOnFinishCheckbox.getSelection() && !this.exportChangesCheckbox.getSelection()) {
            this.setErrorMessage("Either choose to open viewer or to export diff");
            return false;
        }
        if (this.exportChangesCheckbox.getSelection() && CommonUtils.isEmptyTrimmed((String)this.outputFileText.getText())) {
            this.setErrorMessage("Output file path cannot be empty");
            return false;
        }
        if (!(this.showModifiedRowsCheckbox.getSelection() || this.showDeletedRowsCheckbox.getSelection() || this.showInsertedRowsCheckbox.getSelection())) {
            this.setErrorMessage("Choose at least one row type to show");
            return false;
        }
        return true;
    }
}

