/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.ui.tools;

import com.dbeaver.data.compare.model.tasks.DCCompareTaskSettings;
import com.dbeaver.data.compare.ui.internal.DCMessages;
import com.dbeaver.data.compare.ui.tools.DCCompareTaskWizard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomComboBoxCellEditor;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DCCompareTaskWizardPageMappings
extends ActiveWizardPage<DCCompareTaskWizard> {
    private static final StyledString.Styler STRIKEOUT_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle style) {
            style.strikeout = true;
        }
    };
    private final List<DBSAttributeBase> sourceAttributes = new ArrayList<DBSAttributeBase>();
    private final List<DBSAttributeBase> targetAttributes = new ArrayList<DBSAttributeBase>();
    private final Map<DBSAttributeBase, DBSAttributeBase> mappings = new HashMap<DBSAttributeBase, DBSAttributeBase>();
    private final Map<DBSAttributeBase, DBSAttributeBase> keys = new HashMap<DBSAttributeBase, DBSAttributeBase>();
    private TableViewer mappingViewer;
    private Button autoAssignButton;

    public DCCompareTaskWizardPageMappings() {
        super(DCMessages.data_compare_wizard_name);
        this.setTitle(DCMessages.data_compare_wizard_mappings_title);
        this.setDescription(DCMessages.data_compare_wizard_mappings_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mappingViewer = new TableViewer(composite, 67588);
        this.mappingViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.mappingViewer.getTable().setHeaderVisible(true);
        this.mappingViewer.getTable().setLinesVisible(true);
        this.mappingViewer.setContentProvider((IContentProvider)new ListContentProvider());
        TableViewerColumn sourceColumn = new TableViewerColumn(this.mappingViewer, 16384);
        sourceColumn.getColumn().setText(DCMessages.data_compare_wizard_mappings_table_source);
        sourceColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new MappingLabelProvider(true)));
        TableViewerColumn targetColumn = new TableViewerColumn(this.mappingViewer, 16384);
        targetColumn.getColumn().setText(DCMessages.data_compare_wizard_mappings_table_target);
        targetColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new MappingLabelProvider(false)));
        targetColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.mappingViewer){

            protected CellEditor getCellEditor(Object element) {
                ArrayList<String> attributes = new ArrayList<String>();
                attributes.add(DCMessages.data_compare_wizard_mappings_table_skip);
                for (DBSAttributeBase attribute : DCCompareTaskWizardPageMappings.this.targetAttributes) {
                    attributes.add(attribute.getName());
                }
                return new CustomComboBoxCellEditor((ColumnViewer)DCCompareTaskWizardPageMappings.this.mappingViewer, (Composite)DCCompareTaskWizardPageMappings.this.mappingViewer.getTable(), attributes.toArray(new String[0]), 12);
            }

            protected boolean canEdit(Object element) {
                return !DCCompareTaskWizardPageMappings.this.keys.containsKey((DBSAttributeBase)element);
            }

            protected Object getValue(Object element) {
                DBSAttributeBase target = DCCompareTaskWizardPageMappings.this.mappings.get((DBSAttributeBase)element);
                return target != null ? target.getName() : DCMessages.data_compare_wizard_mappings_table_skip;
            }

            protected void setValue(Object element, Object value) {
                DBSAttributeBase source = (DBSAttributeBase)element;
                if (DCMessages.data_compare_wizard_mappings_table_skip.equals(value)) {
                    DCCompareTaskWizardPageMappings.this.mappings.remove(source);
                    DCCompareTaskWizardPageMappings.this.mappingViewer.refresh();
                    DCCompareTaskWizardPageMappings.this.updatePageCompletion();
                    return;
                }
                DBSAttributeBase target = DCCompareTaskWizardPageMappings.this.targetAttributes.stream().filter(x -> x.getName().equals(value)).findAny().orElse(null);
                if (target != null) {
                    DCCompareTaskWizardPageMappings.this.mappings.values().remove(target);
                    DCCompareTaskWizardPageMappings.this.mappings.put(source, target);
                    DCCompareTaskWizardPageMappings.this.mappingViewer.refresh();
                    DCCompareTaskWizardPageMappings.this.updatePageCompletion();
                }
            }
        });
        this.autoAssignButton = UIUtils.createPushButton((Composite)composite, (String)DCMessages.data_compare_wizard_mappings_table_auto_assign, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.ASTERISK), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DCCompareTaskWizardPageMappings.this.autoAssignMappings();
                DCCompareTaskWizardPageMappings.this.mappingViewer.refresh();
                DCCompareTaskWizardPageMappings.this.updatePageCompletion();
            }
        });
        this.setControl((Control)composite);
    }

    public void activatePage() {
        final DCCompareTaskSettings settings = ((DCCompareTaskWizard)this.getWizard()).getSettings();
        this.sourceAttributes.clear();
        this.targetAttributes.clear();
        this.mappings.clear();
        AbstractJob job = new AbstractJob("Load entity attributes"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    monitor.beginTask("Load attributes", 1);
                    if (settings.getLeftContainer() != null) {
                        DCCompareTaskWizardPageMappings.this.sourceAttributes.addAll(DCCompareTaskWizardPageMappings.this.loadAttributes(settings.getLeftContainer(), monitor));
                    }
                    if (settings.getRightContainer() != null) {
                        DCCompareTaskWizardPageMappings.this.targetAttributes.addAll(DCCompareTaskWizardPageMappings.this.loadAttributes(settings.getRightContainer(), monitor));
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (DBException e) {
                    IStatus iStatus = GeneralUtils.makeErrorStatus((String)"Error loading attributes", (Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                List<DBSAttributeBase> sourceKeys = Arrays.asList(settings.getLeftKeys());
                List<DBSAttributeBase> targetKeys = Arrays.asList(settings.getRightKeys());
                DCCompareTaskWizardPageMappings.this.sourceAttributes.removeAll(sourceKeys);
                DCCompareTaskWizardPageMappings.this.targetAttributes.removeAll(targetKeys);
                int i = 0;
                while (i < sourceKeys.size()) {
                    DCCompareTaskWizardPageMappings.this.keys.put(sourceKeys.get(i), targetKeys.get(i));
                    ++i;
                }
                if (!settings.getMappings().isEmpty()) {
                    for (Map.Entry mapping : ((DCCompareTaskWizard)DCCompareTaskWizardPageMappings.this.getWizard()).getSettings().getMappings().entrySet()) {
                        DBSAttributeBase source = (DBSAttributeBase)mapping.getKey();
                        DBSAttributeBase target = (DBSAttributeBase)mapping.getValue();
                        if (!DCCompareTaskWizardPageMappings.this.sourceAttributes.contains(source) || !DCCompareTaskWizardPageMappings.this.targetAttributes.contains(target)) continue;
                        DCCompareTaskWizardPageMappings.this.mappings.put(source, target);
                    }
                } else {
                    DCCompareTaskWizardPageMappings.this.autoAssignMappings();
                }
                UIUtils.asyncExec(() -> {
                    ArrayList<DBSAttributeBase> input = new ArrayList<DBSAttributeBase>(sourceKeys.size() + DCCompareTaskWizardPageMappings.this.sourceAttributes.size());
                    input.addAll(sourceKeys);
                    input.addAll(DCCompareTaskWizardPageMappings.this.sourceAttributes);
                    DCCompareTaskWizardPageMappings.this.autoAssignButton.setEnabled(!DCCompareTaskWizardPageMappings.this.sourceAttributes.isEmpty());
                    DCCompareTaskWizardPageMappings.this.mappingViewer.setInput(input);
                    UIUtils.maxTableColumnsWidth((Table)DCCompareTaskWizardPageMappings.this.mappingViewer.getTable());
                    DCCompareTaskWizardPageMappings.this.updatePageCompletion();
                });
            }
        });
        job.schedule();
    }

    public void deactivatePage() {
        ((DCCompareTaskWizard)this.getWizard()).getSettings().setMappings(this.mappings);
    }

    protected boolean determinePageCompletion() {
        if (((DCCompareTaskWizard)this.getWizard()).getSettings().getLeftContainer() == null) {
            return false;
        }
        if (((DCCompareTaskWizard)this.getWizard()).getSettings().getRightContainer() == null) {
            return false;
        }
        if (this.mappings.isEmpty()) {
            this.setMessage(DCMessages.data_compare_wizard_mappings_error_no_mappings_present, 2);
        } else {
            this.setMessage(null);
        }
        return true;
    }

    private void autoAssignMappings() {
        this.mappings.clear();
        for (DBSAttributeBase source : this.sourceAttributes) {
            DBSAttributeBase target = this.targetAttributes.stream().filter(x -> x.getName().equalsIgnoreCase(source.getName())).findAny().orElse(null);
            if (target == null) continue;
            this.mappings.put(source, target);
        }
    }

    @NotNull
    private List<DBSAttributeBase> loadAttributes(@NotNull DBSDataContainer container, @NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<DBSAttributeBase> attributes = new ArrayList<DBSAttributeBase>();
        for (DBSAttributeBase attribute : DTUtils.getAttributes((DBRProgressMonitor)monitor, (DBSDataContainer)container, (Object)container)) {
            if (DBUtils.isHiddenObject((Object)attribute) || DBUtils.isPseudoAttribute((DBSAttributeBase)attribute)) continue;
            attributes.add(attribute);
            DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(monitor, (DBSObject)attribute, true);
        }
        return attributes;
    }

    private class MappingLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    IColorProvider {
        private final boolean left;

        public MappingLabelProvider(boolean left) {
            this.left = left;
        }

        public StyledString getStyledText(Object element) {
            DBSAttributeBase target;
            DBSAttributeBase source = (DBSAttributeBase)element;
            DBSAttributeBase dBSAttributeBase = target = DCCompareTaskWizardPageMappings.this.mappings.containsKey(source) ? DCCompareTaskWizardPageMappings.this.mappings.get(source) : DCCompareTaskWizardPageMappings.this.keys.get(source);
            if (this.left) {
                if (target == null) {
                    return new StyledString(source.getName(), STRIKEOUT_STYLER);
                }
                return new StyledString(source.getName(), null);
            }
            if (target != null) {
                return new StyledString(target.getName(), null);
            }
            return new StyledString(DCMessages.data_compare_wizard_mappings_table_skip, null);
        }

        public Image getImage(Object element) {
            DBNDatabaseNode node = DBNUtils.getNodeByObject((DBSObject)((DBSObject)element));
            if (node != null) {
                return DBeaverIcons.getImage((DBPImage)node.getNodeIcon());
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (DCCompareTaskWizardPageMappings.this.keys.containsKey((DBSAttributeBase)element)) {
                return DCCompareTaskWizardPageMappings.this.getShell().getDisplay().getSystemColor(18);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

