/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql.ui.auth;

import com.dbeaver.db.cosmos.nosql.DCosmosProperties;
import com.dbeaver.db.cosmos.nosql.auth.CosmosAuthKeyCredentials;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;

public class CosmosAuthKeyConfigurator
implements IObjectPropertyConfigurator<DBAAuthModel<CosmosAuthKeyCredentials>, DBPDataSourceContainer> {
    private Text keyText;

    public void createControl(@NotNull Composite parent, DBAAuthModel<CosmosAuthKeyCredentials> object, @NotNull Runnable propertyChangeListener) {
        UIUtils.createControlLabel((Composite)parent, (String)"Key");
        Composite filesGroup = UIUtils.createComposite((Composite)parent, (int)1);
        filesGroup.setLayoutData((Object)new GridData(768));
        this.keyText = new Text(filesGroup, 0x400800);
        this.keyText.setToolTipText("Key");
        this.keyText.setLayoutData((Object)new GridData(768));
    }

    public void loadSettings(@NotNull DBPDataSourceContainer container) {
        String savedKey = container.getConnectionConfiguration().getAuthProperty(DCosmosProperties.Connection.KEY.getName());
        this.keyText.setText(savedKey != null ? savedKey : "");
    }

    public void saveSettings(@NotNull DBPDataSourceContainer container) {
        container.getConnectionConfiguration().setAuthProperty(DCosmosProperties.Connection.KEY.getName(), this.keyText.getText().trim());
    }

    public void resetSettings(@NotNull DBPDataSourceContainer container) {
        this.keyText.setText("");
    }

    public boolean isComplete() {
        return !this.keyText.getText().isEmpty();
    }
}

