/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xml;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.FFTableReader;
import com.dbeaver.jdbc.files.xml.XmlNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class XmlTableReader
implements FFTableReader<XmlNode> {
    @NotNull
    private final List<ColumnInfo<XmlNode>> columns;
    @NotNull
    private final FFTableReader<XmlNode> reader;

    public XmlTableReader(@NotNull List<ColumnInfo<XmlNode>> columns, @NotNull FFTableReader<XmlNode> reader) {
        this.columns = columns;
        this.reader = reader;
    }

    @Nullable
    public XmlNode[] readRow() throws IOException {
        XmlNode[] row = (XmlNode[])this.reader.readRow();
        if (row == null) {
            return null;
        }
        Map<String, XmlNode> nodes = Arrays.stream(row).collect(Collectors.toMap(XmlNode::name, node -> node));
        XmlNode[] enriched = new XmlNode[this.columns.size()];
        int i = 0;
        while (i < this.columns.size()) {
            ColumnInfo<XmlNode> column = this.columns.get(i);
            XmlNode node2 = nodes.get(column.columnName());
            enriched[i] = node2 == null ? new XmlNode(column.columnName(), null) : node2;
            ++i;
        }
        return enriched;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean isClosed() {
        return this.reader.isClosed();
    }
}

