/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.yugabyte.oss.driver.internal.core.type.codec.extras.array.AbstractPrimitiveListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DoubleListToArrayCodec
extends AbstractPrimitiveListToArrayCodec<double[]> {
    public DoubleListToArrayCodec() {
        super(DataTypes.listOf(DataTypes.DOUBLE), GenericType.of(double[].class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        Objects.requireNonNull(javaClass);
        return double[].class.equals(javaClass);
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        Objects.requireNonNull(value);
        return value instanceof double[];
    }

    @Override
    protected int sizeOfComponentType() {
        return 8;
    }

    @Override
    protected void serializeElement(@NonNull ByteBuffer output, @NonNull double[] array, int index, @NonNull ProtocolVersion protocolVersion) {
        output.putDouble(array[index]);
    }

    @Override
    protected void deserializeElement(@NonNull ByteBuffer input, @NonNull double[] array, int index, @NonNull ProtocolVersion protocolVersion) {
        array[index] = input.getDouble();
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull double[] array, int index) {
        output.append(array[index]);
    }

    @Override
    protected void parseElement(@NonNull String input, @NonNull double[] array, int index) {
        array[index] = Double.parseDouble(input);
    }

    @Override
    @NonNull
    protected double[] newInstance(int size) {
        return new double[size];
    }
}

