/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.model;

import com.dbeaver.ee.scmp.SCMPConstants;
import com.dbeaver.ee.scmp.impl.liquibase.LBUtils;
import com.dbeaver.ee.scmp.model.CMPUtils;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.structure.DatabaseObject;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.task.DBTTaskSettingsInput;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class CMPOptions
implements DBTTaskSettingsInput<DBSObject> {
    private static final Log log = Log.getLog(CMPOptions.class);
    private static final String TAG_DO_CREATE = "doCreate";
    private static final String TAG_DO_DROP = "doDrop";
    private static final String TAG_DO_CHANGE = "doChange";
    private static final String TAG_QUOTE_ALL_OBJECTS_NAMES = "quoteAllObjectsNames";
    private static final String TAG_CASE_INSENSITIVE_COMPARE = "caseInsensitiveCompare";
    private static final String TAG_EXPORT_FILE = "exportFile";
    private static final String TAG_OUTPUT_FOLDER_PATH = "outputFolderPath";
    private static final String TAG_OUTPUT_FILE_PATTERN = "outputFilePattern";
    private static final String TAG_REPORT_ENGINE = "reportEngineId";
    private static final String TAG_LOG_LEVEL = "logLevel";
    private static final String TAG_PROJECT = "project";
    private static final String TAG_CONTAINERS_MAPPING = "containersMapping";
    private static final String TAG_SOURCE_CONTAINER_ID = "sourceContainerId";
    private static final String TAG_TARGET_CONTAINER_ID = "targetContainerId";
    private static final String TAG_SOURCE_OBJECTS = "sourceObjects";
    private static final String TAG_TARGET_OBJECTS = "targetObjects";
    private static final String TAG_ONLY_CHANGELOG = "onlyChangelog";
    private static final String TAG_EXCLUDED_OBJECTS = "excludedObjects";
    private static final String TAG_HAS_LICENSE = "hasLiquibaseLicense";
    private static final String DEFAULT_REPORT_DDL = "ddl";
    private final Map<DBSObjectContainer, DBSObjectContainer> containerMapping = new HashMap<DBSObjectContainer, DBSObjectContainer>();
    private final List<DBSObjectType> objectTypes = new ArrayList<DBSObjectType>();
    private Set<Class<? extends DatabaseObject>> excludedObjectTypes = new HashSet<Class<? extends DatabaseObject>>();
    private DBPDataSourceContainer sourceDataSourceContainer;
    private DBPDataSourceContainer targetDataSourceContainer;
    private List<DBSObject> sourceInputObjects = new ArrayList<DBSObject>();
    private List<DBSObject> targetInputObjects = new ArrayList<DBSObject>();
    private boolean onlyChangelog;
    private String diffEngineId;
    private String reportEngineId = "ddl";
    private boolean doCreate;
    private boolean doDrop;
    private boolean doChange;
    private boolean quoteAllObjectsNames;
    private boolean hasLiquibaseLicense;
    private boolean caseInsensitiveCompare;
    private SCMPConstants.LogLevels logLevel = SCMPConstants.LogLevels.OFF;
    private Path changeLog;
    private boolean exportFile;
    private String outputFolderPath;
    private String outputFilePattern;
    private Path outputFolder;

    public CMPOptions(@NotNull DBPPreferenceStore globalPreferences, boolean onlyChangelog) {
        this.onlyChangelog = onlyChangelog;
        this.iniDefaultPreferences(globalPreferences);
        this.doCreate = onlyChangelog || globalPreferences.getBoolean("@dbeaver-create-missing-objects@");
        this.doChange = globalPreferences.getBoolean("@dbeaver-alter-existing-objects@");
        this.doDrop = globalPreferences.getBoolean("@dbeaver-drop-unexpected-objects@");
        this.caseInsensitiveCompare = globalPreferences.getBoolean("case-insensitive-compare");
        this.quoteAllObjectsNames = globalPreferences.getBoolean("quote-all-objects");
        this.exportFile = globalPreferences.getBoolean("export-result-file");
        this.outputFolderPath = globalPreferences.getString("scmp.output-folder-path");
        this.outputFilePattern = globalPreferences.getString("scmp.output-file-pattern");
        if (CommonUtils.isEmpty((String)this.outputFilePattern) || this.outputFilePattern.startsWith(".")) {
            this.outputFilePattern = "compare-${database}-${timestamp}.sql";
        }
        this.reportEngineId = globalPreferences.getString("report-engine");
    }

    public CMPOptions(boolean isChangeLogOnly) {
        this.onlyChangelog = isChangeLogOnly;
    }

    public CMPOptions(boolean isChangeLogOnly, @NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> properties) {
        this.onlyChangelog = isChangeLogOnly;
        this.loadConfiguration(runnableContext, properties);
    }

    public DBPDataSourceContainer getSourceDataSourceContainer() {
        return this.sourceDataSourceContainer;
    }

    public void setSourceDataSourceContainer(DBPDataSourceContainer sourceDataSourceContainer) {
        this.sourceDataSourceContainer = sourceDataSourceContainer;
    }

    public DBPDataSourceContainer getTargetDataSourceContainer() {
        return this.targetDataSourceContainer;
    }

    public void setTargetDataSourceContainer(DBPDataSourceContainer targetDataSourceContainer) {
        this.targetDataSourceContainer = targetDataSourceContainer;
    }

    public List<DBSObject> getSourceInputObjects() {
        return this.sourceInputObjects;
    }

    public void setSourceInputObjects(List<DBSObject> sourceInputObjects) {
        this.sourceInputObjects = sourceInputObjects;
    }

    public List<DBSObject> getTargetInputObjects() {
        return this.targetInputObjects;
    }

    public void setTargetInputObjects(List<DBSObject> targetInputObjects) {
        this.targetInputObjects = targetInputObjects;
    }

    public boolean isOnlyChangelog() {
        return this.onlyChangelog;
    }

    @NotNull
    public List<DBSObjectType> getObjectTypes() {
        return this.objectTypes;
    }

    public String getDiffEngineId() {
        return this.diffEngineId;
    }

    public void setDiffEngineId(String diffEngineId) {
        this.diffEngineId = diffEngineId;
    }

    public String getReportEngineId() {
        return CommonUtils.isEmpty((String)this.reportEngineId) ? DEFAULT_REPORT_DDL : this.reportEngineId;
    }

    public void setReportEngineId(String reportEngineId) {
        this.reportEngineId = reportEngineId;
    }

    public boolean isDoCreate() {
        return this.doCreate;
    }

    public void setDoCreate(boolean doCreate) {
        this.doCreate = doCreate;
    }

    public boolean isDoDrop() {
        return this.doDrop;
    }

    public void setDoDrop(boolean doDrop) {
        this.doDrop = doDrop;
    }

    public boolean isDoChange() {
        return this.doChange;
    }

    public void setDoChange(boolean doChange) {
        this.doChange = doChange;
    }

    public boolean isCaseInsensitiveCompare() {
        return this.caseInsensitiveCompare;
    }

    public void setCaseInsensitiveCompare(boolean caseInsensitiveCompare) {
        this.caseInsensitiveCompare = caseInsensitiveCompare;
    }

    public boolean isQuoteAllObjectsNames() {
        return this.quoteAllObjectsNames;
    }

    @Nullable
    public Set<Class<? extends DatabaseObject>> getExcludedObjectTypes() {
        return this.excludedObjectTypes;
    }

    public void setExcludedObjectTypes(@NotNull Set<Class<? extends DatabaseObject>> excludedObjectTypes) {
        this.excludedObjectTypes = excludedObjectTypes;
    }

    public boolean isHasLiquibaseLicense() {
        return this.hasLiquibaseLicense;
    }

    public void setHasLiquibaseLicense(boolean hasLiquibaseLicense) {
        this.hasLiquibaseLicense = hasLiquibaseLicense;
    }

    @NotNull
    public SCMPConstants.LogLevels getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(SCMPConstants.LogLevels logLevel) {
        this.logLevel = logLevel;
    }

    @NotNull
    public Path getChangeLogFile() {
        return this.changeLog;
    }

    public void setChangeLog(Path changeLog) {
        this.changeLog = changeLog;
    }

    public boolean isExportFile() {
        return this.exportFile;
    }

    public void setExportFile(boolean exportFile) {
        this.exportFile = exportFile;
    }

    @Nullable
    public String getOutputFolderPath() {
        return this.outputFolderPath;
    }

    public void setOutputFolderPath(String outputFolderPath) {
        this.outputFolderPath = outputFolderPath;
    }

    public String getOutputFilePattern() {
        return this.outputFilePattern;
    }

    public void setOutputFilePattern(String outputFilePattern) {
        this.outputFilePattern = outputFilePattern;
    }

    public void refreshSchemaMappings(boolean force) {
        if (force) {
            this.containerMapping.clear();
        }
        List<DBSObjectContainer> sourceContainers = this.getSourceContainers();
        List<DBSObjectContainer> targetContainers = this.getTargetContainers();
        int i = 0;
        while (i < sourceContainers.size()) {
            if (i >= targetContainers.size()) break;
            DBSObjectContainer targetContainer = this.containerMapping.get(sourceContainers.get(i));
            if (targetContainer == null || !targetContainers.contains(targetContainer)) {
                this.containerMapping.put(sourceContainers.get(i), targetContainers.get(i));
            }
            ++i;
        }
    }

    @NotNull
    public List<DBSObjectContainer> getTargetContainers() {
        return CMPUtils.getContainers(this.targetInputObjects, DBSObjectContainer.class, false);
    }

    @NotNull
    public List<DBSObjectContainer> getSourceContainers() {
        return CMPUtils.getContainers(this.sourceInputObjects, DBSObjectContainer.class, false);
    }

    public void mapContainers(@NotNull DBSObjectContainer source, @Nullable DBSObjectContainer target) {
        if (target == null) {
            this.containerMapping.remove(source);
        } else {
            this.containerMapping.put(source, target);
        }
    }

    @Nullable
    public DBSObjectContainer getTargetContainer(@NotNull DBSObjectContainer sourceContainer) {
        return this.containerMapping.get(sourceContainer);
    }

    @Nullable
    public DBSObjectContainer getSourceContainer(@NotNull DBSObjectContainer targetContainer) {
        for (Map.Entry<DBSObjectContainer, DBSObjectContainer> entry : this.containerMapping.entrySet()) {
            if (entry.getValue() != targetContainer) continue;
            return entry.getKey();
        }
        return null;
    }

    @Nullable
    public DBSObjectContainer getSourceContainer(String containerName) {
        for (Map.Entry<DBSObjectContainer, DBSObjectContainer> entry : this.containerMapping.entrySet()) {
            if (!containerName.equalsIgnoreCase(entry.getValue().getName())) continue;
            return entry.getKey();
        }
        return null;
    }

    private void iniDefaultPreferences(DBPPreferenceStore globalPreferences) {
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)globalPreferences, (String)"@dbeaver-create-missing-objects@", (Object)true);
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)globalPreferences, (String)"@dbeaver-alter-existing-objects@", (Object)true);
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)globalPreferences, (String)"@dbeaver-drop-unexpected-objects@", (Object)true);
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)globalPreferences, (String)"case-insensitive-compare", (Object)false);
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)globalPreferences, (String)"quote-all-objects", (Object)true);
        PrefUtils.setDefaultPreferenceValue((DBPPreferenceStore)globalPreferences, (String)"export-result-file", (Object)false);
    }

    public void loadSettingsFromInput(List<DBSObject> inputObjects) {
    }

    public void loadConfiguration(@NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> properties) {
        try {
            runnableContext.run(true, true, monitor -> {
                Object object;
                DBPProject project;
                if (!properties.containsKey(TAG_PROJECT)) {
                    return;
                }
                String projectName = CommonUtils.toString(properties.get(TAG_PROJECT));
                DBPProject dBPProject = project = CommonUtils.isEmpty((String)projectName) ? null : DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
                if (project == null) {
                    log.error((Object)("Project '" + projectName + "' not found"));
                    return;
                }
                this.onlyChangelog = CommonUtils.getBoolean(properties.get(TAG_ONLY_CHANGELOG), (boolean)false);
                String sourceContainerId = JSONUtils.getString((Map)properties, (String)TAG_SOURCE_CONTAINER_ID);
                DBPDataSourceContainer dataSource = project.getDataSourceRegistry().getDataSource(sourceContainerId);
                if (dataSource == null) {
                    log.error((Object)("Datasource '" + sourceContainerId + "' not found"));
                    return;
                }
                this.sourceDataSourceContainer = dataSource;
                if (!this.onlyChangelog) {
                    String targetContainerId = JSONUtils.getString((Map)properties, (String)TAG_TARGET_CONTAINER_ID);
                    dataSource = project.getDataSourceRegistry().getDataSource(targetContainerId);
                    if (dataSource == null) {
                        log.error((Object)("Datasource '" + targetContainerId + "' not found"));
                    }
                    this.targetDataSourceContainer = dataSource;
                }
                List sourceObjects = JSONUtils.getStringList((Map)properties, (String)TAG_SOURCE_OBJECTS);
                for (String sourceObjectId : sourceObjects) {
                    object = this.loadObject(monitor, project, sourceObjectId);
                    if (object == null) continue;
                    this.sourceInputObjects.add((DBSObject)object);
                }
                if (!this.onlyChangelog) {
                    List targetObjects = JSONUtils.getStringList((Map)properties, (String)TAG_TARGET_OBJECTS);
                    for (String targetObjectId : targetObjects) {
                        object = this.loadObject(monitor, project, targetObjectId);
                        if (object == null) continue;
                        this.targetInputObjects.add((DBSObject)object);
                    }
                }
                this.doCreate = CommonUtils.getBoolean(properties.get(TAG_DO_CREATE), (boolean)true);
                this.doDrop = CommonUtils.getBoolean(properties.get(TAG_DO_DROP), (boolean)true);
                this.doChange = CommonUtils.getBoolean(properties.get(TAG_DO_CHANGE), (boolean)true);
                this.hasLiquibaseLicense = CommonUtils.getBoolean(properties.get(TAG_HAS_LICENSE), (boolean)false);
                this.quoteAllObjectsNames = CommonUtils.getBoolean(properties.get(TAG_QUOTE_ALL_OBJECTS_NAMES), (boolean)true);
                this.caseInsensitiveCompare = CommonUtils.getBoolean(properties.get(TAG_CASE_INSENSITIVE_COMPARE), (boolean)false);
                this.exportFile = CommonUtils.getBoolean(properties.get(TAG_EXPORT_FILE), (boolean)false);
                this.outputFolderPath = CommonUtils.toString(properties.get(TAG_OUTPUT_FOLDER_PATH), null);
                if (CommonUtils.isEmpty((String)this.outputFolderPath)) {
                    this.outputFolderPath = RuntimeUtils.getUserHomeDir().getAbsolutePath();
                }
                this.outputFilePattern = CommonUtils.toString(properties.get(TAG_OUTPUT_FILE_PATTERN), null);
                if (CommonUtils.isEmpty((String)this.outputFilePattern) || this.outputFilePattern.startsWith(".")) {
                    this.outputFilePattern = "compare-${database}-${timestamp}.sql";
                }
                this.reportEngineId = CommonUtils.toString(properties.get(TAG_REPORT_ENGINE), (String)DEFAULT_REPORT_DDL);
                String logLevel = CommonUtils.toString(properties.get(TAG_LOG_LEVEL), null);
                if (CommonUtils.isNotEmpty((String)logLevel)) {
                    this.logLevel = SCMPConstants.LogLevels.valueOf(logLevel);
                }
                List objectsList = JSONUtils.getStringList((Map)properties, (String)TAG_EXCLUDED_OBJECTS);
                for (String name : objectsList) {
                    try {
                        Class<?> aClass = Class.forName(name);
                        if (!DatabaseObject.class.isAssignableFrom(aClass)) continue;
                        this.excludedObjectTypes.add(aClass);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        log.debug((Object)("Can't find class " + name));
                    }
                }
                Map objectMap = JSONUtils.getObjectOrNull((Map)properties, (String)TAG_CONTAINERS_MAPPING);
                if (!CommonUtils.isEmpty((Map)objectMap)) {
                    for (Map.Entry entry : objectMap.entrySet()) {
                        DBSObject keyObject = this.loadObject(monitor, project, (String)entry.getKey());
                        DBSObject valueObject = this.loadObject(monitor, project, entry.getValue().toString());
                        if (!(keyObject instanceof DBSObjectContainer) || !(valueObject instanceof DBSObjectContainer)) continue;
                        this.containerMapping.put((DBSObjectContainer)keyObject, (DBSObjectContainer)valueObject);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getTargetException());
        }
        catch (InterruptedException e) {
            log.debug((Object)"Canceled by user", (Throwable)e);
        }
    }

    public void saveConfiguration(@NotNull Map<String, Object> state) {
        state.put(TAG_PROJECT, this.sourceDataSourceContainer.getProject().getName());
        state.put(TAG_ONLY_CHANGELOG, this.onlyChangelog);
        state.put(TAG_SOURCE_CONTAINER_ID, DBUtils.getObjectFullId((DBSObject)this.sourceDataSourceContainer));
        ArrayList<String> inputObjectsIds = new ArrayList<String>();
        for (DBSObject inputObject : this.sourceInputObjects) {
            if (inputObject instanceof DBNNode) {
                inputObjectsIds.add(((DBNNode)inputObject).getNodeUri());
                continue;
            }
            inputObjectsIds.add(DBUtils.getObjectFullId((DBSObject)inputObject));
        }
        state.put(TAG_SOURCE_OBJECTS, inputObjectsIds);
        if (!this.onlyChangelog) {
            if (this.targetDataSourceContainer != null) {
                state.put(TAG_TARGET_CONTAINER_ID, DBUtils.getObjectFullId((DBSObject)this.targetDataSourceContainer));
            }
            if (!this.targetInputObjects.isEmpty()) {
                List targetObjectsIds = this.targetInputObjects.stream().map(DBUtils::getObjectFullId).collect(Collectors.toList());
                state.put(TAG_TARGET_OBJECTS, targetObjectsIds);
            }
        }
        state.put(TAG_DO_CREATE, this.doCreate);
        state.put(TAG_DO_DROP, this.doDrop);
        state.put(TAG_DO_CHANGE, this.doChange);
        state.put(TAG_QUOTE_ALL_OBJECTS_NAMES, this.quoteAllObjectsNames);
        state.put(TAG_CASE_INSENSITIVE_COMPARE, this.caseInsensitiveCompare);
        state.put(TAG_EXPORT_FILE, this.exportFile);
        if (!CommonUtils.isEmptyTrimmed((String)this.outputFolderPath)) {
            state.put(TAG_OUTPUT_FOLDER_PATH, this.outputFolderPath);
        }
        if (!CommonUtils.isEmptyTrimmed((String)this.outputFilePattern)) {
            state.put(TAG_OUTPUT_FILE_PATTERN, this.outputFilePattern);
        }
        state.put(TAG_REPORT_ENGINE, this.reportEngineId);
        state.put(TAG_LOG_LEVEL, this.logLevel.name());
        if (!this.excludedObjectTypes.isEmpty()) {
            state.put(TAG_EXCLUDED_OBJECTS, this.excludedObjectTypes.stream().map(Class::getName).collect(Collectors.toList()));
        }
        if (!CommonUtils.isEmpty(this.containerMapping)) {
            HashMap<String, String> containersIDs = new HashMap<String, String>();
            for (Map.Entry<DBSObjectContainer, DBSObjectContainer> entry : this.containerMapping.entrySet()) {
                containersIDs.put(DBUtils.getObjectFullId((DBSObject)((DBSObject)entry.getKey())), DBUtils.getObjectFullId((DBSObject)((DBSObject)entry.getValue())));
            }
            state.put(TAG_CONTAINERS_MAPPING, containersIDs);
        }
        state.put(TAG_HAS_LICENSE, this.hasLiquibaseLicense);
    }

    @Nullable
    private DBSObject loadObject(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project, @NotNull String objectId) {
        monitor.beginTask("Load object '" + objectId + "'", 1);
        try {
            DBSObject dBSObject = DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)project, (String)objectId);
            return dBSObject;
        }
        catch (DBException e) {
            try {
                DBWorkbench.getPlatform().getNavigatorModel().getNodeByPath(monitor, project, objectId);
            }
            catch (DBException dBException) {
                log.error((Object)"Can't find node", (Throwable)e);
            }
            log.error((Object)("Can't find object '" + objectId + "' in project '" + project.getName() + "'"), (Throwable)e);
            return null;
        }
        finally {
            monitor.done();
        }
    }

    @NotNull
    private Path getOutputFolder(DBRProgressMonitor monitor, DBPProject project) throws DBException {
        if (this.outputFolder == null) {
            String folderPathStr = this.resolveVars(this.sourceDataSourceContainer, this.sourceInputObjects.isEmpty() ? null : this.sourceInputObjects.get(0), this.outputFolderPath);
            this.outputFolder = DBFUtils.resolvePathFromString((DBRProgressMonitor)monitor, (DBPProject)project, (String)folderPathStr);
        }
        return this.outputFolder;
    }

    @NotNull
    public Path getOutputFile(DBRProgressMonitor monitor, DBPProject project) throws DBException {
        String outFileName = this.resolveVars(this.sourceDataSourceContainer, this.sourceInputObjects.isEmpty() ? null : this.sourceInputObjects.get(0), this.getOutputFilePattern());
        return this.getOutputFolder(monitor, project).resolve(outFileName);
    }

    private String resolveVars(@NotNull DBPDataSourceContainer container, DBSObject object, String pattern) {
        return GeneralUtils.replaceVariables((String)pattern, name -> {
            switch (name) {
                case "project": {
                    return container.getProject().getName();
                }
                case "datasource": {
                    return container.getDataSource() != null ? container.getDataSource().getName() : "";
                }
                case "database": {
                    if (object instanceof DBSCatalog) {
                        return object.getName();
                    }
                    DBSCatalog catalog = (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)object);
                    return catalog != null ? catalog.getName() : container.getConnectionConfiguration().getDatabaseName();
                }
                case "host": {
                    return container.getConnectionConfiguration().getHostName();
                }
                case "schema": {
                    if (object instanceof DBSSchema) {
                        return object.getName();
                    }
                    DBSSchema schema = (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)object);
                    return schema != null ? schema.getName() : "";
                }
            }
            return LBUtils.replaceVariables(name);
        });
    }
}

