/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql.model;

import com.dbeaver.db.cosmos.nosql.DCosmosContainer;
import com.dbeaver.db.cosmos.nosql.DCosmosNoSQLDataSource;
import com.dbeaver.model.document.data.DBAbstractDocument;
import com.dbeaver.model.document.data.DBMapValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DCosmosItem
extends DBAbstractDocument<DCosmosNoSQLDataSource, Map<String, Object>>
implements DBDValueCloneable {
    private static final String DOCUMENT_ID = "id";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").serializeNulls().create();
    private static final Type DOCUMENT_MAP_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    @NotNull
    private final DCosmosContainer container;

    public DCosmosItem(@NotNull DCosmosNoSQLDataSource dataSource, @NotNull DCosmosContainer container, @NotNull Map<String, Object> rawValue) {
        super((DBPDataSource)dataSource, rawValue);
        this.container = container;
    }

    @Nullable
    public Object getDocumentId() {
        return ((Map)this.rawValue).get(DOCUMENT_ID);
    }

    @Nullable
    public Object getDocumentProperty(String name) {
        return ((Map)this.rawValue).get(name);
    }

    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull Writer writer) throws IOException, DBException {
        GSON.toJson(this.rawValue, (Appendable)writer);
    }

    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull Reader reader) throws IOException, DBException {
        this.rawValue = (Map)GSON.fromJson(reader, DOCUMENT_MAP_TYPE);
        this.markModified();
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return new DCosmosItem((DCosmosNoSQLDataSource)this.dataSource, this.container, (Map)this.rawValue);
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    public DCosmosItem copy() {
        return new DCosmosItem((DCosmosNoSQLDataSource)this.dataSource, this.container, new LinkedHashMap<String, Object>((Map)this.rawValue));
    }

    protected DBMapValue<DCosmosNoSQLDataSource> makeRawMap() {
        return new DBMapValue((DBPDataSource)((DCosmosNoSQLDataSource)this.dataSource), (Object)this.container, (Map)this.rawValue);
    }
}

