/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql.auth;

import com.dbeaver.db.cosmos.nosql.DCosmosProperties;
import com.dbeaver.db.cosmos.nosql.auth.CosmosAuthKeyCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class CosmosAuthModel
implements DBAAuthModel<CosmosAuthKeyCredentials> {
    public static final String ID = "cosmos-key";

    @NotNull
    public CosmosAuthKeyCredentials createCredentials() {
        return new CosmosAuthKeyCredentials();
    }

    @NotNull
    public CosmosAuthKeyCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        String authKey = configuration.getAuthProperty(DCosmosProperties.Connection.KEY.getName());
        CosmosAuthKeyCredentials credentials = new CosmosAuthKeyCredentials();
        credentials.setKey(authKey);
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull CosmosAuthKeyCredentials credentials) {
        configuration.setAuthProperty(DCosmosProperties.Connection.KEY.getName(), credentials.getKey());
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull CosmosAuthKeyCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        connProperties.put("key", configuration.getAuthProperties().get(DCosmosProperties.Connection.KEY.getName()));
        return credentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull CosmosAuthKeyCredentials credentials) throws DBException {
    }
}

