/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql;

import com.dbeaver.db.cosmos.nosql.DCosmosContainer;
import com.dbeaver.db.cosmos.nosql.DCosmosNoSQLDataSource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class DCosmosDatabase
implements DBSCatalog,
DBPRefreshableObject {
    private static final Log log = Log.getLog(DCosmosDatabase.class);
    @NotNull
    private final String id;
    @NotNull
    private final DCosmosNoSQLDataSource dataSource;
    @NotNull
    private final DContainerCache cache = new DContainerCache();

    public DCosmosDatabase(@NotNull String id, @NotNull DCosmosNoSQLDataSource dataSource) {
        this.id = id;
        this.dataSource = dataSource;
    }

    public Collection<DCosmosContainer> getContainers(@NotNull DBRProgressMonitor monitor) {
        try {
            return this.cache.getAllObjects(monitor, this);
        }
        catch (DBException e) {
            log.error((Object)"Error reading containers", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Nullable
    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getContainers(monitor);
    }

    @Nullable
    public DCosmosContainer getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (DCosmosContainer)this.cache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return DCosmosContainer.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    public DBSObject getParentObject() {
        return this.dataSource;
    }

    @NotNull
    public DCosmosNoSQLDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return "";
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.cache.clearCache();
        return this;
    }

    public String toString() {
        return this.id;
    }

    private static class DContainerCache
    extends BasicObjectCache<DCosmosDatabase, DCosmosContainer> {
        private DContainerCache() {
        }

        @NotNull
        public Collection<DCosmosContainer> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable DCosmosDatabase database) throws DBException {
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                this.loadObjects(monitor, database);
            }
            return this.getCachedObjects();
        }

        private void loadObjects(@NotNull DBRProgressMonitor monitor, @NotNull DCosmosDatabase database) {
            if (this.isFullyCached() || monitor.isCanceled()) {
                return;
            }
            DCosmosNoSQLDataSource dataSource = database.getDataSource();
            List<DCosmosContainer> containers = Objects.requireNonNull((List)dataSource.getClient().getDatabase(database.id).readAllContainers().collectList().block()).stream().map(container -> new DCosmosContainer(container.getId(), database, dataSource)).toList();
            this.setCache(containers);
        }
    }
}

