/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cosmos.nosql;

import com.azure.cosmos.models.ConflictResolutionPolicy;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.ExcludedPath;
import com.azure.cosmos.models.IncludedPath;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.UniqueKeyPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.meta.Property;

public final class DCosmosContainerProperties {
    private final String id;
    private final String resourceId;
    private final String eTag;
    private final String timestamp;
    private final String partitionKeyKind;
    private final String partitionKeyVersion;
    private final String partitionKeyPaths;
    private final String uniqueKeyPolicy;
    private final String indexingMode;
    private final String indexingAutomatic;
    private final String indexingIncludedPaths;
    private final String indexingExcludedPaths;
    private final String indexingComposite;
    private final String indexingSpatial;
    private final String defaultTTL;
    private final String analyticalStoreTTL;
    private final String conflictResolutionMode;
    private final String conflictResolutionPath;
    private final String conflictResolutionProcedure;

    public DCosmosContainerProperties(String id, String resourceId, String eTag, String timestamp, String partitionKeyKind, String partitionKeyVersion, String partitionKeyPaths, String uniqueKeyPolicy, String indexingMode, String indexingAutomatic, String indexingIncludedPaths, String indexingExcludedPaths, String indexingComposite, String indexingSpatial, String defaultTTL, String analyticalStoreTTL, String conflictResolutionMode, String conflictResolutionPath, String conflictResolutionProcedure) {
        this.id = id;
        this.resourceId = resourceId;
        this.eTag = eTag;
        this.timestamp = timestamp;
        this.partitionKeyKind = partitionKeyKind;
        this.partitionKeyVersion = partitionKeyVersion;
        this.partitionKeyPaths = partitionKeyPaths;
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        this.indexingMode = indexingMode;
        this.indexingAutomatic = indexingAutomatic;
        this.indexingIncludedPaths = indexingIncludedPaths;
        this.indexingExcludedPaths = indexingExcludedPaths;
        this.indexingComposite = indexingComposite;
        this.indexingSpatial = indexingSpatial;
        this.defaultTTL = defaultTTL;
        this.analyticalStoreTTL = analyticalStoreTTL;
        this.conflictResolutionMode = conflictResolutionMode;
        this.conflictResolutionPath = conflictResolutionPath;
        this.conflictResolutionProcedure = conflictResolutionProcedure;
    }

    @NotNull
    public static DCosmosContainerProperties fromProperties(@NotNull CosmosContainerProperties p) {
        String ts = DCosmosContainerProperties.fmtTimestamp(p.getTimestamp());
        PartitionKeyDefinition pkd = p.getPartitionKeyDefinition();
        String pkKind = DCosmosContainerProperties.safeToString(pkd != null ? pkd.getKind() : null);
        String pkVersion = DCosmosContainerProperties.safeToString(pkd != null ? pkd.getVersion() : null);
        String pkPaths = DCosmosContainerProperties.listToStr(pkd != null ? pkd.getPaths() : null);
        UniqueKeyPolicy ukp = p.getUniqueKeyPolicy();
        String uniqueKeys = DCosmosContainerProperties.formatUniqueKeys(ukp);
        IndexingPolicy ip = p.getIndexingPolicy();
        String idxMode = DCosmosContainerProperties.safeToString(ip != null ? ip.getIndexingMode() : null);
        String idxAuto = ip != null && ip.isAutomatic() != null ? (ip.isAutomatic().booleanValue() ? "Yes" : "No") : "N/A";
        String idxIncluded = DCosmosContainerProperties.formatIncludedPaths(ip);
        String idxExcluded = DCosmosContainerProperties.formatExcludedPaths(ip);
        String idxComposite = DCosmosContainerProperties.formatCompositeIndexes(ip);
        String idxSpatial = DCosmosContainerProperties.formatSpatialIndexes(ip);
        String ttlDefault = DCosmosContainerProperties.ttlToHuman(p.getDefaultTimeToLiveInSeconds());
        String ttlAnalytical = DCosmosContainerProperties.ttlToHuman(p.getAnalyticalStoreTimeToLiveInSeconds());
        ConflictResolutionPolicy crp = p.getConflictResolutionPolicy();
        String crMode = DCosmosContainerProperties.safeToString(crp != null ? crp.getMode() : null);
        String crPath = DCosmosContainerProperties.nullToNA(crp != null ? crp.getConflictResolutionPath() : null);
        String crProc = DCosmosContainerProperties.nullToNA(crp != null ? crp.getConflictResolutionProcedure() : null);
        return new DCosmosContainerProperties(p.getId(), p.getResourceId(), p.getETag(), ts, pkKind, pkVersion, pkPaths, uniqueKeys, idxMode, idxAuto, idxIncluded, idxExcluded, idxComposite, idxSpatial, ttlDefault, ttlAnalytical, crMode, crPath, crProc);
    }

    private static String fmtTimestamp(Instant ts) {
        return ts == null ? "N/A" : DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneOffset.UTC).format(ts);
    }

    private static String safeToString(Object o) {
        return o == null ? "N/A" : String.valueOf(o);
    }

    private static String nullToNA(String s) {
        return s == null || s.isEmpty() ? "N/A" : s;
    }

    private static String listToStr(List<String> list) {
        if (list == null || list.isEmpty()) {
            return "[]";
        }
        return list.stream().collect(Collectors.joining(", ", "[", "]"));
    }

    private static String ttlToHuman(Integer seconds) {
        if (seconds == null) {
            return "Off";
        }
        if (seconds == -1) {
            return "Infinite";
        }
        if (seconds == 0) {
            return "Off";
        }
        long s = seconds.intValue();
        long d = s / 86400L;
        long h = (s %= 86400L) / 3600L;
        long m = (s %= 3600L) / 60L;
        Object pretty = (String)(d > 0L ? d + "d " : "") + (String)(h > 0L ? h + "h " : "") + (String)(m > 0L ? m + "m " : "") + (String)(s > 0L ? (s %= 60L) + "s" : "");
        pretty = ((String)pretty).trim();
        return String.valueOf(seconds) + "s" + (String)(((String)pretty).isEmpty() ? "" : " (" + (String)pretty + ")");
    }

    private static String formatUniqueKeys(UniqueKeyPolicy ukp) {
        if (ukp == null || ukp.getUniqueKeys() == null || ukp.getUniqueKeys().isEmpty()) {
            return "[]";
        }
        return ukp.getUniqueKeys().stream().map(uk -> {
            List paths = uk.getPaths();
            String inside = paths == null || paths.isEmpty() ? "" : paths.stream().collect(Collectors.joining(", "));
            return "(" + inside + ")";
        }).collect(Collectors.joining(", ", "[", "]"));
    }

    private static String formatIncludedPaths(IndexingPolicy ip) {
        if (ip == null || ip.getIncludedPaths() == null || ip.getIncludedPaths().isEmpty()) {
            return "[]";
        }
        return ip.getIncludedPaths().stream().map(IncludedPath::getPath).filter(Objects::nonNull).collect(Collectors.joining(", ", "[", "]"));
    }

    private static String formatExcludedPaths(IndexingPolicy ip) {
        if (ip == null || ip.getExcludedPaths() == null || ip.getExcludedPaths().isEmpty()) {
            return "[]";
        }
        return ip.getExcludedPaths().stream().map(ExcludedPath::getPath).filter(Objects::nonNull).collect(Collectors.joining(", ", "[", "]"));
    }

    private static String formatCompositeIndexes(IndexingPolicy ip) {
        if (ip == null || ip.getCompositeIndexes() == null || ip.getCompositeIndexes().isEmpty()) {
            return "[]";
        }
        return ip.getCompositeIndexes().stream().map(list -> list.stream().map(cp -> cp.getPath() + " " + String.valueOf(cp.getOrder() == null ? "" : cp.getOrder())).collect(Collectors.joining(", ", "(", ")"))).collect(Collectors.joining(", ", "[", "]"));
    }

    private static String formatSpatialIndexes(IndexingPolicy ip) {
        if (ip == null || ip.getSpatialIndexes() == null || ip.getSpatialIndexes().isEmpty()) {
            return "[]";
        }
        return ip.getSpatialIndexes().stream().map(spec -> {
            String path = spec.getPath();
            String types = spec.getSpatialTypes() == null || spec.getSpatialTypes().isEmpty() ? "[]" : spec.getSpatialTypes().stream().map(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
            return (path == null ? "N/A" : path) + ": " + types;
        }).collect(Collectors.joining(", ", "[", "]"));
    }

    @Property(id="id", viewable=true, order=1)
    public String getId() {
        return this.id;
    }

    @Property(id="resourceId", viewable=true, order=2)
    public String getResourceId() {
        return this.resourceId;
    }

    @Property(id="eTag", viewable=true, order=3)
    public String getETag() {
        return this.eTag;
    }

    @Property(id="timestamp", viewable=true, order=4)
    public String getTimestamp() {
        return this.timestamp;
    }

    @Property(id="partitionKeyKind", viewable=true, order=10)
    public String getPartitionKeyKind() {
        return this.partitionKeyKind;
    }

    @Property(id="partitionKeyVersion", viewable=true, order=11)
    public String getPartitionKeyVersion() {
        return this.partitionKeyVersion;
    }

    @Property(id="partitionKeyPaths", viewable=true, order=12)
    public String getPartitionKeyPaths() {
        return this.partitionKeyPaths;
    }

    @Property(id="uniqueKeyPolicy", viewable=true, order=20)
    public String getUniqueKeyPolicy() {
        return this.uniqueKeyPolicy;
    }

    @Property(id="indexingMode", viewable=true, order=30)
    public String getIndexingMode() {
        return this.indexingMode;
    }

    @Property(id="indexingAutomatic", viewable=true, order=31)
    public String getIndexingAutomatic() {
        return this.indexingAutomatic;
    }

    @Property(id="indexingIncludedPaths", viewable=true, order=32)
    public String getIndexingIncludedPaths() {
        return this.indexingIncludedPaths;
    }

    @Property(id="indexingExcludedPaths", viewable=true, order=33)
    public String getIndexingExcludedPaths() {
        return this.indexingExcludedPaths;
    }

    @Property(id="indexingCompositeIndexes", viewable=true, order=34)
    public String getIndexingComposite() {
        return this.indexingComposite;
    }

    @Property(id="indexingSpatialIndexes", viewable=true, order=35)
    public String getIndexingSpatial() {
        return this.indexingSpatial;
    }

    @Property(id="defaultTTL", viewable=true, order=40)
    public String getDefaultTTL() {
        return this.defaultTTL;
    }

    @Property(id="analyticalStoreTTL", viewable=true, order=41)
    public String getAnalyticalStoreTTL() {
        return this.analyticalStoreTTL;
    }

    @Property(id="conflictResolutionMode", viewable=true, order=50)
    public String getConflictResolutionMode() {
        return this.conflictResolutionMode;
    }

    @Property(id="conflictResolutionPath", viewable=true, order=51)
    public String getConflictResolutionPath() {
        return this.conflictResolutionPath;
    }

    @Property(id="conflictResolutionProcedure", viewable=true, order=52)
    public String getConflictResolutionProcedure() {
        return this.conflictResolutionProcedure;
    }
}

