/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite.ui.dialog;

import com.dbeaver.db.sqlite.ui.internal.SQLiteUIMessages;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class AttachDatabaseDialog
extends BaseDialog {
    private Text nameText;
    private TextWithOpen fileText;
    String name;
    String file;
    private Control infoLabel;

    public AttachDatabaseDialog(Shell parentShell) {
        super(parentShell, SQLiteUIMessages.dialog_database_attach_title, null);
    }

    public String getName() {
        return this.name;
    }

    public String getFile() {
        return this.file;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite placeholder = UIUtils.createComposite((Composite)composite, (int)2);
        placeholder.setLayoutData((Object)new GridData(768));
        this.nameText = UIUtils.createLabelText((Composite)placeholder, (String)SQLiteUIMessages.dialog_database_attach_name, (String)"");
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(e -> this.updateCompletion());
        Label file = UIUtils.createLabel((Composite)placeholder, (String)SQLiteUIMessages.dialog_database_attach_path);
        file.setLayoutData((Object)new GridData(768));
        this.fileText = new TextWithOpenFile(placeholder, SQLiteUIMessages.dialog_database_attach_title, new String[]{"*.db"});
        this.fileText.setLayoutData((Object)new GridData(768));
        this.fileText.getTextControl().addModifyListener(e -> this.updateCompletion());
        this.infoLabel = UIUtils.createInfoLabel((Composite)parent, (String)SQLiteUIMessages.dialog_database_tip);
        this.infoLabel.setVisible(false);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.updateCompletion();
        return buttonBar;
    }

    private void updateCompletion() {
        Button okButton;
        boolean pathIsValid;
        String name = this.nameText.getText();
        boolean nameIsValid = !name.isEmpty() && !name.contains(",") && !name.equals("temp") && !name.equals("main");
        this.infoLabel.setVisible("temp".equals(name) | "main".equals(name));
        if (!this.fileText.getText().isEmpty()) {
            try {
                Path path = Path.of(this.fileText.getText(), new String[0]);
                pathIsValid = path.toFile().exists();
            }
            catch (InvalidPathException invalidPathException) {
                pathIsValid = false;
            }
        } else {
            pathIsValid = false;
        }
        if ((okButton = this.getButton(0)) != null) {
            okButton.setEnabled(nameIsValid && pathIsValid);
        }
    }

    protected void okPressed() {
        this.name = this.nameText.getText();
        this.file = this.fileText.getText();
        super.okPressed();
    }
}

