/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.debug.DBGException;
import org.jkiss.dbeaver.debug.DBGSession;
import org.jkiss.dbeaver.debug.DBGStackFrame;
import org.jkiss.dbeaver.debug.core.DebugUtils;
import org.jkiss.dbeaver.debug.core.model.DatabaseDebugElement;
import org.jkiss.dbeaver.debug.core.model.DatabaseStackFrame;
import org.jkiss.dbeaver.debug.core.model.IDatabaseDebugTarget;
import org.jkiss.dbeaver.debug.internal.core.DebugCoreMessages;

public class DatabaseThread
extends DatabaseDebugElement
implements IThread {
    private boolean stepping = false;
    private String name = DebugCoreMessages.DatabaseThread_name;
    private List<DatabaseStackFrame> frames = new ArrayList<DatabaseStackFrame>(1);

    public DatabaseThread(IDatabaseDebugTarget target) {
        super(target);
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean canResume() {
        return this.getDebugTarget().canResume();
    }

    public boolean canSuspend() {
        return this.getDebugTarget().canSuspend();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.aboutToResume(32, false);
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.getDatabaseDebugTarget().canStepInto();
    }

    public boolean canStepOver() {
        return this.getDatabaseDebugTarget().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getDatabaseDebugTarget().canStepReturn();
    }

    public boolean isStepping() {
        return this.stepping;
    }

    public void stepInto() throws DebugException {
        this.aboutToResume(1, true);
        this.getDatabaseDebugTarget().stepInto();
    }

    public void stepOver() throws DebugException {
        this.aboutToResume(2, true);
        this.getDatabaseDebugTarget().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.aboutToResume(4, true);
        this.getDatabaseDebugTarget().stepReturn();
    }

    private void aboutToResume(int detail, boolean stepping) {
        this.frames.clear();
        this.setStepping(stepping);
        this.fireResumeEvent(detail);
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.frames.clear();
        this.getDebugTarget().terminate();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended() && this.frames.size() == 0) {
            this.extractStackFrames();
        }
        return this.frames.toArray(new IStackFrame[this.frames.size()]);
    }

    protected void extractStackFrames() throws DebugException {
        try {
            IDatabaseDebugTarget debugTarget = this.getDatabaseDebugTarget();
            DBGSession session = debugTarget.getSession();
            if (session != null) {
                List<? extends DBGStackFrame> stackFrames = session.getStack();
                this.rebuildStack(stackFrames);
            }
        }
        catch (DBGException e) {
            String message = NLS.bind((String)"Error reading stack for {0}", (Object)this.getName());
            Status status = DebugUtils.newErrorStatus(message, (Throwable)((Object)e));
            throw new DebugException((IStatus)status);
        }
    }

    public boolean hasStackFrames() throws DebugException {
        return true;
    }

    public void rebuildStack(List<? extends DBGStackFrame> stackFrames) {
        for (DBGStackFrame dBGStackFrame : stackFrames) {
            this.addFrame(dBGStackFrame);
        }
    }

    private void addFrame(DBGStackFrame stackFrameId) {
        DatabaseStackFrame frame = new DatabaseStackFrame(this, stackFrameId);
        this.frames.add(frame);
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (this.isSuspended()) {
            if (this.frames.size() == 0) {
                this.extractStackFrames();
            }
            if (this.frames.size() > 0) {
                return this.frames.get(0);
            }
        }
        return null;
    }

    public IBreakpoint[] getBreakpoints() {
        return null;
    }

    public void resumedByTarget() {
        this.aboutToResume(32, false);
    }

    public void setStepping(boolean stepping) {
        this.stepping = stepping;
    }
}

