/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.salesforce.ui;

import com.dbeaver.db.salesforce.model.auth.SalesForceOAuthModel;
import com.dbeaver.db.salesforce.ui.SalesForceUIMessages;
import com.dbeaver.jdbc.salesforce.SalesforceOAuthFlow;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class SalesForceOAuthConfigurator
implements IObjectPropertyConfigurator<SalesForceOAuthModel, DBPDataSourceContainer> {
    private Text clientIDText;
    private Text clientSecretText;
    private Combo oauthFlowType;

    public void createControl(@NotNull Composite authPanel, SalesForceOAuthModel object, @NotNull Runnable propertyChangeListener) {
        this.clientIDText = UIUtils.createLabelText((Composite)authPanel, (String)SalesForceUIMessages.auth_configurator_client_id, (String)"", (int)0x400800);
        this.clientIDText.setMessage(SalesForceUIMessages.auth_configurator_client_id_message);
        this.clientIDText.setToolTipText(SalesForceUIMessages.auth_configurator_client_id_tip);
        this.clientSecretText = UIUtils.createLabelText((Composite)authPanel, (String)SalesForceUIMessages.auth_configurator_client_secret, (String)"", (int)0x400800);
        this.clientSecretText.setMessage(SalesForceUIMessages.auth_configurator_client_secret_message);
        this.clientSecretText.setToolTipText(SalesForceUIMessages.auth_configurator_client_secret_tip);
        this.oauthFlowType = UIUtils.createLabelCombo((Composite)authPanel, (String)SalesForceUIMessages.auth_configurator_oauth_flow_type, (String)SalesForceUIMessages.auth_configurator_oauth_flow_type_tip, (int)2056);
        SalesforceOAuthFlow[] salesforceOAuthFlowArray = SalesforceOAuthFlow.values();
        int n = salesforceOAuthFlowArray.length;
        int n2 = 0;
        while (n2 < n) {
            SalesforceOAuthFlow value = salesforceOAuthFlowArray[n2];
            this.oauthFlowType.add(value.getName());
            ++n2;
        }
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        if (this.clientIDText != null && !this.clientIDText.isDisposed()) {
            this.clientIDText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("client_id")));
        }
        if (this.clientSecretText != null && !this.clientSecretText.isDisposed()) {
            this.clientSecretText.setText(CommonUtils.notEmpty((String)connectionInfo.getAuthProperty("client_secret")));
        }
        if (this.oauthFlowType != null && !this.oauthFlowType.isDisposed()) {
            String flowType = connectionInfo.getAuthProperty("oauth_flow_type");
            if (CommonUtils.isEmpty((String)flowType)) {
                flowType = SalesforceOAuthFlow.OAUTH2_CODE.getName();
            }
            this.oauthFlowType.setText(flowType);
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
        if (this.clientIDText != null && !this.clientIDText.isDisposed()) {
            connectionInfo.setAuthProperty("client_id", this.clientIDText.getText().trim());
        }
        if (this.clientSecretText != null && !this.clientSecretText.isDisposed()) {
            connectionInfo.setAuthProperty("client_secret", this.clientSecretText.getText().trim());
        }
        if (this.oauthFlowType != null && !this.oauthFlowType.isDisposed()) {
            String flowType = this.oauthFlowType.getText().trim();
            if (CommonUtils.isEmpty((String)flowType)) {
                flowType = SalesforceOAuthFlow.OAUTH2_CODE.getName();
            }
            connectionInfo.setAuthProperty("oauth_flow_type", flowType);
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        this.loadSettings(dataSourceContainer);
    }

    public boolean isComplete() {
        return !this.clientIDText.getText().isEmpty();
    }
}

