/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.files.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.IOUtils;

public class FFExecutionContext
extends GenericExecutionContext {
    private static final Log log = Log.getLog(FFExecutionContext.class);
    private static final String INTERNAL_DB_FILE_DIR_PREFIX = "ff";
    private volatile Path tempFolder;

    public FFExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getDbTempFolder() throws IOException {
        if (this.tempFolder != null) {
            return this.tempFolder;
        }
        FFExecutionContext fFExecutionContext = this;
        synchronized (fFExecutionContext) {
            if (this.tempFolder == null) {
                String datasourceId = this.getDataSource().getContainer().getId();
                String tempDirName = "ff-" + datasourceId + "-" + System.nanoTime() + "-db";
                this.tempFolder = DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), tempDirName);
            }
            return this.tempFolder;
        }
    }

    public void close() {
        super.close();
        if (this.tempFolder != null && Files.exists(this.tempFolder, new LinkOption[0])) {
            try {
                IOUtils.deleteDirectory((Path)this.tempFolder);
            }
            catch (Exception e) {
                log.error((Object)("Error deleting temp folder " + String.valueOf(this.tempFolder)), (Throwable)e);
            }
        }
    }
}

