/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.MonitoredResource;
import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcResponseMetadata;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.auth.Credentials;
import com.google.bigtable.v2.AuthorizedViewName;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsRequest;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ResponseParams;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.TableName;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableCloudMonitoringExporter;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableExporterUtils;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableGrpcStreamTracer;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.CallOptions;
import io.grpc.ClientStreamTracer;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.opencensus.tags.TagValue;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@InternalApi(value="For internal use only")
public class Util {
    static final Metadata.Key<String> ATTEMPT_HEADER_KEY = Metadata.Key.of((String)"bigtable-attempt", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    static final Metadata.Key<String> ATTEMPT_EPOCH_KEY = Metadata.Key.of((String)"bigtable-client-attempt-epoch-usec", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SERVER_TIMING_HEADER_KEY = Metadata.Key.of((String)"server-timing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Pattern SERVER_TIMING_HEADER_PATTERN = Pattern.compile(".*dur=(?<dur>\\d+)");
    static final Metadata.Key<byte[]> LOCATION_METADATA_KEY = Metadata.Key.of((String)"x-goog-ext-425905942-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);

    static String extractStatus(@Nullable Throwable error) {
        if (error == null) {
            return StatusCode.Code.OK.toString();
        }
        String statusString = error instanceof CancellationException ? Status.Code.CANCELLED.toString() : (error instanceof ApiException ? ((ApiException)error).getStatusCode().getCode().toString() : (error instanceof StatusRuntimeException ? ((StatusRuntimeException)error).getStatus().getCode().toString() : (error instanceof StatusException ? ((StatusException)error).getStatus().getCode().toString() : StatusCode.Code.UNKNOWN.toString())));
        return statusString;
    }

    static TagValue extractStatusFromFuture(Future<?> future) {
        Throwable error = null;
        try {
            future.get();
        }
        catch (InterruptedException e) {
            error = e;
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            error = e.getCause();
        }
        catch (RuntimeException e) {
            error = e;
        }
        return TagValue.create((String)Util.extractStatus(error));
    }

    static String extractTableId(Object request) {
        String tableName = null;
        String authorizedViewName = null;
        if (request instanceof ReadRowsRequest) {
            tableName = ((ReadRowsRequest)request).getTableName();
            authorizedViewName = ((ReadRowsRequest)request).getAuthorizedViewName();
        } else if (request instanceof MutateRowsRequest) {
            tableName = ((MutateRowsRequest)request).getTableName();
            authorizedViewName = ((MutateRowsRequest)request).getAuthorizedViewName();
        } else if (request instanceof MutateRowRequest) {
            tableName = ((MutateRowRequest)request).getTableName();
            authorizedViewName = ((MutateRowRequest)request).getAuthorizedViewName();
        } else if (request instanceof SampleRowKeysRequest) {
            tableName = ((SampleRowKeysRequest)request).getTableName();
            authorizedViewName = ((SampleRowKeysRequest)request).getAuthorizedViewName();
        } else if (request instanceof CheckAndMutateRowRequest) {
            tableName = ((CheckAndMutateRowRequest)request).getTableName();
            authorizedViewName = ((CheckAndMutateRowRequest)request).getAuthorizedViewName();
        } else if (request instanceof ReadModifyWriteRowRequest) {
            tableName = ((ReadModifyWriteRowRequest)request).getTableName();
            authorizedViewName = ((ReadModifyWriteRowRequest)request).getAuthorizedViewName();
        } else if (request instanceof GenerateInitialChangeStreamPartitionsRequest) {
            tableName = ((GenerateInitialChangeStreamPartitionsRequest)request).getTableName();
        } else if (request instanceof ReadChangeStreamRequest) {
            tableName = ((ReadChangeStreamRequest)request).getTableName();
        }
        if (tableName != null && !tableName.isEmpty()) {
            return TableName.parse((String)tableName).getTable();
        }
        if (authorizedViewName != null && !authorizedViewName.isEmpty()) {
            return AuthorizedViewName.parse((String)authorizedViewName).getTable();
        }
        return "<unspecified>";
    }

    static Map<String, List<String>> createStatsHeaders(ApiCallContext apiCallContext) {
        ImmutableMap.Builder headers = ImmutableMap.builder();
        headers.put((Object)ATTEMPT_EPOCH_KEY.name(), Arrays.asList(String.valueOf(Instant.EPOCH.until(Instant.now(), ChronoUnit.MICROS))));
        if (apiCallContext.getTracer() instanceof BigtableTracer) {
            int attemptCount = ((BigtableTracer)apiCallContext.getTracer()).getAttempt();
            headers.put((Object)ATTEMPT_HEADER_KEY.name(), Arrays.asList(String.valueOf(attemptCount)));
        }
        return headers.build();
    }

    private static Long getGfeLatency(@Nullable Metadata metadata) {
        if (metadata == null) {
            return null;
        }
        String serverTiming = (String)metadata.get(SERVER_TIMING_HEADER_KEY);
        if (serverTiming == null) {
            return null;
        }
        Matcher matcher = SERVER_TIMING_HEADER_PATTERN.matcher(serverTiming);
        if (matcher.find()) {
            long latency = Long.valueOf(matcher.group("dur"));
            return latency;
        }
        return null;
    }

    private static ResponseParams getResponseParams(@Nullable Metadata metadata) {
        if (metadata == null) {
            return null;
        }
        byte[] responseParams = (byte[])metadata.get(LOCATION_METADATA_KEY);
        if (responseParams != null) {
            try {
                return ResponseParams.parseFrom((byte[])responseParams);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
        }
        return null;
    }

    static void recordMetricsFromMetadata(GrpcResponseMetadata responseMetadata, BigtableTracer tracer, Throwable throwable) {
        Metadata metadata = responseMetadata.getMetadata();
        ResponseParams responseParams = Util.getResponseParams(responseMetadata.getMetadata());
        if (responseParams == null) {
            responseParams = Util.getResponseParams(responseMetadata.getTrailingMetadata());
        }
        if (responseParams != null) {
            tracer.setLocations(responseParams.getZoneId(), responseParams.getClusterId());
        }
        Long latency = Util.getGfeLatency(metadata);
        if (responseParams != null && latency == null) {
            latency = 0L;
        }
        tracer.recordGfeMetadata(latency, throwable);
    }

    static GrpcCallContext injectBigtableStreamTracer(ApiCallContext context, GrpcResponseMetadata responseMetadata, BigtableTracer tracer) {
        if (context instanceof GrpcCallContext) {
            GrpcCallContext callContext = (GrpcCallContext)context;
            CallOptions callOptions = callContext.getCallOptions();
            return responseMetadata.addHandlers((ApiCallContext)callContext.withCallOptions(callOptions.withStreamTracerFactory((ClientStreamTracer.Factory)new BigtableGrpcStreamTracer.Factory(tracer))));
        }
        throw new RuntimeException("Unexpected context class: " + context.getClass().getName());
    }

    public static OpenTelemetrySdk newInternalOpentelemetry(EnhancedBigtableStubSettings settings, Credentials credentials) throws IOException {
        SdkMeterProviderBuilder meterProviderBuilder = SdkMeterProvider.builder();
        for (Map.Entry<InstrumentSelector, View> e : BuiltinMetricsConstants.getInternalViews().entrySet()) {
            meterProviderBuilder.registerView(e.getKey(), e.getValue());
        }
        meterProviderBuilder.registerMetricReader((MetricReader)PeriodicMetricReader.create((MetricExporter)BigtableCloudMonitoringExporter.create("application metrics", credentials, settings.getMetricsEndpoint(), settings.getUniverseDomain(), new BigtableCloudMonitoringExporter.InternalTimeSeriesConverter((Supplier<MonitoredResource>)Suppliers.memoize(() -> BigtableExporterUtils.createInternalMonitoredResource(settings))))));
        return OpenTelemetrySdk.builder().setMeterProvider(meterProviderBuilder.build()).build();
    }
}

