/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.license;

import com.dbeaver.lm.api.LMException;
import com.dbeaver.lm.api.LMLicense;
import com.dbeaver.lm.api.LMLicenseManager;
import com.dbeaver.lm.api.LMLicenseType;
import com.dbeaver.lm.api.LMProduct;
import com.dbeaver.model.DBPApplicationEAP;
import com.dbeaver.model.license.app.DBPApplicationLicensed;
import com.dbeaver.model.license.app.LMAppUtils;
import com.dbeaver.model.license.embedded.LicenseServiceEmbedded;
import com.dbeaver.model.license.validate.LMPublicAPI;
import com.dbeaver.ui.license.LicenseEAPDialog;
import com.dbeaver.ui.license.LicenseImportDialog;
import com.dbeaver.ui.license.LicenseInfoDialog;
import com.dbeaver.ui.license.LicenseManagementDialog;
import com.dbeaver.ui.license.LicenseMissingDialog;
import com.dbeaver.ui.license.LicenseRenewsDialog;
import com.dbeaver.ui.license.LicenseRestartEAPDialog;
import com.dbeaver.ui.license.LicenseTrialDialog;
import com.dbeaver.ui.license.internal.LMUIMessages;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.rcp.DesktopApplicationImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.BeanUtils;

public class LicenseManagerUIUtils {
    private static final Log log = Log.getLog(LicenseManagerUIUtils.class);
    private static final boolean SHOW_SUBSCRIPTION_EXPIRE_LICENSE = false;
    private static final Set<Long> STANDARD_LICENSE_RENEWAL_DAYS = Set.of(Long.valueOf(30L), Long.valueOf(14L), Long.valueOf(5L), Long.valueOf(4L), Long.valueOf(3L), Long.valueOf(2L), Long.valueOf(1L), Long.valueOf(0L));
    private static final Set<Long> LIMITED_LICENSE_RENEWAL_DAYS = Set.of(Long.valueOf(14L), Long.valueOf(7L), Long.valueOf(1L), Long.valueOf(0L));
    private static final Set<Long> SUBSCRIPTION_LICENSE_RENEWAL_DAYS = Set.of(Long.valueOf(1L), Long.valueOf(0L));
    private static final Set<Long> SUPPORT_END_LICENSE_RENEWAL_DAYS = Set.of(Long.valueOf(14L), Long.valueOf(7L), Long.valueOf(1L), Long.valueOf(0L));
    private static LMLicense lastValidLicense;

    @Nullable
    public static LMLicense checkLicense(@NotNull Shell shell) {
        boolean[] result;
        LMLicense currentLicense;
        boolean showDialog = false;
        while (true) {
            Throwable validationError = null;
            try {
                currentLicense = DBPApplicationLicensed.getLicensedApplication().getLicenseService().getActiveProductLicense(true);
                if (currentLicense != null) break;
                if (DBWorkbench.isDistributed()) {
                    DBWorkbench.getPlatformUI().showError(LMUIMessages.DBeaverEnterpriseUI_license_info_title, "No valid distributed license was found.\nApplication will be terminated.\nPlease ask your system administrator.");
                    return null;
                }
            }
            catch (Throwable e) {
                validationError = e;
            }
            if (validationError == null && LMLicenseManager.getLicenseCustomPath() != null) {
                DBWorkbench.getPlatformUI().showError(LMUIMessages.DBeaverEnterpriseUI_license_info_title, "No valid license found in " + String.valueOf(LMLicenseManager.getLicenseCustomPath().toAbsolutePath()), LMLicenseManager.getLastLicenseReadError());
                return null;
            }
            result = new boolean[1];
            Throwable finalValidationError = validationError;
            UIUtils.syncExec(() -> {
                blArray[0] = LicenseManagerUIUtils.importMissingLicenseInUI(shell, finalValidationError);
            });
            if (!result[0]) {
                return null;
            }
            showDialog = true;
        }
        if (!DBWorkbench.getPlatform().getApplication().isDistributed() && !PlatformUI.getWorkbench().isClosing()) {
            LMLicense finalCurrentLicense;
            if (showDialog) {
                UIUtils.syncExec(LicenseManagerUIUtils::showLicenseInfoDialog);
            }
            if ((finalCurrentLicense = currentLicense).getLicenseType() == LMLicenseType.EAP) {
                DBPApplicationEAP applicationEAP;
                result = new boolean[1];
                DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
                if (dBPApplication instanceof DBPApplicationEAP && (applicationEAP = (DBPApplicationEAP)dBPApplication).isEarlyAccessBuild()) {
                    LocalDateTime buildDate = applicationEAP.getBuildDate();
                    LocalDateTime now = LocalDateTime.now();
                    ZonedDateTime serverTime = LMPublicAPI.getServerTime();
                    if (serverTime == null) {
                        now = null;
                    } else if (Duration.between(serverTime.toLocalDateTime(), now).abs().toHours() > 36L) {
                        now = serverTime.toLocalDateTime();
                    }
                    if (now == null || buildDate.plusDays(28L).isBefore(now)) {
                        boolean canWork = now != null && buildDate.plusDays(31L).isAfter(now);
                        LocalDateTime currentTime = now;
                        UIUtils.syncExec(() -> {
                            boolean bl2 = LicenseManagerUIUtils.showEAPNotify(shell, buildDate, currentTime, canWork);
                        });
                    } else {
                        result[0] = true;
                    }
                } else {
                    UIUtils.syncExec(() -> {
                        boolean bl = LicenseManagerUIUtils.showEAPNotify(shell, null, LocalDateTime.now(), false);
                    });
                }
                if (!result[0]) {
                    return null;
                }
            }
            UIUtils.syncExec(() -> LicenseManagerUIUtils.showLicenseExpireNotify(finalCurrentLicense));
        }
        lastValidLicense = currentLicense;
        return currentLicense;
    }

    public static LMLicense getLastValidLicense() {
        return lastValidLicense;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean importMissingLicenseInUI(Shell shell, Throwable validationError) {
        LicenseMissingDialog dialog = new LicenseMissingDialog(shell, validationError);
        int choice = dialog.open();
        try {
            switch (choice) {
                case 1: {
                    return false;
                }
                case 1000: {
                    if (!LicenseManagerUIUtils.importLicense(shell)) return true;
                    UIUtils.showMessageBox((Shell)shell, (String)LMUIMessages.DBeaverEnterpriseUI_license_accepted_title, (String)LMUIMessages.DBeaverEnterpriseUI_license_accepted_message, (int)2);
                    return true;
                }
                case 1001: {
                    if (!LicenseManagerUIUtils.createTrialLicense(shell)) return true;
                    UIUtils.showMessageBox((Shell)shell, (String)LMUIMessages.DBeaverEnterpriseUI_trial_requested_title, (String)LMUIMessages.DBeaverEnterpriseUI_trial_requested_message, (int)2);
                    return true;
                }
                case 1003: {
                    boolean[] result = new boolean[1];
                    UIUtils.runInProgressDialog(monitor -> {
                        boolean bl = LicenseManagerUIUtils.joinEap(monitor);
                    });
                    while (true) {
                        if (!result[0]) {
                            return true;
                        }
                        LicenseRestartEAPDialog iconAndMessageDialog = new LicenseRestartEAPDialog(shell);
                        int eapChoice = iconAndMessageDialog.open();
                        if (eapChoice == 1002) {
                            String productEarlyAccessURL = GeneralUtils.getProductEarlyAccessURL();
                            if (!productEarlyAccessURL.isEmpty()) {
                                ShellUtils.launchProgram((String)productEarlyAccessURL);
                            }
                            result[0] = !PlatformUI.getWorkbench().close();
                            continue;
                        }
                        result[0] = !LicenseManagerUIUtils.restartForced();
                    }
                }
                case 1002: {
                    LicenseManagementDialog lmDialog = new LicenseManagementDialog(shell);
                    lmDialog.open();
                }
            }
            return true;
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError(LMUIMessages.DBeaverEnterpriseUI_e_lm_internal_title, LMUIMessages.DBeaverEnterpriseUI_e_lm_internal_message, e);
        }
        return true;
    }

    private static boolean joinEap(@NotNull DBRProgressMonitor monitor) {
        LMLicense license;
        LicenseServiceEmbedded service;
        DBPApplicationEAP app;
        block11: {
            app = (DBPApplicationEAP)((DBPApplicationLicensed)DBWorkbench.getPlatform().getApplication());
            if (app.isEarlyAccessProgram()) {
                return false;
            }
            service = (LicenseServiceEmbedded)((DBPApplicationLicensed)app).getLicenseService();
            LMProduct product = LMAppUtils.getActiveProduct();
            license = null;
            try {
                if (service.getActiveProductLicense(true) != null) break block11;
                LMLicense[] lMLicenseArray = service.getAllProductLicenses();
                int n = lMLicenseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LMLicense lic = lMLicenseArray[n2];
                    if (lic.isValidForProduct(product) && lic.getLicenseType() == LMLicenseType.TRIAL) {
                        license = lic;
                        break;
                    }
                    ++n2;
                }
            }
            catch (LMException lMException) {}
        }
        if (license != null) {
            try {
                license = service.joinEarlyAccessProgram(monitor, license);
            }
            catch (LMException e) {
                DBWorkbench.getPlatformUI().showError("Early Access Program", "Unable to join Early Access Program at the moment. Try again later", (Throwable)e);
                return false;
            }
        }
        if (app.isEarlyAccessProgram()) {
            try {
                service.validateLicense(license);
            }
            catch (LMException e) {
                DBWorkbench.getPlatformUI().showError("Early Access Program", "Can't validate Early Access Program license. Try again later", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static boolean createTrialLicense(Shell shell) {
        LicenseTrialDialog trialDialog = new LicenseTrialDialog(shell);
        int choice = trialDialog.open();
        return choice == 0;
    }

    private static boolean importLicense(Shell shell) {
        LicenseImportDialog importDialog = new LicenseImportDialog(shell);
        int choice = importDialog.open();
        return choice == 0;
    }

    public static void showLicenseInfoDialog() {
        try {
            LicenseInfoDialog dialog = new LicenseInfoDialog(UIUtils.getActiveWorkbenchShell());
            dialog.open();
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError(LMUIMessages.DBeaverEnterpriseUI_license_info_title, LMUIMessages.DBeaverEnterpriseUI_license_info_message, (Throwable)e);
        }
    }

    private static void showLicenseExpireNotify(LMLicense license) {
        String productVersionId = LMAppUtils.getActiveProduct().getId() + "-" + GeneralUtils.getMajorVersion();
        if (LicenseRenewsDialog.isSuppressedFor(productVersionId)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        boolean renewChosen = false;
        if (license.getLicenseEndTime() != null) {
            LocalDateTime licenseEndTime = license.getLicenseEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (licenseEndTime.isBefore(now)) {
                return;
            }
            long daysBeforeEnd = Math.abs(ChronoUnit.DAYS.between(licenseEndTime, now));
            if (!license.isSubscription()) {
                boolean validDay;
                boolean bl = validDay = license.getLicenseType() == LMLicenseType.STANDARD ? STANDARD_LICENSE_RENEWAL_DAYS.contains(daysBeforeEnd) : LIMITED_LICENSE_RENEWAL_DAYS.contains(daysBeforeEnd);
                if (validDay) {
                    LicenseRenewsDialog renewDialog = new LicenseRenewsDialog(UIUtils.getActiveWorkbenchShell(), LMUIMessages.dialog_renew_license_extend_license_title, NLS.bind((String)LMUIMessages.dialog_renew_license_license_expiration_message, (Object)licenseEndTime.toLocalDate()), productVersionId, license);
                    renewChosen = renewDialog.open() == 0;
                }
            }
        } else {
            long daysAfterEnd;
            LocalDateTime supportEndTime = license.getSupportEndDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (supportEndTime.isBefore(now) && SUPPORT_END_LICENSE_RENEWAL_DAYS.contains(daysAfterEnd = Math.abs(ChronoUnit.DAYS.between(supportEndTime, now)))) {
                LicenseRenewsDialog renewDialog = new LicenseRenewsDialog(UIUtils.getActiveWorkbenchShell(), LMUIMessages.dialog_renew_license_extend_license_title, NLS.bind((String)LMUIMessages.dialog_renew_license_license_end_of_support_message, (Object)supportEndTime.toLocalDate()), productVersionId, license);
                boolean bl = renewChosen = renewDialog.open() == 0;
            }
        }
        if (renewChosen) {
            LicenseManagementDialog lmDialog = new LicenseManagementDialog(UIUtils.getActiveWorkbenchShell());
            lmDialog.open();
        }
    }

    private static boolean showEAPNotify(@NotNull Shell shell, @Nullable LocalDateTime buildDate, @Nullable LocalDateTime currentTime, boolean canWork) {
        LicenseEAPDialog dialog = new LicenseEAPDialog(UIUtils.getActiveWorkbenchShell(), canWork, buildDate, currentTime);
        int choice = dialog.open();
        switch (choice) {
            case 0: {
                return true;
            }
            case 1000: {
                if (!LicenseManagerUIUtils.importLicense(shell)) break;
                UIUtils.showMessageBox((Shell)shell, (String)LMUIMessages.DBeaverEnterpriseUI_license_accepted_title, (String)LMUIMessages.DBeaverEnterpriseUI_license_accepted_message, (int)2);
                break;
            }
            case 1002: {
                String productEarlyAccessURL = GeneralUtils.getProductEarlyAccessURL();
                if (!productEarlyAccessURL.isEmpty()) {
                    ShellUtils.launchProgram((String)productEarlyAccessURL);
                }
                return false;
            }
        }
        return canWork;
    }

    private static boolean restartForced() {
        Object result;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            throw new IllegalStateException("Workbench is not available");
        }
        try {
            DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
            if (dBPApplication instanceof DesktopApplicationImpl) {
                DesktopApplicationImpl da = (DesktopApplicationImpl)dBPApplication;
                da.setIsForcedRestart(true);
            }
            result = BeanUtils.invokeObjectDeclaredMethod((Object)workbench, (String)"close", (Class[])new Class[]{Integer.TYPE, Boolean.TYPE}, (Object[])new Object[]{1, true});
        }
        catch (Throwable e) {
            log.error((Object)"Error restarting workbench", e);
            return false;
        }
        if (!(result instanceof Boolean)) {
            log.error((Object)("Expected boolean result, got: " + (result != null ? result.getClass().getSimpleName() : "null")));
            return false;
        }
        return (Boolean)result;
    }
}

