/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp.auth;

import com.dbeaver.cloud.gcp.GCPCloud;
import com.dbeaver.cloud.gcp.GCPCloudConfiguration;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.impl.AbstractCloudSessionProvider;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.dbeaver.net.auth.gcp.GCPAuthType;
import com.dbeaver.net.auth.gcp.GCPAuthUtils;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class GcpLocalSessionProvider
extends AbstractCloudSessionProvider<GCPCloud, AuthModelGCPCredentials> {
    @Nullable
    public GCPCloudSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull SMSessionContext context, @NotNull SMSession mainSession, @NotNull GCPCloud cloud) throws DBException {
        String arn = null;
        GCPCloudConfiguration configuration = (GCPCloudConfiguration)cloud.getCloudConfiguration();
        AuthModelGCPCredentials iamCredentials = configuration.getDefaultCredentials();
        if (!this.updateCredentialsFromSession(mainSession, iamCredentials)) {
            iamCredentials = (AuthModelGCPCredentials)this.updateCredentialsFromService((CPCloud)cloud, (DBAAuthCredentials)iamCredentials);
        }
        if (GCPAuthType.SESSION_CREDENTIALS.equals((Object)iamCredentials.getAuthType()) && iamCredentials.getToken() == null) {
            iamCredentials.resolveCredentials(monitor);
        }
        return new GCPCloudSession(context, mainSession, cloud, arn, iamCredentials);
    }

    public boolean updateCredentialsFromSession(@NotNull SMSession mainSession, @NotNull AuthModelGCPCredentials credentials) {
        Map objectMap;
        if (DBWorkbench.isDistributed() && CommonUtils.isEmpty((String)credentials.getClientSecret()) && !CommonUtils.isEmpty((Map)(objectMap = SMAuthUtils.getCredentialsFromSession((SMSession)mainSession, (String)"google-openid")))) {
            GCPAuthUtils.updateCredentialsFromSessionData((Map)objectMap, (AuthModelGCPCredentials)credentials);
            return true;
        }
        return false;
    }
}

