/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp;

import com.dbeaver.cloud.gcp.GCPCloud;
import com.dbeaver.cloud.gcp.GCPCloudAbstractInstance;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.gcp.GCPCloudUtils;
import com.dbeaver.cloud.gcp.GCPCloudZone;
import com.dbeaver.cloud.gcp.GCPProject;
import com.dbeaver.cloud.gcp.alloydb.GCPAlloyDBInstance;
import com.dbeaver.cloud.gcp.bigquery.GCPBigqueryInstance;
import com.dbeaver.cloud.gcp.bigtable.GCPBigtableInstance;
import com.dbeaver.cloud.gcp.firestore.GCPFiresStoreInstance;
import com.dbeaver.cloud.gcp.spanner.GCPSpannerInstance;
import com.dbeaver.cloud.gcp.sql.GCPCloudSQLInstance;
import com.dbeaver.cloud.model.CPCloudExplorer;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.google.api.services.alloydb.v1.CloudAlloyDBAdmin;
import com.google.api.services.bigtableadmin.v2.BigtableAdmin;
import com.google.api.services.bigtableadmin.v2.model.Instance;
import com.google.api.services.spanner.v1.Spanner;
import com.google.api.services.spanner.v1.model.Database;
import com.google.api.services.spanner.v1.model.ListDatabasesResponse;
import com.google.api.services.spanner.v1.model.ListInstancesResponse;
import com.google.api.services.sqladmin.SQLAdmin;
import com.google.api.services.sqladmin.model.DatabaseInstance;
import com.google.api.services.sqladmin.model.InstancesListResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class GCPCloudExplorer
implements CPCloudExplorer<GCPCloudZone> {
    private static final Log log = Log.getLog(GCPCloudExplorer.class);
    private final GCPCloud cloud;
    private GCPCloudSession session;

    public GCPCloudExplorer(GCPCloud cloud, GCPCloudSession session) {
        this.cloud = cloud;
        this.session = session;
    }

    @NotNull
    public GCPCloud getCloud() {
        return this.cloud;
    }

    @NotNull
    public GCPProject[] getRootFolders(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.session.getAvailableProjects(monitor);
    }

    @NotNull
    public GCPCloudAbstractInstance[] getDatabaseInstances(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID, @Nullable CPDatabaseFolder category) throws DBException {
        try {
            GCPProject project = (GCPProject)category;
            if (project == null) {
                throw new DBException("Project not specified");
            }
            ArrayList<GCPBigqueryInstance> instances = new ArrayList<GCPBigqueryInstance>();
            try {
                List<GCPCloudAbstractInstance> regionInstances = switch (serviceID) {
                    case "sql" -> this.findSqlInstances(monitor, this.session, project);
                    case "gcp-spanner" -> this.findSpannerInstances(monitor, this.session, project);
                    case "gcp-bigquery" -> Collections.singletonList(this.findBigqueryInstance(this.session, project));
                    case "gcp-firestore" -> Collections.singletonList(this.findFirestoreInstances(this.session, project));
                    case "gcp-bigtable" -> this.findBigtableInstances(monitor, this.session, project);
                    case "alloy-db" -> this.findAlloyDBInstances(monitor, this.session, project);
                    default -> throw new DBException("Service '" + serviceID + "' not supported yet");
                };
                instances.addAll(regionInstances);
            }
            catch (Exception e) {
                throw new DBException("Error loading " + serviceID + " instances", (Throwable)e);
            }
            return instances.toArray(new GCPCloudAbstractInstance[0]);
        }
        catch (Exception e) {
            throw new DBException("Error reading GCP instances", (Throwable)e);
        }
    }

    public GCPCloudAbstractInstance getDatabaseInstance(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID, @Nullable CPDatabaseFolder category, @NotNull GCPCloudZone zone, @NotNull String instanceId) throws DBException {
        GCPProject project = (GCPProject)category;
        if (project == null) {
            throw new DBException("Project not specified");
        }
        return switch (serviceID) {
            case "sql" -> this.findRdsInstance(monitor, this.session, project, instanceId);
            case "gcp-spanner" -> this.findSpannerInstance(monitor, this.session, project, instanceId);
            case "gcp-bigquery" -> this.findBigqueryInstance(this.session, project);
            case "gcp-bigtable" -> this.findBigtableInstance(monitor, this.session, project, instanceId);
            case "gcp-firestore" -> this.findFirestoreInstances(this.session, project);
            case "alloy-db" -> this.findAlloyDBInstance(monitor, this.session, project, instanceId);
            default -> throw new DBException("Service '" + serviceID + "' not supported yet");
        };
    }

    public void refreshSession(@NotNull CPCloudSession<GCPCloudZone> cloudSession) {
        this.session = (GCPCloudSession)cloudSession;
    }

    private List<GCPCloudSQLInstance> findSqlInstances(DBRProgressMonitor monitor, GCPCloudSession session, GCPProject project) throws DBException {
        monitor.subTask("List SQL instances");
        try {
            AuthModelGCPCredentials credentials = session.getCredentials();
            SQLAdmin sqlAdmin = (SQLAdmin)GCPCloudUtils.buildClient(new SQLAdmin.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)));
            InstancesListResponse instancesListResponse = (InstancesListResponse)sqlAdmin.instances().list(project.getFolderId()).execute();
            ArrayList<GCPCloudSQLInstance> instances = new ArrayList<GCPCloudSQLInstance>();
            for (DatabaseInstance dbInstance : CommonUtils.safeList((List)instancesListResponse.getItems())) {
                instances.add(new GCPCloudSQLInstance(session, project, dbInstance));
            }
            return instances;
        }
        catch (IOException e) {
            throw new DBException("Error reading SQL instances", (Throwable)e);
        }
    }

    private GCPCloudSQLInstance findRdsInstance(DBRProgressMonitor monitor, GCPCloudSession session, GCPProject project, String instanceId) throws DBException {
        monitor.subTask("Find SQL instance");
        try {
            AuthModelGCPCredentials credentials = session.getCredentials();
            SQLAdmin sqlAdmin = (SQLAdmin)GCPCloudUtils.buildClient(new SQLAdmin.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)));
            DatabaseInstance instance = (DatabaseInstance)sqlAdmin.instances().get(project.getFolderId(), instanceId).execute();
            return new GCPCloudSQLInstance(session, project, instance);
        }
        catch (IOException e) {
            throw new DBException("Error reading SQL instance " + instanceId, (Throwable)e);
        }
    }

    private List<GCPSpannerInstance> findSpannerInstances(@NotNull DBRProgressMonitor monitor, @NotNull GCPCloudSession session, @NotNull GCPProject project) throws DBException {
        monitor.subTask("List Spanner instances");
        try {
            AuthModelGCPCredentials credentials = session.getCredentials();
            Spanner spannerAdmin = (Spanner)GCPCloudUtils.buildClient(new Spanner.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)));
            ListInstancesResponse instancesResponse = (ListInstancesResponse)spannerAdmin.projects().instances().list("projects/" + project.getProjectId()).execute();
            ArrayList<GCPSpannerInstance> instances = new ArrayList<GCPSpannerInstance>();
            for (com.google.api.services.spanner.v1.model.Instance instance : CommonUtils.safeCollection((Collection)instancesResponse.getInstances())) {
                ListDatabasesResponse databasesResponse = (ListDatabasesResponse)spannerAdmin.projects().instances().databases().list(instance.getName()).execute();
                List databases = databasesResponse.getDatabases();
                for (Database database : CommonUtils.safeCollection((Collection)databases)) {
                    instances.add(new GCPSpannerInstance(session, project, instance, database));
                }
            }
            return instances;
        }
        catch (IOException e) {
            throw new DBException("Error reading Spanner instances", (Throwable)e);
        }
    }

    private GCPSpannerInstance findSpannerInstance(@NotNull DBRProgressMonitor monitor, @NotNull GCPCloudSession session, @NotNull GCPProject project, @NotNull String instanceId) throws DBException {
        monitor.subTask("Find Spanner instance");
        try {
            AuthModelGCPCredentials credentials = session.getCredentials();
            Spanner spannerAdmin = (Spanner)GCPCloudUtils.buildClient(new Spanner.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)));
            com.google.api.services.spanner.v1.model.Instance instance = (com.google.api.services.spanner.v1.model.Instance)spannerAdmin.projects().instances().get(instanceId).execute();
            ListDatabasesResponse databasesResponse = (ListDatabasesResponse)spannerAdmin.projects().instances().databases().list(instance.getName()).execute();
            List databases = databasesResponse.getDatabases();
            if (!CommonUtils.isEmpty((Collection)databases)) {
                return new GCPSpannerInstance(session, project, instance, (Database)databases.get(0));
            }
        }
        catch (IOException e) {
            throw new DBException("Error reading Spanner instance " + instanceId, (Throwable)e);
        }
        return null;
    }

    private List<GCPBigtableInstance> findBigtableInstances(@NotNull DBRProgressMonitor monitor, @NotNull GCPCloudSession session, @NotNull GCPProject project) throws DBException {
        monitor.subTask("List Bigtable instances");
        try {
            AuthModelGCPCredentials credentials = session.getCredentials();
            BigtableAdmin bigtableAdmin = (BigtableAdmin)GCPCloudUtils.buildClient(new BigtableAdmin.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)));
            com.google.api.services.bigtableadmin.v2.model.ListInstancesResponse btInstances = (com.google.api.services.bigtableadmin.v2.model.ListInstancesResponse)bigtableAdmin.projects().instances().list("projects/" + project.getProjectId()).execute();
            ArrayList<GCPBigtableInstance> instances = new ArrayList<GCPBigtableInstance>();
            for (Instance instance : CommonUtils.safeCollection((Collection)btInstances.getInstances())) {
                instances.add(new GCPBigtableInstance(session, project, instance));
            }
            return instances;
        }
        catch (IOException e) {
            throw new DBException("Error reading Bigtable instances", (Throwable)e);
        }
    }

    private GCPFiresStoreInstance findFirestoreInstances(@NotNull GCPCloudSession session, @NotNull GCPProject projectId) throws DBException {
        return new GCPFiresStoreInstance(session, projectId);
    }

    private GCPBigtableInstance findBigtableInstance(@NotNull DBRProgressMonitor monitor, @NotNull GCPCloudSession session, @NotNull GCPProject project, @NotNull String instanceId) throws DBException {
        return this.findBigtableInstances(monitor, session, project).stream().filter(i -> i.getNodeName().equals(instanceId)).findFirst().orElse(null);
    }

    private GCPBigqueryInstance findBigqueryInstance(@NotNull GCPCloudSession session, @NotNull GCPProject project) {
        return new GCPBigqueryInstance(session, project);
    }

    @NotNull
    private List<GCPAlloyDBInstance> findAlloyDBInstances(@NotNull DBRProgressMonitor monitor, @NotNull GCPCloudSession session, @NotNull GCPProject project) throws DBException {
        monitor.subTask("List AlloyDB instances");
        try {
            AuthModelGCPCredentials credentials = session.getCredentials();
            CloudAlloyDBAdmin build = new CloudAlloyDBAdmin.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)).build();
            List instances = ((com.google.api.services.alloydb.v1.model.ListInstancesResponse)build.projects().locations().clusters().instances().list("projects/" + project.getProjectId() + "/locations/-/clusters/-").execute()).getInstances();
            ArrayList<GCPAlloyDBInstance> dbInstances = new ArrayList<GCPAlloyDBInstance>();
            for (com.google.api.services.alloydb.v1.model.Instance instance : CommonUtils.safeList((List)instances)) {
                dbInstances.add(new GCPAlloyDBInstance(session, project, instance));
            }
            return dbInstances;
        }
        catch (IOException e) {
            throw new DBException("Error reading SQL instances", (Throwable)e);
        }
    }

    @NotNull
    private GCPAlloyDBInstance findAlloyDBInstance(@NotNull DBRProgressMonitor monitor, @NotNull GCPCloudSession session, @NotNull GCPProject project, @NotNull String instanceId) throws DBException {
        monitor.subTask("Search AlloyDB instance by id");
        try {
            AuthModelGCPCredentials credentials = session.getCredentials();
            CloudAlloyDBAdmin build = new CloudAlloyDBAdmin.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)).build();
            com.google.api.services.alloydb.v1.model.Instance execute = (com.google.api.services.alloydb.v1.model.Instance)build.projects().locations().clusters().instances().get(instanceId).execute();
            return new GCPAlloyDBInstance(session, project, execute);
        }
        catch (IOException e) {
            throw new DBException("Error reading AlloyDB instance", (Throwable)e);
        }
    }
}

