/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.timestream;

import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import software.amazon.awssdk.services.timestreamwrite.model.Database;

public class AWSCloudTimestreamDatabase
extends AWSCloudAbstractInstance {
    private final Database database;

    public AWSCloudTimestreamDatabase(AWSCloudSession session, AWSCloudZone region, Database database) {
        super(session, region);
        this.database = database;
    }

    @NotNull
    public String getNodeId() {
        return this.database.databaseName();
    }

    @NotNull
    public String getNodeName() {
        return this.getNodeId();
    }

    @Nullable
    public String getInstanceEndpoint() {
        return this.getNodeId();
    }

    @Override
    protected void setDataSourceConfiguration(DBPConnectionConfiguration configuration) throws DBException {
        configuration.setAuthModelId("iam_timestream");
        configuration.setHostName(this.getAwsRegionId());
        configuration.setAuthProperty("iam.region", this.getZone().getZoneId());
    }

    @Override
    protected AWSCloudService getCloudService() {
        return AWSCloudService.TIMESTREAM;
    }

    @Override
    protected String getInstanceARN() {
        return this.database.arn();
    }

    @Override
    protected String getExternalLink() {
        return this.getLinkPrefix() + "databases/" + this.database.databaseName();
    }
}

