/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.parameters;

import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudUtils;
import com.dbeaver.cloud.aws.parameters.AWSParametersProviderConfiguration;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.model.datasource.DataSourceDescriptorPRO;
import com.dbeaver.model.datasource.parameters.DBPAbstractParametersProvider;
import com.dbeaver.model.datasource.parameters.DBPDatasourceExternalParameters;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class AWSParametersProvider
extends DBPAbstractParametersProvider<AWSParametersProviderConfiguration> {
    private static final Log log = Log.getLog(AWSParametersProvider.class);
    public static final String AWS_PARAMETERS_PROVIDER_ID = "aws-parameters-provider";

    @Nullable
    public Map<String, String> readParameters(@NotNull DBRProgressMonitor monitor, @NotNull DataSourceDescriptorPRO dataSourceDescriptor) throws DBException {
        DBPDatasourceExternalParameters datasourceParametersConfig = dataSourceDescriptor.getExternalParametersConfig();
        if (datasourceParametersConfig == null) {
            return null;
        }
        AWSParametersProviderConfiguration awsParametersConfig = (AWSParametersProviderConfiguration)this.getConfiguration(datasourceParametersConfig, AWSParametersProviderConfiguration.class);
        CloudProviderDescriptor awsCloudProvider = AWSCloudUtils.getAwsCloudProvider();
        CPCloud awsCloud = CPCloudUtils.findCloudInProvider((CloudProviderDescriptor)awsCloudProvider, (String)awsParametersConfig.getCloudId());
        if (awsCloud == null) {
            throw new DBException("Aws cloud " + awsParametersConfig.getCloudId() + " not found");
        }
        SMSessionContext authContext = dataSourceDescriptor.getProject().getWorkspace().getAuthContext();
        SMSession awsSession = authContext.getSpaceSession(monitor, (SMAuthSpace)awsCloud, true);
        if (awsSession == null) {
            throw new DBException("AWS session not found");
        }
        if (awsSession instanceof AWSCloudSession) {
            AWSCloudSession cloudSession = (AWSCloudSession)awsSession;
            return this.readSecretFromAWS(monitor, cloudSession, datasourceParametersConfig, awsParametersConfig);
        }
        throw new DBException("External parameters not found");
    }

    public AWSParametersProviderConfiguration createDefaultConfiguration() {
        return new AWSParametersProviderConfiguration("");
    }

    @NotNull
    private Map<String, String> readSecretFromAWS(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession cloudSession, @NotNull DBPDatasourceExternalParameters datasourceParametersConfig, @NotNull AWSParametersProviderConfiguration awsParametersConfig) throws DBException {
        try {
            AwsCredentialsProvider awsCredentialsProvider = cloudSession.getIamCredentials().getAuthCredentialsProvider(monitor);
            return AWSIAMUtils.readSecretValue((String)awsParametersConfig.getRegion(), (String)datasourceParametersConfig.getSecretName(), (AwsCredentialsProvider)awsCredentialsProvider);
        }
        catch (Exception e) {
            throw new DBException("Error reading AWS secret: " + e.getMessage(), (Throwable)e);
        }
    }
}

