/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.dsql;

import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.dsql.model.ClusterSummary;

public class AWSCloudDsqlCluster
extends AWSCloudAbstractInstance {
    private final ClusterSummary clusterSummary;

    public AWSCloudDsqlCluster(@NotNull AWSCloudSession session, @NotNull AWSCloudZone zone, @NotNull ClusterSummary clusterSummary) {
        super(session, zone);
        this.clusterSummary = clusterSummary;
    }

    @NotNull
    public String getNodeId() {
        return this.clusterSummary.arn();
    }

    @NotNull
    public String getNodeName() {
        return this.clusterSummary.identifier();
    }

    @Override
    @NotNull
    public String getNodeDisplayName() {
        return this.clusterSummary.identifier();
    }

    @Override
    @NotNull
    protected String getResourceId() {
        return this.clusterSummary.identifier();
    }

    @Nullable
    public String getInstanceEndpoint() {
        return this.getHostName();
    }

    private String getHostName() {
        return this.clusterSummary.identifier() + ".dsql." + this.getZone().getName() + ".on.aws";
    }

    @Override
    protected void setDataSourceConfiguration(DBPConnectionConfiguration configuration) throws DBException {
        configuration.setDatabaseName("postgres");
        configuration.setHostName(this.getHostName());
        configuration.setHostPort(CommonUtils.toString((Object)5432));
        configuration.setUserName(this.getInstanceUserName());
        configuration.setAuthModelId("iam_dsql");
        configuration.setAuthProperty("iam.region", this.getZone().getZoneId());
    }

    @Override
    protected AWSCloudService getCloudService() {
        return AWSCloudService.DSQL;
    }

    @Override
    @Property(viewable=true, order=40)
    protected String getInstanceARN() {
        return this.clusterSummary.arn();
    }

    @Override
    protected String getExternalLink() {
        return this.getLinkPrefix() + "database:id=" + this.clusterSummary.identifier();
    }

    @Override
    @Nullable
    protected String getInstanceUserName() {
        return "admin";
    }

    @Property(viewable=true, order=40)
    @NotNull
    public String getClusterIdentifier() {
        return this.clusterSummary.identifier();
    }
}

