/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloudConstants;
import org.jkiss.api.CompositeObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;

public enum AWSCloudService {
    RDS_POSTGRESQL("postgresql", "rds", new CompositeObjectId("postgresql", "postgres-jdbc"), "rds"),
    RDS_MYSQL("mysql", "rds", new CompositeObjectId("mysql-ee", "mysql8"), "rds"),
    RDS_MARIADB("mariadb", "rds", new CompositeObjectId("mysql-ee", "mariaDB"), "rds"),
    RDS_ORACLE("oracle", "rds", new CompositeObjectId("oracle-ee", "oracle_thin"), "rds"),
    RDS_SQLSERVER("sqlserver", "rds", new CompositeObjectId("sqlserver-ee", "microsoft"), "rds"),
    REDSHIFT("redshift", "redshift", new CompositeObjectId("redshift", "redshift-jdbc"), "redshiftv2"),
    REDSHIFT_SERVERLESS("redshift-serverless", "redshift", new CompositeObjectId("redshift", "redshift-jdbc"), "redshiftv2"),
    ATHENA("athena", "athena", new CompositeObjectId("athena_pro", "aws_athena_jdbc_simba_pro"), "athena"),
    DYNAMODB("dynamodb", "dynamodb", new CompositeObjectId("dynamodb", "dynamodb"), "dynamodb"),
    DOCUMENTDB("docdb", "documentdb", new CompositeObjectId("aws-documentdb", "documentdb"), "docdb"),
    KEYSPACES("keyspaces", "keyspaces", new CompositeObjectId("aws_keyspaces", "keyspaces"), "keyspaces"),
    ELASTICACHE_REDIS("elasticache", "elasticache", new CompositeObjectId("redis", "redis_jedis"), "redis"),
    NEPTUNE("neptune", "neptune", new CompositeObjectId("aws_neptune", "neptune"), "neptune"),
    TIMESTREAM("timestream", "timestream", new CompositeObjectId("aws_timestream", "timestream"), "timestream"),
    DSQL("dsql", "dsql", new CompositeObjectId("aurora-dsql", "aurora-dsql"), "dsql"),
    UNKNOWN("unknown", "", AWSCloudConstants.UNKNOWN_DRIVER, "unknown");

    private final String id;
    private final String serviceId;
    private final CompositeObjectId driver;
    private final String prefix;

    private AWSCloudService(String id, String serviceId, CompositeObjectId driver, String prefix) {
        this.id = id;
        this.serviceId = serviceId;
        this.driver = driver;
        this.prefix = prefix;
    }

    public String getId() {
        return this.id;
    }

    @NotNull
    public String getServiceId() {
        return this.serviceId;
    }

    @NotNull
    public String getPrefix() {
        return this.prefix;
    }

    public DBPDriver getInstanceDriver() throws DBException {
        return DataSourceProviderRegistry.getInstance().findDriver(this.driver);
    }

    @Nullable
    public static AWSCloudService getServiceByDriver(DBPDriver driver) {
        AWSCloudService[] aWSCloudServiceArray = AWSCloudService.values();
        int n = aWSCloudServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            AWSCloudService service = aWSCloudServiceArray[n2];
            if (service.driver.primaryId().equals(driver.getProviderId()) && service.driver.secondaryId().equals(driver.getId())) {
                return service;
            }
            ++n2;
        }
        return null;
    }

    public static AWSCloudService getServiceById(String id) {
        AWSCloudService[] aWSCloudServiceArray = AWSCloudService.values();
        int n = aWSCloudServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            AWSCloudService service = aWSCloudServiceArray[n2];
            if (service.getId().equals(id)) {
                return service;
            }
            ++n2;
        }
        return null;
    }
}

