/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc41.utilities;

import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SArray;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

public class ResultSetUtilities {
    public static <T> T getObjectByType(SForwardResultSet rs, int columnIndex, Class<T> type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(rs.getLogger(), columnIndex, type);
            if (type.equals(BigDecimal.class)) {
                return (T)rs.getBigDecimal(columnIndex);
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                return (T)Boolean.valueOf(rs.getBoolean(columnIndex));
            }
            if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                return (T)Byte.valueOf(rs.getByte(columnIndex));
            }
            if (type.equals(byte[].class)) {
                return (T)rs.getBytes(columnIndex);
            }
            if (type.equals(Date.class)) {
                return (T)rs.getDate(columnIndex);
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return (T)Double.valueOf(rs.getDouble(columnIndex));
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return (T)Float.valueOf(rs.getFloat(columnIndex));
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(rs.getInt(columnIndex));
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return (T)Long.valueOf(rs.getLong(columnIndex));
            }
            if (type.equals(Object.class)) {
                return (T)rs.getObject(columnIndex);
            }
            if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                return (T)Short.valueOf(rs.getShort(columnIndex));
            }
            if (type.equals(String.class)) {
                return (T)rs.getString(columnIndex);
            }
            if (type.equals(Time.class)) {
                return (T)rs.getTime(columnIndex);
            }
            if (type.equals(Timestamp.class)) {
                return (T)rs.getTimestamp(columnIndex);
            }
            if (Array.class.equals(type) || SArray.class.isAssignableFrom(type)) {
                return (T)rs.getArray(columnIndex);
            }
            if (type.equals(Blob.class) || type.equals(Clob.class) || type.equals(Ref.class) || type.equals(URL.class) || type.equals(NClob.class) || type.equals(RowId.class) || type.equals(SQLXML.class)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)rs.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)rs.getWarningListener(), ExceptionType.NON_TRANSIENT, String.valueOf(columnIndex), type.getName());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, rs.getWarningListener(), rs.getLogger());
        }
    }
}

