/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

public class DSIMonthSpan
implements Cloneable {
    private int m_intervalType;
    private int m_year = 0;
    private int m_month = 0;
    private boolean m_isNegative = false;

    private static void validate(int year, int month) {
        if (0 != year && (0 > month || 11 < month)) {
            throw new IllegalArgumentException("Invalid month value.");
        }
    }

    public DSIMonthSpan(int intervalType, int year, int month, boolean isNegative) {
        DSIMonthSpan.validate(year, month);
        this.m_intervalType = intervalType;
        this.m_year = year;
        this.m_month = month;
        this.m_isNegative = isNegative;
    }

    public int getIntervalType() {
        return this.m_intervalType;
    }

    public int getMonth() {
        return this.m_month;
    }

    public int getYear() {
        return this.m_year;
    }

    public boolean isNegative() {
        return this.m_isNegative;
    }

    public void setIsNegative(boolean isNegative) {
        this.m_isNegative = isNegative;
    }

    public void setMonth(int month) {
        DSIMonthSpan.validate(this.m_year, month);
        this.m_month = month;
    }

    public void setYear(int year) {
        DSIMonthSpan.validate(year, this.m_month);
        this.m_year = year;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (this.m_isNegative) {
            builder.append("-");
        }
        builder.append(String.valueOf(this.m_year)).append("-");
        builder.append(String.valueOf(this.m_month));
        return builder.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_intervalType;
        result = 31 * result + (this.m_isNegative ? 1231 : 1237);
        result = 31 * result + this.m_month;
        result = 31 * result + this.m_year;
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DSIMonthSpan)) {
            return false;
        }
        DSIMonthSpan otherSpan = (DSIMonthSpan)other;
        return this.m_isNegative == otherSpan.m_isNegative && this.m_month == otherSpan.m_month && this.m_year == otherSpan.m_year && this.m_intervalType == otherSpan.m_intervalType;
    }
}

