/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.teradata.model;

import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;

public enum TeradataValueType {
    A1("SYSUDTLIB.", 2003),
    AN("SYSUDTLIB.", 2003),
    AT("TIME", 92),
    BF("BYTE", -2),
    BO("BLOB", 2004),
    BV("VARBYTE", -3),
    CF("CHAR", 1),
    CO("CLOB", 2005),
    CV("VARCHAR", 12),
    D("DECIMAL", 3),
    DA("DATE", 91),
    DH("INTERVAL DAY TO HOUR", 1111),
    DM("INTERVAL DAY TO MINUTE", 1111),
    DS("INTERVAL DAY TO SECOND", 1111),
    DT("DATASET STORAGE FORMAT ", 1111),
    DY("INTERVAL DAY", 1111),
    F("FLOAT", 6),
    GF("GRAPHIC", 1),
    GV("VARGRAPHIC", 12),
    HM("INTERVAL HOUR TO MINUTE", 1111),
    HR("INTERVAL HOUR", 1111),
    HS("INTERVAL HOUR TO SECOND", 1111),
    I1("BYTEINT", -6),
    I2("SMALLINT", 5),
    I("INTEGER", 4),
    I8("BIGINT", -5),
    JN("JSON", 1111),
    MI("INTERVAL MINUTE", 1111),
    MO("INTERVAL MONTH", 1111),
    MS("INTERVAL MINUTE TO SECOND", 1111),
    N("NUMBER", 2),
    PD("PERIOD(DATE)", 1111),
    PM("PERIOD(TIMESTAMP WITH TIME ZONE)", 1111),
    PS("PERIOD(TIMESTAMP)", 1111),
    PT("PERIOD(TIME)", 1111),
    PZ("PERIOD(TIME WITH TIME ZONE)", 1111),
    SC("INTERVAL SECOND", 1111),
    SZ("TIMESTAMP WITH TIME ZONE", 93),
    TS("TIMESTAMP", 93),
    TZ("TIME WITH TIME ZONE", 92),
    XM("XML", 2009),
    YM("INTERVAL YEAR TO MONTH", 1111),
    YR("INTERVAL YEAR", 1111),
    UT("SYSUDTLIB.", 2001);

    private final String typeName;
    private final Integer typeId;

    private TeradataValueType(String typeName, Integer typeId) {
        this.typeName = typeName;
        this.typeId = typeId;
    }

    public String getTypeName(@Nullable String columnName, @Nullable String storageFormat) {
        switch (this) {
            case A1: 
            case AN: 
            case UT: {
                if (!CommonUtils.isNotEmpty((String)columnName)) break;
                return this.typeName + columnName.trim();
            }
            case DT: {
                if (!CommonUtils.isNotEmpty((String)storageFormat)) break;
                return this.typeName + storageFormat.trim();
            }
            default: {
                return this.typeName;
            }
        }
        return this.typeName;
    }

    public Integer getTypeId() {
        return this.typeId;
    }
}

