/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class TableAccessPolicy {
    @JsonProperty(value="startTime")
    private OffsetDateTime startTime;
    @JsonProperty(value="expiryTime")
    private OffsetDateTime expiryTime;
    @JsonProperty(value="permission", required=true)
    private String permission;
    private static final ClientLogger LOGGER = new ClientLogger(TableAccessPolicy.class);

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public TableAccessPolicy withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public TableAccessPolicy withExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String permission() {
        return this.permission;
    }

    public TableAccessPolicy withPermission(String permission) {
        this.permission = permission;
        return this;
    }

    public void validate() {
        if (this.permission() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property permission in model TableAccessPolicy"));
        }
    }
}

