/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.HttpProtocol;
import com.azure.resourcemanager.storage.models.Permissions;
import com.azure.resourcemanager.storage.models.Services;
import com.azure.resourcemanager.storage.models.SignedResourceTypes;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class AccountSasParameters {
    @JsonProperty(value="signedServices", required=true)
    private Services services;
    @JsonProperty(value="signedResourceTypes", required=true)
    private SignedResourceTypes resourceTypes;
    @JsonProperty(value="signedPermission", required=true)
    private Permissions permissions;
    @JsonProperty(value="signedIp")
    private String ipAddressOrRange;
    @JsonProperty(value="signedProtocol")
    private HttpProtocol protocols;
    @JsonProperty(value="signedStart")
    private OffsetDateTime sharedAccessStartTime;
    @JsonProperty(value="signedExpiry", required=true)
    private OffsetDateTime sharedAccessExpiryTime;
    @JsonProperty(value="keyToSign")
    private String keyToSign;
    private static final ClientLogger LOGGER = new ClientLogger(AccountSasParameters.class);

    public Services services() {
        return this.services;
    }

    public AccountSasParameters withServices(Services services) {
        this.services = services;
        return this;
    }

    public SignedResourceTypes resourceTypes() {
        return this.resourceTypes;
    }

    public AccountSasParameters withResourceTypes(SignedResourceTypes resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    public Permissions permissions() {
        return this.permissions;
    }

    public AccountSasParameters withPermissions(Permissions permissions) {
        this.permissions = permissions;
        return this;
    }

    public String ipAddressOrRange() {
        return this.ipAddressOrRange;
    }

    public AccountSasParameters withIpAddressOrRange(String ipAddressOrRange) {
        this.ipAddressOrRange = ipAddressOrRange;
        return this;
    }

    public HttpProtocol protocols() {
        return this.protocols;
    }

    public AccountSasParameters withProtocols(HttpProtocol protocols) {
        this.protocols = protocols;
        return this;
    }

    public OffsetDateTime sharedAccessStartTime() {
        return this.sharedAccessStartTime;
    }

    public AccountSasParameters withSharedAccessStartTime(OffsetDateTime sharedAccessStartTime) {
        this.sharedAccessStartTime = sharedAccessStartTime;
        return this;
    }

    public OffsetDateTime sharedAccessExpiryTime() {
        return this.sharedAccessExpiryTime;
    }

    public AccountSasParameters withSharedAccessExpiryTime(OffsetDateTime sharedAccessExpiryTime) {
        this.sharedAccessExpiryTime = sharedAccessExpiryTime;
        return this;
    }

    public String keyToSign() {
        return this.keyToSign;
    }

    public AccountSasParameters withKeyToSign(String keyToSign) {
        this.keyToSign = keyToSign;
        return this;
    }

    public void validate() {
        if (this.services() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property services in model AccountSasParameters"));
        }
        if (this.resourceTypes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceTypes in model AccountSasParameters"));
        }
        if (this.permissions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property permissions in model AccountSasParameters"));
        }
        if (this.sharedAccessExpiryTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sharedAccessExpiryTime in model AccountSasParameters"));
        }
    }
}

