/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBufferRO;
import com.intersys.jdbc.CacheBufferUtils;
import com.intersys.jdbc.CacheMsgHeader;
import com.intersys.util.VersionInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class LogFileStream {
    static final int LOG_RECEIVED = 0;
    static final int LOG_SENT = 1;
    private static final String lineSeparator;
    private PrintWriter output;
    private String jobID = "-1";
    private StringBuffer buffer;
    private StringBuffer asciiDump;
    private boolean closed = false;
    private static SimpleDateFormat simpleDateFormat;
    public boolean bSkipLogging = false;

    public LogFileStream(PrintWriter pw) throws IOException {
        this.output = pw;
        this.buffer = new StringBuffer();
        this.asciiDump = new StringBuffer(20);
        this.dumpHeader();
    }

    public LogFileStream(String path) throws IOException {
        this.buffer = new StringBuffer();
        this.asciiDump = new StringBuffer(20);
        boolean bNewFile = false;
        if (path.startsWith("+")) {
            bNewFile = true;
            path = path.substring(1);
        }
        if (path.startsWith("-")) {
            this.bSkipLogging = true;
            path = path.substring(1);
        }
        File lf = new File(path);
        if (bNewFile) {
            lf.delete();
        }
        this.output = new PrintWriter(new FileOutputStream(lf, true), true);
        this.dumpHeader();
    }

    public synchronized void setJobID(String j) {
        this.jobID = j;
    }

    private static String getCurrentTime() {
        return simpleDateFormat.format(Calendar.getInstance().getTime());
    }

    public final void dumpHeader() {
        this.output.print(lineSeparator + "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-");
        this.output.print(lineSeparator + "\tStarted At:\t" + DateFormat.getDateTimeInstance().format(new Date()));
        this.output.print(lineSeparator + "\tDriver Name:\tcom.intersys.jdbc.CacheDriver");
        this.output.print(lineSeparator + "\tJar File Name:\t" + VersionInfo.getJarFileName());
        this.output.print(lineSeparator + "\tClient Version:\t" + VersionInfo.getClientVersion());
        this.output.print(lineSeparator + "\tCompiled At:\t" + VersionInfo.compiledAt());
        this.output.print(lineSeparator + "\tJDBC Version:\t" + VersionInfo.getJDBCVersion());
        this.output.print(lineSeparator + "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-" + lineSeparator);
        this.output.flush();
    }

    void dump(byte[] stream1, byte[] stream2, int offset, int count, int type, byte[] header) {
        byte[] stream = new byte[stream1.length + count];
        CacheBufferUtils.copyByteArray(stream1, 0, stream, 0, stream1.length);
        CacheBufferUtils.copyByteArray(stream2, offset, stream, stream1.length, count);
        this.dump(stream, 0, stream.length, type, header);
    }

    void dump(CacheMsgHeader header, int type) {
        this.dump(new byte[0], 0, 0, type, header.hBuffer);
    }

    void dump(CacheBufferRO list, int type) {
        this.dump(list.getTCPBuffer(), list.getOffset(), list.getEndLength() - list.getOffset(), type, list.Header.hBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void dump(byte[] stream, int offset, int count, int type, byte[] header) {
        this.asciiDump.delete(0, this.asciiDump.length());
        if (this.bSkipLogging && header != null ? header[12] == 89 && header[13] == 81 || this.jobID == "-1" && header[12] == 89 && header[13] == 52 : this.bSkipLogging && count == 14 && offset == 0 && type == 1 && (stream[12] == 89 && stream[13] == 81 || stream[12] == 89 && stream[13] == 52)) {
            return;
        }
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            int i;
            if (type == 1) {
                this.buffer.append(lineSeparator).append("Sent: (").append(LogFileStream.getCurrentTime()).append(") [Job number = ").append(this.jobID).append("] [ThreadID = ").append(Thread.currentThread().getId()).append("]").append(lineSeparator);
            } else {
                this.buffer.append(lineSeparator).append("Received: (").append(LogFileStream.getCurrentTime()).append(") [Job number = ").append(this.jobID).append("] [ThreadID = ").append(Thread.currentThread().getId()).append("]").append(lineSeparator);
            }
            int iHeaderOffset = 0;
            if (header != null) {
                this.formatOffset(0);
                iHeaderOffset = 14;
                for (i = 0; i < 14; ++i) {
                    this.appendCurrent(header[i]);
                }
                this.formatLine();
            }
            int x = offset % 14 - 1;
            int end = count;
            if (stream != null) {
                if (stream.length >= offset + count) {
                    end += offset;
                }
                if (end > 0) {
                    this.formatOffset(iHeaderOffset);
                }
                for (i = offset; i < end; ++i) {
                    this.appendCurrent(stream[i]);
                    if ((i - x) % 14 != 0) continue;
                    this.formatLine();
                    if (i + 1 >= end) continue;
                    this.formatOffset(i - offset + 1 + iHeaderOffset);
                }
                this.formatLastLine(count % 14);
            }
            PrintWriter printWriter = this.output;
            synchronized (printWriter) {
                this.output.println(this.buffer);
            }
            this.buffer.delete(0, this.buffer.length());
        }
        this.output.flush();
    }

    private synchronized void appendCurrent(byte val) {
        this.appendCurrentHex(val);
        if (val >= 32 && val < 127) {
            this.asciiDump.append((char)val);
        } else {
            this.asciiDump.append(".");
        }
    }

    private synchronized void appendCurrentHex(byte val) {
        int len;
        String x = Integer.toHexString(val).toUpperCase();
        if (x.length() == 1) {
            x = "0" + x;
        }
        if ((len = x.length()) > 2) {
            x = x.substring(len - 2, len);
        }
        if ((x = x + " ").length() == 2) {
            this.buffer.append("  ").append(x);
        } else if (x.length() == 3) {
            this.buffer.append(" ").append(x);
        } else {
            this.buffer.append(x);
        }
    }

    private synchronized void formatLine() {
        this.asciiDump.insert(0, "     ");
        this.buffer.append(this.asciiDump.toString()).append(lineSeparator);
        this.asciiDump.delete(0, this.asciiDump.length());
    }

    private synchronized void formatLastLine(int len) {
        if (len != 0) {
            for (int i = len; i < 14; ++i) {
                this.asciiDump.insert(0, "    ");
            }
        }
        this.formatLine();
    }

    private void formatOffset(int Num) {
        this.buffer.append("  ");
        String x = Integer.toHexString(Num);
        int len = x.length();
        while (len++ < 4) {
            this.buffer.append("0");
        }
        this.buffer.append(x.toUpperCase() + ": ");
    }

    public final synchronized void logApiTime(String text) {
        this.output.println();
        this.output.println(LogFileStream.getCurrentTime() + ") [Job number = " + this.jobID + "] [ThreadID = " + Thread.currentThread().getId() + "]");
        this.output.println(text);
        this.output.flush();
    }

    public final synchronized void logApi(String text) {
        this.output.println();
        this.output.println(text);
        this.output.flush();
    }

    public final void close() {
        if (!this.closed) {
            this.output.close();
            this.closed = true;
        }
    }

    protected void finalize() {
        if (!this.closed) {
            this.output.close();
        }
    }

    static {
        simpleDateFormat = new SimpleDateFormat("HH:mm:ss:SSS");
        lineSeparator = System.getProperty("line.separator");
    }
}

