/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnectionPoolDataSource;
import com.intersys.jdbc.CachePooledConnection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public final class ConnectionPoolManager
implements ConnectionEventListener {
    ConnectionPoolManager() {
    }

    synchronized PooledConnection lookup(CacheConnectionPoolDataSource ds, String user, String password) throws SQLException {
        for (CachePooledConnection pc : ds.pool) {
            if (!pc.checkConnectionParameters(ds.getURL(), user, password)) continue;
            ds.pool.remove(pc);
            ++ds.activeConnections;
            pc.addConnectionEventListener(this);
            return pc;
        }
        if (ds.getMaxPoolSize() <= ds.getPoolCount() + ds.activeConnections) {
            if (ds.getConnectionWaitTimeout() > 0) {
                try {
                    Thread.sleep(ds.getConnectionWaitTimeout() * 1000);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (ds.getMaxPoolSize() <= ds.getPoolCount() + ds.activeConnections) {
                throw new SQLException("Unable to get a connection: max pool size exceeded.");
            }
        }
        CachePooledConnection pc = new CachePooledConnection(ds, user, password);
        pc.addConnectionEventListener(this);
        ++ds.activeConnections;
        return pc;
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        CachePooledConnection pc = (CachePooledConnection)event.getSource();
        pc.returnToPool();
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        try {
            pc.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

