/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheMsgHeader;
import com.intersys.jdbc.ListItem;
import com.intersys.util.ListUtil;
import com.intersys.util.TimestampFormat;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class CacheList {
    public static final byte ITEM_UNDEF = -1;
    public static final byte ITEM_PLACEHOLDER = 0;
    public static final byte ITEM_ASCII = 1;
    public static final byte ITEM_UNICODE = 2;
    public static final byte ITEM_XUNICODE = 3;
    public static final byte ITEM_POSINT = 4;
    public static final byte ITEM_NEGINT = 5;
    public static final byte ITEM_POSNUM = 6;
    public static final byte ITEM_NEGNUM = 7;
    public static final byte ITEM_DOUBLE = 8;
    private static final long TWO_SIXTY = 0x1000000000000000L;
    private static final long TWO_SIXTY_NEG = -1152921504606846976L;
    private static final long TWO_SIXTY_NEG_REV = -6917529027641081857L;
    private static final long ONE_DAY = 86400000L;
    private static final TimeZone s_TimeZone = TimeZone.getDefault();
    private static final long HOROLOG_ZERO = -4070908800000L;
    private static double[] scale = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32, 1.0E33, 1.0E34, 1.0E35, 1.0E36, 1.0E37, 1.0E38, 1.0E39, 1.0E40, 1.0E41, 1.0E42, 1.0E43, 1.0E44, 1.0E45, 1.0E46, 1.0E47, 1.0E48, 1.0E49, 1.0E50, 1.0E51, 1.0E52, 1.0E53, 1.0E54, 1.0E55, 1.0E56, 1.0E57, 1.0E58, 1.0E59, 1.0E60, 1.0E61, 1.0E62, 1.0E63, 1.0E64, 1.0E65, 1.0E66, 1.0E67, 1.0E68, 1.0E69, 1.0E70, 1.0E71, 1.0E72, 1.0E73, 1.0E74, 1.0E75, 1.0E76, 1.0E77, 1.0E78, 1.0E79, 1.0E80, 1.0E81, 1.0E82, 1.0E83, 1.0E84, 1.0E85, 1.0E86, 1.0E87, 1.0E88, 1.0E89, 1.0E90, 1.0E91, 1.0E92, 1.0E93, 1.0E94, 1.0E95, 1.0E96, 1.0E97, 1.0E98, 1.0E99, 1.0E100, 1.0E101, 1.0E102, 1.0E103, 1.0E104, 1.0E105, 1.0E106, 1.0E107, 1.0E108, 1.0E109, 1.0E110, 1.0E111, 1.0E112, 1.0E113, 1.0E114, 1.0E115, 1.0E116, 1.0E117, 1.0E118, 1.0E119, 1.0E120, 1.0E121, 1.0E122, 1.0E123, 1.0E124, 1.0E125, 1.0E126, 1.0E127, 1.0E-128, 1.0E-127, 1.0E126, 1.0E-125, 1.0E-124, 1.0E-123, 1.0E-122, 1.0E-121, 1.0E-120, 1.0E-119, 1.0E-118, 1.0E-117, 1.0E-116, 1.0E-115, 1.0E-114, 1.0E-113, 1.0E-112, 1.0E-111, 1.0E-110, 1.0E-109, 1.0E-108, 1.0E-107, 1.0E-106, 1.0E-105, 1.0E-104, 1.0E-103, 1.0E-102, 1.0E-101, 1.0E-100, 1.0E-99, 1.0E-98, 1.0E-97, 1.0E-96, 1.0E-95, 1.0E-94, 1.0E-93, 1.0E-92, 1.0E-91, 1.0E-90, 1.0E-89, 1.0E-88, 1.0E-87, 1.0E-86, 1.0E-85, 1.0E-84, 1.0E-83, 1.0E-82, 1.0E-81, 1.0E-80, 1.0E-79, 1.0E-78, 1.0E-77, 1.0E-76, 1.0E-75, 1.0E-74, 1.0E-73, 1.0E-72, 1.0E-71, 1.0E-70, 1.0E-69, 1.0E-68, 1.0E-67, 1.0E-66, 1.0E-65, 1.0E-64, 1.0E-63, 1.0E-62, 1.0E-61, 1.0E-60, 1.0E-59, 1.0E-58, 1.0E-57, 1.0E-56, 1.0E-55, 1.0E-54, 1.0E-53, 1.0E-52, 1.0E-51, 1.0E-50, 1.0E-49, 1.0E-48, 1.0E-47, 1.0E-46, 1.0E-45, 1.0E-44, 1.0E-43, 1.0E-42, 1.0E-41, 1.0E-40, 1.0E-39, 1.0E-38, 1.0E-37, 1.0E-36, 1.0E-35, 1.0E-34, 1.0E-33, 1.0E-32, 1.0E-31, 1.0E-30, 1.0E-29, 1.0E-28, 1.0E-27, 1.0E-26, 1.0E-25, 1.0E-24, 1.0E-23, 1.0E-22, 1.0E-21, 1.0E-20, 1.0E-19, 1.0E-18, 1.0E-17, 1.0E-16, 1.0E-15, 1.0E-14, 1.0E-13, 1.0E-12, 1.0E-11, 1.0E-10, 1.0E-9, 1.0E-8, 1.0E-7, 1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1};

    public static int getListElement(int iOffsetLE, ListItem it) {
        byte[] buffer = it.buffer;
        switch (buffer[iOffsetLE]) {
            case 0: {
                int dataLength = buffer[iOffsetLE + 1] & 0xFF | (buffer[iOffsetLE + 2] & 0xFF) << 8;
                iOffsetLE += 3;
                if (dataLength == 0) {
                    dataLength = buffer[iOffsetLE] & 0xFF | (buffer[iOffsetLE + 1] & 0xFF) << 8 | (buffer[iOffsetLE + 2] & 0xFF) << 16 | (buffer[iOffsetLE + 3] & 0xFF) << 24;
                    iOffsetLE += 4;
                }
                it.type = buffer[iOffsetLE++];
                it.isNull = false;
                it.dataOffset = iOffsetLE;
                it.dataLength = --dataLength;
                it.nextOffset = it.dataOffset + it.dataLength;
                return it.nextOffset;
            }
            case 1: {
                it.dataLength = 0;
                it.isNull = true;
                it.dataOffset = iOffsetLE++;
                it.type = -1;
                it.nextOffset = iOffsetLE;
                return it.nextOffset;
            }
        }
        int dataLength = (buffer[iOffsetLE++] & 0xFF) - 2;
        it.type = buffer[iOffsetLE++];
        it.isNull = 0 == dataLength && it.type == 1;
        it.dataLength = dataLength;
        it.dataOffset = iOffsetLE;
        it.nextOffset = it.dataLength + it.dataOffset;
        return it.nextOffset;
    }

    public static int Next(byte[] buffer, int iOffsetLE) {
        int dataLength = 0;
        byte type = 0;
        switch (buffer[iOffsetLE]) {
            case 0: {
                dataLength = buffer[iOffsetLE + 1] & 0xFF | (buffer[iOffsetLE + 2] & 0xFF) << 8;
                iOffsetLE += 3;
                if (dataLength == 0) {
                    dataLength = buffer[iOffsetLE] & 0xFF | (buffer[iOffsetLE + 1] & 0xFF) << 8 | (buffer[iOffsetLE + 2] & 0xFF) << 16 | (buffer[iOffsetLE + 3] & 0xFF) << 24;
                    iOffsetLE += 4;
                }
                type = buffer[iOffsetLE - 1];
                break;
            }
            case 1: {
                type = buffer[iOffsetLE];
                ++iOffsetLE;
                break;
            }
            default: {
                dataLength = (buffer[iOffsetLE++] & 0xFF) - 2;
                type = buffer[iOffsetLE];
                ++iOffsetLE;
            }
        }
        if (dataLength > 0 && (type < 1 || type > 8)) {
            return -1;
        }
        if (iOffsetLE + dataLength > buffer.length) {
            return -1;
        }
        return iOffsetLE + dataLength;
    }

    public static int count(byte[] buffer, int length) throws SQLException {
        int i = 0;
        int offset = 0;
        while (offset < length) {
            if ((offset = CacheList.Next(buffer, offset)) < 0) {
                return -1;
            }
            ++i;
        }
        if (offset != length) {
            return -1;
        }
        return i;
    }

    public static String getString(ListItem it, String locale) throws SQLException {
        if (it.isNull) {
            return null;
        }
        switch (it.type) {
            case 1: {
                if (it.dataLength == 1 && it.buffer[it.dataOffset] == 0) {
                    return "";
                }
                try {
                    if (locale == null) {
                        return CacheList.grabLatin1String(it.buffer, it.dataOffset, it.dataLength);
                    }
                    return new String(it.buffer, it.dataOffset, it.dataLength, locale);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException("Cannot convert using server locale: unsupported Encoding:" + locale, "S2208");
                }
            }
            case 2: {
                return CacheList.grabUnicodeString(it.buffer, it.dataOffset, it.dataLength);
            }
            case 4: {
                return Long.toString(CacheList.grabPosLong(it.buffer, it.dataOffset, it.dataLength));
            }
            case 5: {
                return Long.toString(CacheList.grabNegLong(it.buffer, it.dataOffset, it.dataLength));
            }
            case 6: {
                return Float.toString(CacheList.grabPosFloat(it.buffer, it.dataOffset, it.dataLength));
            }
            case 7: {
                return Float.toString(CacheList.grabNegFloat(it.buffer, it.dataOffset, it.dataLength));
            }
            case 8: {
                return Double.toString(CacheList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength));
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1003");
    }

    public static double getDouble(ListItem it) throws SQLException {
        if (it.isNull) {
            return 0.0;
        }
        switch (it.type) {
            case 8: {
                return CacheList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case 4: {
                return CacheList.grabPosLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 5: {
                return CacheList.grabNegLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 6: {
                return ListUtil.dbl2dbl(it.buffer[it.dataOffset], CacheList.grabPosLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 7: {
                return ListUtil.dbl2dbl(it.buffer[it.dataOffset], CacheList.grabNegLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 1: {
                try {
                    return Double.parseDouble(CacheList.grabLatin1String(it.buffer, it.dataOffset, it.dataLength));
                }
                catch (Exception e) {
                    try {
                        String str = CacheList.grabNumericString(it.buffer, it.dataOffset, it.dataLength);
                        if (str.isEmpty()) {
                            return 0.0;
                        }
                        return Double.parseDouble(str);
                    }
                    catch (Exception e1) {
                        throw new SQLException(e1.getMessage());
                    }
                }
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static float getFloat(ListItem it) throws SQLException {
        if (it.isNull) {
            return 0.0f;
        }
        switch (it.type) {
            case 6: {
                return CacheList.grabPosFloat(it.buffer, it.dataOffset, it.dataLength);
            }
            case 7: {
                return CacheList.grabNegFloat(it.buffer, it.dataOffset, it.dataLength);
            }
            case 8: {
                return (float)CacheList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case 4: {
                return CacheList.grabPosLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 5: {
                return CacheList.grabNegLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 1: {
                try {
                    return Float.parseFloat(CacheList.grabLatin1String(it.buffer, it.dataOffset, it.dataLength));
                }
                catch (Exception e) {
                    try {
                        String str = CacheList.grabNumericString(it.buffer, it.dataOffset, it.dataLength);
                        if (str.isEmpty()) {
                            return 0.0f;
                        }
                        return Float.parseFloat(str);
                    }
                    catch (Exception e1) {
                        throw new SQLException(e1.getMessage());
                    }
                }
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static int getInt(ListItem it) throws SQLException {
        if (it.isNull) {
            return 0;
        }
        switch (it.type) {
            case 4: {
                return CacheList.grabPosInt(it.buffer, it.dataOffset, it.dataLength);
            }
            case 5: {
                return CacheList.grabNegInt(it.buffer, it.dataOffset, it.dataLength);
            }
            case 6: {
                return ListUtil.dblint(it.buffer[it.dataOffset], CacheList.grabPosLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 7: {
                return ListUtil.dblint(it.buffer[it.dataOffset], CacheList.grabNegLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 8: {
                return (int)CacheList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case 1: {
                long[] num = new long[1];
                int scale = ListUtil.parsenumb(it.buffer, it.dataOffset, it.dataLength, num);
                return ListUtil.dblint(scale, num[0]);
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static short getShort(ListItem it) throws SQLException {
        if (it.isNull) {
            return 0;
        }
        switch (it.type) {
            case 4: {
                return CacheList.grabPosShort(it.buffer, it.dataOffset, it.dataLength);
            }
            case 5: {
                return CacheList.grabNegShort(it.buffer, it.dataOffset, it.dataLength);
            }
            case 6: {
                return ListUtil.dblshort(it.buffer[it.dataOffset], CacheList.grabPosLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 7: {
                return ListUtil.dblshort(it.buffer[it.dataOffset], CacheList.grabNegLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 8: {
                return (short)CacheList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case 1: {
                long[] num = new long[1];
                int scale = ListUtil.parsenumb(it.buffer, it.dataOffset, it.dataLength, num);
                return ListUtil.dblshort(scale, num[0]);
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static long getLong(ListItem it) throws SQLException {
        if (it.isNull) {
            return 0L;
        }
        switch (it.type) {
            case 4: {
                return CacheList.grabPosLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 5: {
                return CacheList.grabNegLong(it.buffer, it.dataOffset, it.dataLength);
            }
            case 6: {
                return ListUtil.dbllong(it.buffer[it.dataOffset], CacheList.grabPosLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 7: {
                return ListUtil.dbllong(it.buffer[it.dataOffset], CacheList.grabNegLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 8: {
                return (long)CacheList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case 1: {
                long[] num = new long[1];
                int scale = ListUtil.parsenumb(it.buffer, it.dataOffset, it.dataLength, num);
                return ListUtil.dbllong(scale, num[0]);
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static BigDecimal getBigDecimal(ListItem it) throws SQLException {
        if (it.isNull) {
            return null;
        }
        switch (it.type) {
            case 6: {
                return CacheList.grabBigDecimal(it.buffer, it.dataOffset + 1, it.dataLength - 1, it.buffer[it.dataOffset], false);
            }
            case 7: {
                return CacheList.grabBigDecimal(it.buffer, it.dataOffset + 1, it.dataLength - 1, it.buffer[it.dataOffset], true);
            }
            case 8: {
                return new BigDecimal(CacheList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength));
            }
            case 4: {
                return CacheList.grabBigDecimal(it.buffer, it.dataOffset, it.dataLength, 0, false);
            }
            case 5: {
                return CacheList.grabBigDecimal(it.buffer, it.dataOffset, it.dataLength, 0, true);
            }
            case 1: {
                return ListUtil.parsedecb(it.buffer, it.dataOffset, it.dataLength);
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static BigDecimal getBigDecimal(ListItem it, int scale) throws SQLException {
        if (it.isNull) {
            return null;
        }
        BigDecimal bd = null;
        switch (it.type) {
            case 6: {
                bd = CacheList.grabBigDecimal(it.buffer, it.dataOffset + 1, it.dataLength - 1, it.buffer[it.dataOffset], false);
                break;
            }
            case 7: {
                bd = CacheList.grabBigDecimal(it.buffer, it.dataOffset + 1, it.dataLength - 1, it.buffer[it.dataOffset], true);
                break;
            }
            case 8: {
                bd = new BigDecimal(CacheList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength));
                break;
            }
            case 4: {
                bd = CacheList.grabBigDecimal(it.buffer, it.dataOffset, it.dataLength, 0, false);
                break;
            }
            case 5: {
                bd = CacheList.grabBigDecimal(it.buffer, it.dataOffset, it.dataLength, 0, true);
                break;
            }
            case 1: {
                bd = ListUtil.parsedecb(it.buffer, it.dataOffset, it.dataLength);
                break;
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        if (bd != null) {
            return bd.setScale(scale, RoundingMode.HALF_UP);
        }
        return bd;
    }

    public static BigInteger getBigInteger(ListItem it) throws SQLException {
        if (it.isNull) {
            return null;
        }
        switch (it.type) {
            case 4: {
                return CacheList.grabBigInteger(it.buffer, it.dataOffset, it.dataLength, false);
            }
            case 5: {
                return CacheList.grabBigInteger(it.buffer, it.dataOffset, it.dataLength, true);
            }
        }
        throw new SQLException("Element cannot be read as BigInteger", "S1000");
    }

    public static boolean getBoolean(ListItem it) throws SQLException {
        if (it.isNull) {
            return false;
        }
        switch (it.type) {
            case 4: {
                if (it.dataLength == 0) {
                    return false;
                }
            }
            case 5: 
            case 7: {
                return true;
            }
            case 6: {
                return CacheList.grabPosLong(it.buffer, it.dataOffset, it.dataLength) != 0L;
            }
            case 8: {
                throw new SQLException("Invalid boolean: item = IEEE DOUBLE", "22008", 22008);
            }
            case 1: {
                long[] num = new long[1];
                ListUtil.parsenumb(it.buffer, it.dataOffset, it.dataLength, num);
                return num[0] != 0L;
            }
            case 2: {
                throw new SQLException("Invalid boolean: item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static byte getOneByte(ListItem it) throws SQLException {
        if (it.isNull) {
            return 0;
        }
        switch (it.type) {
            case 1: {
                long[] num = new long[1];
                ListUtil.parsenumb(it.buffer, it.dataOffset, it.dataLength, num);
                return ListUtil.dblbyte(0, num[0]);
            }
            case 4: {
                return ListUtil.dblbyte(0, CacheList.grabPosLong(it.buffer, it.dataOffset, it.dataLength));
            }
            case 5: {
                return ListUtil.dblbyte(0, CacheList.grabNegLong(it.buffer, it.dataOffset, it.dataLength));
            }
            case 6: {
                return ListUtil.dblbyte(it.buffer[it.dataOffset], CacheList.grabPosLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 7: {
                return ListUtil.dblbyte(it.buffer[it.dataOffset], CacheList.grabNegLong(it.buffer, it.dataOffset + 1, it.dataLength - 1));
            }
            case 8: {
                return (byte)CacheList.grabIEEEDouble(it.buffer, it.dataOffset, it.dataLength);
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1000");
    }

    public static byte[] getByteArray(ListItem it) {
        if (it.isNull) {
            return null;
        }
        byte[] NewArray = new byte[it.dataLength];
        System.arraycopy(it.buffer, it.dataOffset, NewArray, 0, it.dataLength);
        return NewArray;
    }

    public static byte getByte(ListItem it) {
        if (it.isNull) {
            return 0;
        }
        if (0 == it.dataLength) {
            return 0;
        }
        return it.buffer[it.dataOffset];
    }

    public static byte[] getBytes(ListItem it, int len) throws SQLException {
        byte[] b;
        if (it.isNull) {
            return null;
        }
        if (len == 0 || it.dataLength < len) {
            len = it.dataLength;
        }
        switch (it.type) {
            case 1: {
                b = new byte[it.dataLength];
                System.arraycopy(it.buffer, it.dataOffset, b, 0, it.dataLength);
                break;
            }
            case 2: {
                return ListUtil.getUTF8Bytes(it.buffer, it.dataOffset, it.dataLength, len);
            }
            case 4: {
                b = new byte[]{ListUtil.dblbyte(0, CacheList.grabPosLong(it.buffer, it.dataOffset, it.dataLength))};
                break;
            }
            case 5: {
                b = new byte[]{ListUtil.dblbyte(0, CacheList.grabNegLong(it.buffer, it.dataOffset, it.dataLength))};
                break;
            }
            default: {
                throw new SQLException("Element cannot be read as byte[]", "S1000");
            }
        }
        return b;
    }

    public static Date getDate(ListItem it) throws SQLException {
        if (it.isNull) {
            return null;
        }
        if (4 == it.type || 5 == it.type) {
            if (it.dataLength > 3) {
                long time = CacheList.getLong(it);
                if (time >= 0x1000000000000000L || time < -1152921504606846976L) {
                    return CacheList.DateFromPosix(time, null);
                }
            } else {
                int time = CacheList.getInt(it);
                return CacheList.DateFromHorolog(time, null);
            }
        }
        if (1 != it.type) {
            throw new SQLException("Invalid Date", "22008", 22008);
        }
        try {
            String s = CacheList.getString(it, null);
            if (s.length() == 10) {
                return Date.valueOf(s);
            }
            if (s.length() > 10) {
                Long time;
                if ('-' != s.charAt(4) && ((time = new Long(s)) >= 0x1000000000000000L || time < -1152921504606846976L)) {
                    return CacheList.DateFromPosix(time, null);
                }
                return Date.valueOf(s.substring(0, 10));
            }
            if (s.length() <= 6) {
                int time = CacheList.getInt(it);
                return CacheList.DateFromHorolog(time, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SQLException("Invalid Date", "22008", 22008);
    }

    public static Time getTime(ListItem it) throws SQLException {
        if (it.isNull) {
            return null;
        }
        if (4 == it.type || 5 == it.type) {
            if (it.dataLength > 3) {
                return CacheList.TimeFromPosix(CacheList.getLong(it), null);
            }
            return CacheList.TimeFromHorolog(CacheList.getInt(it), null);
        }
        if (6 == it.type) {
            double dTime = CacheList.getDouble(it);
            int time = (int)dTime;
            Time tm = CacheList.TimeFromHorolog(time, null);
            int millis = (int)((dTime - (double)time) * 1000.0);
            return new Time(tm.getTime() + (long)millis);
        }
        if (1 != it.type) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        try {
            String s = CacheList.getString(it, null);
            Time nt = null;
            int iDot = s.indexOf(46);
            String scaleValue = "";
            if (iDot > 0) {
                scaleValue = s.substring(iDot + 1, s.length());
                if (scaleValue.length() > 3) {
                    scaleValue = scaleValue.substring(0, 3);
                }
                s = s.substring(0, iDot);
            }
            if (s.length() == 8) {
                nt = Time.valueOf(s);
            } else if (s.length() >= 19) {
                Long time;
                if ('-' != s.charAt(4) && ((time = new Long(s)) >= 0x1000000000000000L || time < -1152921504606846976L)) {
                    return CacheList.TimeFromPosix(time, null);
                }
                nt = Time.valueOf(s.substring(11, 19));
            } else if (s.length() <= 6) {
                int time = Integer.valueOf(s) * 1000;
                time -= s_TimeZone.getOffset(time);
                nt = new Time(time);
            }
            if (iDot > 0) {
                String sTemp = "0." + scaleValue;
                int milis = (int)(Float.parseFloat(sTemp) * 1000.0f);
                long time = nt.getTime();
                nt = new Time(time + (long)milis);
            }
            return nt;
        }
        catch (Exception exception) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Timestamp getTimestamp(ListItem it) throws SQLException {
        if (it.isNull) {
            return null;
        }
        if (4 == it.type || 5 == it.type) {
            long time = CacheList.getLong(it);
            if (time >= 0x1000000000000000L) return CacheList.TimestampFromPosix(time, null);
            if (time < -1152921504606846976L) {
                return CacheList.TimestampFromPosix(time, null);
            }
        }
        if (1 != it.type) {
            throw new SQLException("Invalid Timestamp", "22008", 22008);
        }
        try {
            String s = CacheList.getString(it, null);
            if (s.length() > 10) {
                if ('-' == s.charAt(4)) return Timestamp.valueOf(s);
                Long time = new Long(s);
                if (time >= 0x1000000000000000L) return CacheList.TimestampFromPosix(time, null);
                if (time >= -1152921504606846976L) return Timestamp.valueOf(s);
                return CacheList.TimestampFromPosix(time, null);
            }
            if (s.length() != 10) throw new SQLException("Invalid Timestamp", "22008", 22008);
            s = s.concat(" 00:00:00.0");
            return Timestamp.valueOf(s);
        }
        catch (Exception ex) {
            throw new SQLException("Invalid Timestamp", "22008", 22008);
        }
    }

    public static Date getDate(ListItem it, Calendar cal) throws SQLException {
        Long time;
        if (it.isNull) {
            return null;
        }
        if (4 == it.type || 5 == it.type) {
            if (it.dataLength > 3) {
                long time2 = CacheList.getLong(it);
                if (time2 >= 0x1000000000000000L || time2 < -1152921504606846976L) {
                    return CacheList.DateFromPosix(time2, cal);
                }
            } else {
                int time3 = CacheList.getInt(it);
                return CacheList.DateFromHorolog(time3, cal);
            }
        }
        if (1 != it.type) {
            throw new SQLException("Invalid Date", "22008", 22008);
        }
        String s = CacheList.getString(it, null);
        if (s.length() <= 6) {
            int time4 = CacheList.getInt(it);
            return CacheList.DateFromHorolog(time4, cal);
        }
        if (s.length() < 10) {
            throw new SQLException("Invalid Date", "22008", 22008);
        }
        if ('-' != s.charAt(4) && ((time = new Long(s)) >= 0x1000000000000000L || time < -1152921504606846976L)) {
            return CacheList.DateFromPosix(time, cal);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setCalendar(cal);
        try {
            java.util.Date date = dateFormat.parse(s);
            return new Date(date.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new SQLException("Invalid Date", "22008", 22008);
        }
    }

    public static Time getTime(ListItem it, Calendar cal) throws SQLException {
        Long time;
        int len;
        if (it.isNull) {
            return null;
        }
        if (4 == it.type || 5 == it.type) {
            if (it.dataLength > 3) {
                return CacheList.TimeFromPosix(CacheList.getLong(it), cal);
            }
            return CacheList.TimeFromHorolog(CacheList.getInt(it), cal);
        }
        if (6 == it.type) {
            double dTime = CacheList.getDouble(it);
            int time2 = (int)dTime;
            Time tm = CacheList.TimeFromHorolog(time2, cal);
            int millis = (int)((dTime - (double)time2) * 1000.0);
            return new Time(tm.getTime() + (long)millis);
        }
        if (1 != it.type) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        String s = CacheList.getString(it, null);
        SimpleDateFormat dateFormat = null;
        Time nt = null;
        int iDot = s.indexOf(46);
        String scaleValue = "";
        if (iDot > 0) {
            scaleValue = s.substring(iDot + 1, s.length());
            if (scaleValue.length() > 3) {
                scaleValue = scaleValue.substring(0, 3);
            }
            s = s.substring(0, iDot);
        }
        if ((len = s.length()) >= 19 && '-' != s.charAt(4) && ((time = new Long(s)) >= 0x1000000000000000L || time < -1152921504606846976L)) {
            return CacheList.TimeFromPosix(time, cal);
        }
        if (len > 19) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        } else if (19 == len) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        } else if (8 == len) {
            dateFormat = new SimpleDateFormat("HH:mm:ss");
        } else if (s.length() <= 7) {
            int time3 = Integer.valueOf(s) * 1000;
            time3 -= cal.getTimeZone().getOffset(time3);
            nt = new Time(time3);
        } else {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        if (null != dateFormat) {
            dateFormat.setCalendar(cal);
            try {
                java.util.Date date = dateFormat.parse(s);
                nt = new Time(date.getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new SQLException("Invalid Date", "22008", 22008);
            }
        }
        if (iDot > 0) {
            String sTemp = "0." + scaleValue;
            int milis = (int)(Float.parseFloat(sTemp) * 1000.0f);
            long time4 = nt.getTime();
            nt = new Time(time4 + (long)milis);
        }
        return nt;
    }

    public static Timestamp getTimestamp(ListItem it, Calendar cal) throws SQLException {
        Long time;
        long time2;
        if (it.isNull) {
            return null;
        }
        if (!(4 != it.type && 5 != it.type || (time2 = CacheList.getLong(it)) < 0x1000000000000000L && time2 >= -1152921504606846976L)) {
            return CacheList.TimestampFromPosix(time2, cal);
        }
        if (1 != it.type) {
            throw new SQLException("Invalid Timestamp", "22008", 22008);
        }
        String s = CacheList.getString(it, null);
        SimpleDateFormat dateFormat = null;
        int len = s.length();
        if (s.length() < 10) {
            throw new SQLException("Invalid Timestamp", "22008", 22008);
        }
        if ('-' != s.charAt(4) && ((time = new Long(s)) >= 0x1000000000000000L || time < -1152921504606846976L)) {
            return CacheList.TimestampFromPosix(time, cal);
        }
        if (len > 19) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        } else if (19 == len) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        } else if (len >= 10) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        } else {
            throw new SQLException("Invalid Timestamp", "22008", 22008);
        }
        dateFormat.setCalendar(cal);
        try {
            java.util.Date date = dateFormat.parse(s);
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new SQLException("Invalid Timestamp", "22008", 22008);
        }
    }

    private static BigDecimal grabBigDecimal(byte[] buffer, int offset, int len, int scale, boolean sign) {
        return ListUtil.remainingPositiveScale(CacheList.grabBigInteger(buffer, offset, len, sign), scale);
    }

    private static BigInteger grabBigInteger(byte[] buffer, int offset, int length, boolean sign) {
        byte[] b;
        if (length == 0 || sign ^ buffer[offset + length - 1] < 0) {
            b = new byte[length + 1];
            b[0] = sign ? -1 : 0;
            for (int i = length; i > 0; --i) {
                b[i] = buffer[offset++];
            }
        } else {
            b = new byte[length];
            for (int i = length - 1; i >= 0; --i) {
                b[i] = buffer[offset++];
            }
        }
        return new BigInteger(b);
    }

    private static double grabIEEEDouble(byte[] buffer, int pos, int len) throws SQLException {
        if (8 != len) {
            throw new SQLException("Numeric value out of range", "22003", 22003);
        }
        ByteBuffer ba = ByteBuffer.wrap(buffer);
        ba.order(ByteOrder.LITTLE_ENDIAN);
        return ba.getDouble(pos);
    }

    private static String grabLatin1String(byte[] buffer, int offset, int length) throws UnsupportedEncodingException {
        return new String(buffer, offset, length, "ISO-8859-1");
    }

    private static String grabNumericString(byte[] buffer, int offset, int length) throws UnsupportedEncodingException {
        String str = CacheList.grabLatin1String(buffer, offset, length);
        int lastChar = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9' || '.' == c) {
                ++lastChar;
                continue;
            }
            if (0 != i || '-' != c) break;
            ++lastChar;
        }
        return str.substring(0, lastChar);
    }

    private static float grabNegFloat(byte[] buffer, int pos, int len) throws SQLException {
        double d = scale[buffer[pos++] & 0xFF];
        return (float)((double)CacheList.grabNegLong(buffer, pos, len - 1) * d);
    }

    private static int grabNegInt(byte[] buffer, int offset, int length) throws SQLException {
        switch (length) {
            case 0: {
                return -1;
            }
            case 1: {
                return buffer[offset] & 0xFF | 0xFFFFFF00;
            }
            case 2: {
                return (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF | 0xFFFF0000;
            }
            case 3: {
                return (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF | 0xFF000000;
            }
            case 4: {
                return (buffer[offset + 3] & 0xFF) << 24 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF;
            }
        }
        throw new SQLException("Numeric value out of range", "22003", 22003);
    }

    private static long grabNegLong(byte[] buffer, int offset, int length) throws SQLException {
        switch (length) {
            case 0: {
                return -1L;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return CacheList.grabNegInt(buffer, offset, length);
            }
            case 8: {
                length = buffer[offset + 7] << 24 | (buffer[offset + 6] & 0xFF) << 16 | (buffer[offset + 5] & 0xFF) << 8 | buffer[offset + 4] & 0xFF;
                if (length < 0) break;
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
            case 7: {
                length = 0xFF000000 | (buffer[offset + 6] & 0xFF) << 16 | (buffer[offset + 5] & 0xFF) << 8 | buffer[offset + 4] & 0xFF;
                break;
            }
            case 6: {
                length = 0xFFFF0000 | (buffer[offset + 5] & 0xFF) << 8 | buffer[offset + 4] & 0xFF;
                break;
            }
            case 5: {
                length = 0xFFFFFF00 | buffer[offset + 4] & 0xFF;
                break;
            }
            default: {
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
        }
        offset = (buffer[offset + 3] & 0xFF) << 24 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF;
        return (long)length << 32 | (long)offset & 0xFFFFFFFFL;
    }

    private static short grabNegShort(byte[] buffer, int offset, int length) throws SQLException {
        switch (length) {
            case 0: {
                return -1;
            }
            case 1: {
                return (short)(buffer[offset] & 0xFF | 0xFF00);
            }
            case 2: {
                return (short)((buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF);
            }
        }
        throw new SQLException("Numeric value out of range", "22003", 22003);
    }

    private static float grabPosFloat(byte[] buffer, int pos, int len) throws SQLException {
        double d = scale[buffer[pos++] & 0xFF];
        return (float)((double)CacheList.grabPosLong(buffer, pos, len - 1) * d);
    }

    private static int grabPosInt(byte[] buffer, int offset, int length) throws SQLException {
        switch (length) {
            case 0: {
                return 0;
            }
            case 1: {
                return buffer[offset] & 0xFF;
            }
            case 2: {
                return (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF;
            }
            case 3: {
                return (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF;
            }
            case 4: {
                return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getInt(offset);
            }
        }
        throw new SQLException("Numeric value out of range", "22003", 22003);
    }

    private static long grabPosLong(byte[] buffer, int offset, int length) throws SQLException {
        long num = 0L;
        switch (length) {
            case 0: {
                return 0L;
            }
            case 1: {
                return buffer[offset] & 0xFF;
            }
            case 7: {
                num |= ((long)buffer[offset + 6] & 0xFFL) << 48;
            }
            case 6: {
                num |= ((long)buffer[offset + 5] & 0xFFL) << 40;
            }
            case 5: {
                num |= ((long)buffer[offset + 4] & 0xFFL) << 32;
            }
            case 4: {
                num |= ((long)buffer[offset + 3] & 0xFFL) << 24;
            }
            case 3: {
                num |= (long)((buffer[offset + 2] & 0xFF) << 16);
            }
            case 2: {
                return num |= (long)((buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF);
            }
            case 8: {
                return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getLong(offset);
            }
        }
        throw new SQLException("Numeric value out of range", "22003", 22003);
    }

    private static short grabPosShort(byte[] buffer, int offset, int length) throws SQLException {
        switch (length) {
            case 2: {
                return (short)((buffer[offset + 1] & 0xFF) << 8 | buffer[offset] & 0xFF);
            }
            case 1: {
                return (short)(buffer[offset] & 0xFF);
            }
            case 0: {
                return 0;
            }
        }
        throw new SQLException("Numeric value out of range", "22003", 22003);
    }

    private static String grabString(byte[] buffer, int offset, int length, String locale) throws UnsupportedEncodingException {
        return new String(buffer, offset, length, locale);
    }

    private static String grabUnicodeString(byte[] buffer, int offset, int length) {
        char[] chArray = new char[length >>>= 1];
        for (int i = 0; i < length; ++i) {
            byte b2;
            int ch = buffer[offset++] & 0xFF;
            chArray[i] = (char)((b2 = buffer[offset++]) == 0 ? ch : ch | b2 << 8);
        }
        return new String(chArray);
    }

    public static int setString(byte[] buffer, int offset, String s, String locale, boolean bUnicode) {
        return CacheList.setString(buffer, offset, s, s.length(), locale, bUnicode);
    }

    public static int setString(byte[] buffer, int offset, String s, int length, String locale, boolean bUnicodeServer) {
        if (null == s) {
            return CacheList.stuffNull(buffer, offset);
        }
        if (length == 0) {
            return CacheList.stuffEmptyString(buffer, offset);
        }
        int oldOffset = offset;
        if (-1 == (offset = CacheList.stuff7BitAscii(buffer, offset, s, length))) {
            offset = bUnicodeServer ? CacheList.stuffUNICODE(buffer, oldOffset, s, length) : CacheList.stuffMultibyte(buffer, oldOffset, s, locale);
        }
        return offset;
    }

    public static int setByteArray(byte[] buffer, int offset, byte[] source) {
        return CacheList.setByteArray(buffer, offset, source, source.length);
    }

    public static int setByteArray(byte[] buffer, int offset, byte[] source, int length) {
        offset = CacheList.addListLengthAndType(buffer, offset, length, (byte)1);
        System.arraycopy(source, 0, buffer, offset, length);
        return offset + length;
    }

    public static int setDouble(byte[] buffer, int offset, double d, boolean st_IEEEDouble) {
        if (st_IEEEDouble) {
            long bits = Double.doubleToRawLongBits(d);
            offset = CacheList.addListLengthAndType(buffer, offset, 8, (byte)8);
            offset = CacheList.stuffRawLong(buffer, offset, bits, 8);
        } else {
            offset = CacheList.setString(buffer, offset, String.valueOf(d), null, false);
        }
        return offset;
    }

    public static int setLong(byte[] buffer, int offset, Long value) throws SQLException {
        int length;
        if (value == null) {
            return CacheList.stuffNull(buffer, offset);
        }
        if (value < 0L) {
            length = value < -4294967296L ? (value < -281474976710656L ? (value < -72057594037927936L ? 8 : 7) : (value < -1099511627776L ? 6 : 5)) : (value < -65536L ? (value < -1048576L ? 4 : 3) : (value < -256L ? 2 : (value < -1L ? 1 : 0)));
            offset = CacheList.addListLengthAndType(buffer, offset, length, (byte)5);
        } else {
            length = value > 0xFFFFFFFFL ? (value > 0xFFFFFFFFFFFFL ? (value > 0xFFFFFFFFFFFFFFL ? 8 : 7) : (value > 0xFFFFFFFFFFL ? 6 : 5)) : (value > 65535L ? (value > 0xFFFFFFL ? 4 : 3) : (value > 255L ? 2 : (value > 0L ? 1 : 0)));
            offset = CacheList.addListLengthAndType(buffer, offset, length, (byte)4);
        }
        offset = CacheList.stuffRawLong(buffer, offset, value, length);
        return offset;
    }

    public static int setInt(byte[] buffer, int offset, int value) throws SQLException {
        int length;
        if (value < 0) {
            length = value < -65536 ? (value < -16777216 ? 4 : 3) : (value < -256 ? 2 : (value < -1 ? 1 : 0));
            offset = CacheList.addListLengthAndType(buffer, offset, length, (byte)5);
        } else {
            length = value > 65535 ? (value > 0xFFFFFF ? 4 : 3) : (value > 255 ? 2 : (value > 0 ? 1 : 0));
            offset = CacheList.addListLengthAndType(buffer, offset, length, (byte)4);
        }
        offset = CacheList.stuffRawInt(buffer, offset, value, length);
        return offset;
    }

    public static int setBigInteger(byte[] buffer, int offset, BigInteger value) throws SQLException {
        int newLen;
        int off;
        if (value == null) {
            return CacheList.stuffNull(buffer, offset);
        }
        byte[] b = value.toByteArray();
        int len = b.length;
        boolean isNegative = b[0] < 0;
        if (isNegative) {
            for (off = 0; off < len && b[off] == 255; ++off) {
            }
            if (off == len) {
                --off;
                newLen = 1;
            } else {
                newLen = len - off;
            }
        } else {
            while (off < len && b[off] == 0) {
                ++off;
            }
            if (off == len) {
                return CacheList.setInt(buffer, offset, 0);
            }
            newLen = len - off;
        }
        byte type = isNegative ? (byte)5 : 4;
        offset = CacheList.addListLengthAndType(buffer, offset, newLen, type);
        for (int j = 1; j <= newLen; ++j) {
            buffer[offset++] = b[len - j];
        }
        return offset;
    }

    public static int setBigDecimal(byte[] buffer, int offset, BigDecimal value) throws SQLException {
        int scale = value.scale();
        BigInteger n = value.unscaledValue();
        int len = n.bitLength();
        if (len < 64 && scale <= 128) {
            byte type;
            int off;
            byte[] b = n.toByteArray();
            len = b.length;
            int n2 = off = b[0] == 0 || b[0] == 255 ? 1 : 0;
            if (scale == 0) {
                type = b[0] >= 0 ? (byte)4 : 5;
                offset = CacheList.addListLengthAndType(buffer, offset, b.length - off, type);
            } else {
                type = b[0] >= 0 ? (byte)6 : 7;
                offset = CacheList.addListLengthAndType(buffer, offset, b.length - off + 1, type);
                buffer[offset++] = (byte)(-scale);
            }
            while (len > off) {
                buffer[offset++] = b[--len];
            }
        } else {
            String s = ListUtil.scaledDecimaltoString(-scale, n);
            offset = CacheList.stuff7BitAscii(buffer, offset, s, s.length());
        }
        return offset;
    }

    public static int setDate(byte[] buffer, int offset, Date value) throws SQLException {
        return CacheList.setString(buffer, offset, value.toString(), null, false);
    }

    public static int setDate(byte[] buffer, int offset, Date value, Calendar calendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setCalendar(calendar);
        return CacheList.setString(buffer, offset, dateFormat.format(new java.util.Date(value.getTime())), null, false);
    }

    public static int setTime(byte[] buffer, int offset, Time value) throws SQLException {
        return CacheList.setString(buffer, offset, value.toString(), null, false);
    }

    public static int setTime(byte[] buffer, int offset, Time value, Calendar calendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        dateFormat.setCalendar(calendar);
        return CacheList.setString(buffer, offset, dateFormat.format(new java.util.Date(value.getTime())), null, false);
    }

    public static int setTimestamp(byte[] buffer, int offset, Timestamp value) throws SQLException {
        return CacheList.setString(buffer, offset, ListUtil.canonizeTimestampString(value.toString()), null, false);
    }

    public static int setTimestamp(byte[] buffer, int offset, Timestamp value, Calendar calendar) {
        TimestampFormat dateFormat = new TimestampFormat();
        dateFormat.setCalendar(calendar);
        return CacheList.setString(buffer, offset, dateFormat.format((java.util.Date)value), null, false);
    }

    public static int setDatePosix(byte[] buffer, int offset, Date value) throws SQLException {
        return CacheList.setLong(buffer, offset, CacheList.PosixFromTime(value.getTime(), null));
    }

    public static int setDatePosix(byte[] buffer, int offset, java.util.Date value) throws SQLException {
        return CacheList.setLong(buffer, offset, CacheList.PosixFromTime(value.getTime(), null));
    }

    public static int setDatePosix(byte[] buffer, int offset, Date value, Calendar calendar) throws SQLException {
        return CacheList.setLong(buffer, offset, CacheList.PosixFromTime(value.getTime(), calendar));
    }

    public static int setDatePosix(byte[] buffer, int offset, java.util.Date value, Calendar calendar) throws SQLException {
        return CacheList.setLong(buffer, offset, CacheList.PosixFromTime(value.getTime(), calendar));
    }

    public static int setTimePosix(byte[] buffer, int offset, Time value) throws SQLException {
        return CacheList.setLong(buffer, offset, CacheList.PosixFromTime(value.getTime(), null));
    }

    public static int setTimePosix(byte[] buffer, int offset, Time value, Calendar calendar) throws SQLException {
        return CacheList.setLong(buffer, offset, CacheList.PosixFromTime(value.getTime(), calendar));
    }

    public static int setTimestampPosix(byte[] buffer, int offset, Timestamp value) throws SQLException {
        return CacheList.setLong(buffer, offset, CacheList.PosixFromTime(value.getTime(), value.getNanos(), null));
    }

    public static int setTimestampPosix(byte[] buffer, int offset, Timestamp value, Calendar calendar) throws SQLException {
        return CacheList.setLong(buffer, offset, CacheList.PosixFromTime(value.getTime(), value.getNanos(), calendar));
    }

    public static int setDateH(byte[] buffer, int offset, java.util.Date value) throws SQLException {
        return CacheList.setInt(buffer, offset, CacheList.HorologFromDate(value.getTime(), null));
    }

    public static int setDateH(byte[] buffer, int offset, Date value, Calendar calendar) throws SQLException {
        return CacheList.setInt(buffer, offset, CacheList.HorologFromDate(value.getTime(), calendar));
    }

    public static int setDateH(byte[] buffer, int offset, java.util.Date value, Calendar calendar) throws SQLException {
        return CacheList.setInt(buffer, offset, CacheList.HorologFromDate(value.getTime(), calendar));
    }

    public static int setTimeH(byte[] buffer, int offset, Time value) throws SQLException {
        return CacheList.setInt(buffer, offset, CacheList.HorologFromTime(value.getTime(), null));
    }

    public static int setTimeH(byte[] buffer, int offset, Time value, Calendar calendar) throws SQLException {
        return CacheList.setInt(buffer, offset, CacheList.HorologFromTime(value.getTime(), calendar));
    }

    public static int setTimeH(byte[] buffer, int offset, Time value, String fractions, Calendar calendar) throws SQLException {
        String out = Integer.toString(CacheList.HorologFromTime(value.getTime(), calendar));
        out = out + ".";
        out = out + fractions;
        return CacheList.setString(buffer, offset, out, null, false);
    }

    private static int HorologFromTime(long time, Calendar calendar) {
        long offset;
        int horolog;
        Timestamp ts = new Timestamp(time);
        if (ts.getNanos() > 0) {
            ts.setNanos(0);
            time = ts.getTime();
        }
        if ((horolog = (int)(((offset = null == calendar ? (long)s_TimeZone.getOffset(time) : (long)calendar.getTimeZone().getOffset(time)) + time) % 86400000L / 1000L)) < 0) {
            horolog = 86400 + horolog;
        }
        return horolog;
    }

    private static int HorologFromDate(long time, Calendar calendar) {
        long offset = null == calendar ? (long)s_TimeZone.getOffset(time) : (long)calendar.getTimeZone().getOffset(time);
        long delta = (time += offset) - -4070908800000L;
        int date = (int)(delta / 86400000L);
        int modulo = (int)(delta % 86400000L);
        if (modulo < 0) {
            --date;
        }
        return date;
    }

    private static Time TimeFromHorolog(int horolog, Calendar calendar) {
        int time = horolog * 1000;
        long offset = null == calendar ? (long)s_TimeZone.getOffset(time) : (long)calendar.getTimeZone().getOffset(time);
        time = (int)((long)time - offset);
        return new Time(time);
    }

    private static Date DateFromHorolog(int horolog, Calendar calendar) {
        long time = -4070908800000L + (long)horolog * 86400000L;
        long offset = null == calendar ? (long)s_TimeZone.getOffset(time) : (long)calendar.getTimeZone().getOffset(time);
        Date date = new Date(time -= offset);
        if (null != calendar) {
            date = Date.valueOf(date.toString());
        }
        return date;
    }

    private static long PosixFromTime(long time, Calendar calendar) {
        long offset = null == calendar ? (long)s_TimeZone.getOffset(time) : (long)calendar.getTimeZone().getOffset(time);
        long posix = (time + offset) * 1000L;
        if (posix < 0L) {
            return posix & 0x9FFFFFFFFFFFFFFFL;
        }
        return posix | 0x1000000000000000L;
    }

    private static long PosixFromTime(long time, int nanos, Calendar calendar) {
        long offset = null == calendar ? (long)s_TimeZone.getOffset(time) : (long)calendar.getTimeZone().getOffset(time);
        long posix = (time + offset) * 1000L;
        if (nanos > 0 && nanos != nanos / 1000000 * 1000000) {
            posix += (long)((nanos - nanos / 1000000 * 1000000) / 1000);
        }
        if (posix < 0L) {
            return posix & 0x9FFFFFFFFFFFFFFFL;
        }
        return posix | 0x1000000000000000L;
    }

    private static Date DateFromPosix(long posix, Calendar calendar) {
        long time0 = posix >= 0L ? posix ^ 0x1000000000000000L : posix | 0xF000000000000000L;
        long time = time0 / 1000L;
        long offset = null == calendar ? (long)s_TimeZone.getOffset(time) : (long)calendar.getTimeZone().getOffset(time);
        return new Date(time -= offset);
    }

    private static Time TimeFromPosix(long posix, Calendar calendar) {
        TimeZone tz;
        long time0 = posix >= 0L ? posix ^ 0x1000000000000000L : posix | 0xF000000000000000L;
        long time = time0 / 1000L;
        boolean nanos = false;
        if (time * 1000L != time0) {
            nanos = true;
        }
        if ((tz = null == calendar ? s_TimeZone : calendar.getTimeZone()).inDaylightTime(new Date(time -= (long)tz.getRawOffset()))) {
            time -= (long)tz.getDSTSavings();
        }
        return new Time(time);
    }

    private static Timestamp TimestampFromPosix(long posix, Calendar calendar) {
        TimeZone tz;
        long time0 = posix >= 0L ? posix ^ 0x1000000000000000L : posix | 0xF000000000000000L;
        long time = time0 / 1000L;
        boolean nanos = false;
        if (time * 1000L != time0) {
            nanos = true;
        }
        if ((tz = null == calendar ? s_TimeZone : calendar.getTimeZone()).inDaylightTime(new Date(time -= (long)tz.getRawOffset()))) {
            time -= (long)tz.getDSTSavings();
        }
        Timestamp timestmp = new Timestamp(time);
        if (nanos) {
            long xNano = (time0 - time0 / 1000000L * 1000000L) * 1000L;
            if (xNano < 0L) {
                timestmp = new Timestamp(time -= 1000L);
                xNano = 1000000000L + xNano;
            }
            timestmp.setNanos((int)xNano);
        }
        return timestmp;
    }

    public static int setBoolean(byte[] buffer, int offset, boolean value) throws SQLException {
        if (value) {
            return CacheList.setInt(buffer, offset, 1);
        }
        return CacheList.setInt(buffer, offset, 0);
    }

    public static int setUndefined(byte[] buffer, int offset) {
        buffer[offset++] = 1;
        return offset;
    }

    private static int addListLengthAndType(byte[] buffer, int off, int len, byte type) {
        if (++len < 255) {
            buffer[off] = (byte)(++len);
            buffer[off + 1] = type;
            return off + 2;
        }
        if (len <= 65535) {
            buffer[off] = 0;
            buffer[off + 1] = (byte)len;
            buffer[off + 2] = (byte)(len >> 8);
            buffer[off + 3] = type;
            return off + 4;
        }
        buffer[off] = 0;
        buffer[off + 1] = 0;
        buffer[off + 2] = 0;
        buffer[off + 3] = (byte)len;
        buffer[off + 4] = (byte)(len >> 8);
        buffer[off + 5] = (byte)(len >> 16);
        buffer[off + 6] = 0;
        buffer[off + 7] = type;
        return off + 8;
    }

    static int stuffEmptyString(byte[] buffer, int offset) {
        buffer[offset++] = 3;
        buffer[offset++] = 1;
        buffer[offset++] = 0;
        return offset;
    }

    private static int stuffNull(byte[] buffer, int offset) {
        buffer[offset++] = 2;
        buffer[offset++] = 1;
        return offset;
    }

    static int stuffUNICODE(byte[] buffer, int offset, String s, int length) {
        int l = length * 2;
        offset = CacheList.addListLengthAndType(buffer, offset, l, (byte)2);
        int j = 0;
        while (j < length) {
            char c = s.charAt(j);
            buffer[offset] = (byte)c;
            buffer[offset + 1] = (byte)(c >> 8);
            ++j;
            offset += 2;
        }
        return offset;
    }

    static int stuffMultibyte(byte[] buffer, int offset, String s, String st_serverLocale) {
        byte[] ascii;
        try {
            if (st_serverLocale == null) {
                if (-1 == (offset = CacheList.stuff7BitAscii(buffer, offset, s, s.length()))) {
                    throw new IllegalStateException("Null locale");
                }
                return offset;
            }
            ascii = s.getBytes(st_serverLocale);
        }
        catch (UnsupportedEncodingException e) {
            ascii = s.getBytes();
        }
        int length = ascii.length;
        offset = CacheList.addListLengthAndType(buffer, offset, length, (byte)1);
        System.arraycopy(ascii, 0, buffer, offset, length);
        return offset + length;
    }

    static int stuff7BitAscii(byte[] buffer, int offset, String s, int length) {
        int l = length;
        offset = CacheList.addListLengthAndType(buffer, offset, l, (byte)1);
        for (int j = 0; j < l; ++j) {
            char c = s.charAt(j);
            if (c > '\u007f') {
                return -1;
            }
            buffer[offset++] = (byte)c;
        }
        return offset;
    }

    private static int stuffRawLong(byte[] buffer, int offset, long value, int len) {
        switch (len) {
            case 8: {
                buffer[offset + 7] = (byte)(value >> 56);
            }
            case 7: {
                buffer[offset + 6] = (byte)(value >> 48);
            }
            case 6: {
                buffer[offset + 5] = (byte)(value >> 40);
            }
            case 5: {
                buffer[offset + 4] = (byte)(value >> 32);
            }
            case 4: {
                buffer[offset + 3] = (byte)(value >> 24);
            }
            case 3: {
                buffer[offset + 2] = (byte)(value >> 16);
            }
            case 2: {
                buffer[offset + 1] = (byte)(value >> 8);
            }
            case 1: {
                buffer[offset] = (byte)value;
            }
        }
        return offset + len;
    }

    static int stuffRawInt(byte[] buffer, int offset, int value, int len) {
        switch (len) {
            case 4: {
                buffer[offset + 3] = (byte)(value >> 24);
            }
            case 3: {
                buffer[offset + 2] = (byte)(value >> 16);
            }
            case 2: {
                buffer[offset + 1] = (byte)(value >> 8);
            }
            case 1: {
                buffer[offset + 0] = (byte)value;
            }
        }
        return offset + len;
    }

    static int read4ByteInt(byte[] ba, int offset) {
        int val = ba[offset] & 0xFF;
        val |= (ba[offset + 1] & 0xFF) << 8;
        val |= (ba[offset + 2] & 0xFF) << 16;
        return val |= (ba[offset + 3] & 0xFF) << 24;
    }

    public static String toString(byte[] buffer, int length, String serverLocale) {
        StringBuffer sb = new StringBuffer();
        sb.append("$lb(");
        if (0 == length) {
            sb.append(")");
            return sb.toString();
        }
        try {
            int iOffset = 0;
            boolean bFirst = true;
            while (length > iOffset) {
                if (!bFirst) {
                    bFirst = false;
                    sb.append(',');
                }
                iOffset = CacheList.toStringHelper(sb, buffer, length, iOffset, serverLocale);
            }
        }
        catch (SQLException x) {
            // empty catch block
        }
        sb.append(")");
        return sb.toString();
    }

    private static int toStringHelper(StringBuffer sb, byte[] buffer, int length, int iOffset, String serverLocale) throws SQLException {
        ListItem it = new ListItem(buffer);
        boolean firstTime = true;
        block9: while (iOffset < length) {
            if (sb.length() > 2000) {
                sb.append("...");
                iOffset = length;
                break;
            }
            iOffset = CacheList.getListElement(iOffset, it);
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(",");
            }
            if (it.isNull) {
                sb.append("null");
                continue;
            }
            switch (it.type) {
                case 1: {
                    try {
                        StringBuffer sb1 = new StringBuffer();
                        sb1.append("$lb(");
                        iOffset = CacheList.toStringHelper(sb1, buffer, it.dataOffset + it.dataLength, it.dataOffset, serverLocale);
                        sb.append(sb1);
                        sb.append(')');
                    }
                    catch (Exception ex) {
                        sb.append(CacheList.getString(it, serverLocale));
                        iOffset = it.nextOffset;
                    }
                    continue block9;
                }
                case 2: {
                    sb.append(CacheList.getString(it, serverLocale));
                    iOffset = it.nextOffset;
                    sb.append(')');
                    continue block9;
                }
                case 4: 
                case 5: {
                    sb.append((Object)CacheList.getLong(it));
                    iOffset = it.nextOffset;
                    continue block9;
                }
                case 6: 
                case 7: {
                    sb.append(Float.valueOf(CacheList.getFloat(it)));
                    iOffset = it.nextOffset;
                    continue block9;
                }
                case 8: {
                    sb.append((Object)CacheList.getDouble(it));
                    iOffset = it.nextOffset;
                    continue block9;
                }
            }
            throw new SQLException("Incorrect list format, unknown type: " + it.type, "S1003");
        }
        return iOffset;
    }

    private static String verboseHeader(byte[] buffer) {
        try {
            CacheMsgHeader head = new CacheMsgHeader(buffer);
            StringBuffer sb = new StringBuffer();
            sb.append('[').append(head.getMessageLength()).append(',').append(head.getCount()).append(',').append(head.getStatementID()).append(',').append(head.getMsgType()).append(']');
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void dump(byte[] buffer, int iOffset, int iLength) {
        int total;
        if (iLength <= 0) {
            iLength = 2800;
        }
        if (iLength > (total = buffer.length - iOffset)) {
            iLength = total;
        }
        int iDelta = 14;
        for (int i = iOffset; i < iLength; i += iDelta) {
            System.out.print("\n");
            String x = Integer.toHexString(i);
            int len = x.length();
            while (len++ < 4) {
                System.out.print("0");
            }
            System.out.print(x.toUpperCase() + ": ");
            int j = 0;
            for (j = 0; j < iDelta && i + j < iLength; ++j) {
                x = Integer.toHexString(buffer[i + j]).toUpperCase();
                len = x.length();
                if (1 == len) {
                    x = "0" + x;
                }
                if (len > 2) {
                    x = x.substring(len - 2, len);
                }
                if ((x = x + " ").length() == 2) {
                    System.out.print("  ");
                } else if (x.length() == 3) {
                    System.out.print(" ");
                }
                System.out.print(x);
            }
            for (int k = j + 1; k < iDelta; ++k) {
                System.out.print("    ");
            }
            System.out.print("\t");
            for (j = 0; j < iDelta && i + j < iLength; ++j) {
                byte val = buffer[i + j];
                if (val >= 32 && val < 127) {
                    System.out.print((char)val);
                    continue;
                }
                System.out.print(".");
            }
        }
        System.out.print("\n");
    }
}

