/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBlob;
import com.intersys.jdbc.CacheClob;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheInputStream;
import com.intersys.jdbc.CacheNClob;
import com.intersys.jdbc.CachePreparedStatement;
import com.intersys.jdbc.CacheReader;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.Descriptor;
import com.intersys.jdbc.ExecParameter;
import com.intersys.jdbc.ObjectFactory;
import com.intersys.util.ListUtil;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public final class CacheCallableStatement
extends CachePreparedStatement
implements CallableStatement {
    static final int RESULT_SET_TYPE = -51;

    CacheCallableStatement(CacheConnection conn, String sql) throws SQLException {
        super(conn, 1003, 1007, sql, null);
    }

    CacheCallableStatement(CacheConnection conn, String sql, int statementType, long paramCount) throws SQLException {
        super(conn, 1003, sql, statementType, paramCount);
    }

    CacheCallableStatement(CacheConnection conn) throws SQLException {
        super(conn);
    }

    @Override
    public synchronized void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(parameterIndex, -1);
            return;
        }
        this.setParameterMode(this.getAbsoluteParameterIndex(parameterIndex));
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(parameterIndex, scale);
            return;
        }
        this.setParameterModeAndScale(this.getAbsoluteParameterIndex(parameterIndex), scale);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.outputParameterList.isNull();
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getBoolean(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getBoolean(this.getListPosition(i));
    }

    @Override
    public byte getByte(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getByte(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getOneByte(this.getListPosition(i));
    }

    @Override
    public short getShort(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getShort(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getShort(this.getListPosition(i));
    }

    @Override
    public int getInt(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getInt(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getInt(this.getListPosition(i));
    }

    @Override
    public long getLong(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getLong(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getLong(this.getListPosition(i));
    }

    @Override
    public float getFloat(int i) throws SQLException {
        return (float)this.getDouble(i);
    }

    @Override
    public double getDouble(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getDouble(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getDouble(this.getListPosition(i));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int i, int scale) throws SQLException {
        if (this.execParams != null) {
            return this.getBigDecimal(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getBigDecimal(this.getListPosition(i), scale);
    }

    @Override
    public String getString(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getString(this.getExecParam((int)i).name);
        }
        CacheStatement.Parameter param = this.getParameter(i);
        switch (param.type) {
            case 2: 
            case 3: 
            case 6: {
                BigDecimal bd = this.outputParameterList.getBigDecimalScale(this.getListPosition(i), param.scale, param.precision, true);
                if (bd == null) {
                    return null;
                }
                return ListUtil.toString(bd);
            }
            case 8: {
                double dbl = this.getDouble(i);
                if (this.outputParameterList.isNull()) {
                    return null;
                }
                return String.valueOf(dbl);
            }
            case -4: {
                CacheInputStream x = new CacheInputStream(this.connection, this.outputParameterList.getString(this.getListPosition(i)).getBytes(), this.serverCursorNumber, 1);
                if (x.isNull()) {
                    return null;
                }
                return x.toUnicodeString();
            }
            case -1: {
                CacheReader x = new CacheReader(this.connection, this.outputParameterList.getString(this.getListPosition(i)).getBytes(), this.serverCursorNumber);
                if (x.isNull()) {
                    return null;
                }
                return x.toUnicodeString();
            }
        }
        String str = this.outputParameterList.getString(this.getListPosition(i));
        return str;
    }

    @Override
    public byte[] getBytes(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getBytes(this.getExecParam((int)i).name);
        }
        int jdbcType = this.getParameterTypeAbsolute(i);
        if (jdbcType == -1 || jdbcType == -4) {
            String oid = this.outputParameterList.getString(this.getListPosition(i));
            if (oid == null) {
                return null;
            }
            CacheInputStream x = new CacheInputStream(this.connection, oid.getBytes(), this.serverCursorNumber, 1);
            if (x.isNull()) {
                return null;
            }
            return x.toByte();
        }
        return this.outputParameterList.getByteArray(this.getListPosition(i));
    }

    @Override
    public Date getDate(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getDate(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getDate(this.getListPosition(i));
    }

    @Override
    public Time getTime(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getTime(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getTime(this.getListPosition(i));
    }

    @Override
    public Timestamp getTimestamp(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getTimestamp(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getTimestamp(this.getListPosition(i));
    }

    @Override
    public synchronized Object getObject(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getObject(this.getExecParam((int)i).name);
        }
        Descriptor desc = (Descriptor)this.parameters.get(i - 1);
        int pos = this.getListPosition(i);
        Object obj = null;
        switch (desc.type) {
            case 12: {
                obj = this.outputParameterList.getString(pos);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                obj = this.outputParameterList.getInt(pos);
                break;
            }
            case 8: {
                obj = this.outputParameterList.getDouble(pos);
                break;
            }
            case 2: {
                obj = this.outputParameterList.getBigDecimal(pos, desc.scale);
                break;
            }
            case -7: {
                obj = this.outputParameterList.getBoolean(pos);
                break;
            }
            case 91: {
                obj = this.outputParameterList.getDate(pos);
                break;
            }
            case 92: {
                obj = this.outputParameterList.getTime(pos);
                break;
            }
            case 93: {
                obj = this.outputParameterList.getTimestamp(pos);
                break;
            }
            case -3: 
            case -2: {
                obj = this.outputParameterList.getByteArray(pos);
                break;
            }
            case -5: {
                obj = this.outputParameterList.getLong(pos);
                break;
            }
            case -1: {
                obj = this.getCharacterStream(i);
                break;
            }
            case -4: {
                obj = this.getBinaryStream(i);
                break;
            }
            case -51: {
                obj = this.getResultSet(this.outputParameterList.getString(pos));
                break;
            }
            case 2002: {
                obj = this.fetchStruct(this.outputParameterList.getString(pos));
                break;
            }
            default: {
                obj = this.outputParameterList.getString(pos);
            }
        }
        if (this.outputParameterList.isNull()) {
            return null;
        }
        return obj;
    }

    @Override
    final synchronized void prepare(String sql, int statementType, long paramCount) throws SQLException {
        this.preparse(sql, statementType, paramCount);
        if (!this.getCachedInfo(this.sqlText)) {
            this.prepareStoredProcedure();
        }
    }

    @Override
    final synchronized void prepare(String sql) throws SQLException {
        this.preparse(sql);
        if (!this.getCachedInfo(this.sqlText)) {
            this.prepareStoredProcedure();
        }
    }

    private int getListPosition(int parameterIndex) throws SQLException {
        if (parameterIndex > this.parameters.size()) {
            throw new SQLException("Invalid parameter number", "S1093", 466);
        }
        if (parameterIndex == 1 && this.hasReturnValue == 2) {
            if (!this.isOutParameter(0)) {
                throw new SQLException("Invalid parameter number", "S1093", 466);
            }
            return 0;
        }
        int ord = 0;
        int i = 0;
        int parIndex = parameterIndex;
        if (this.hasReturnValue == 1) {
            i = 1;
            ord = 1;
        } else {
            --parIndex;
        }
        while (i < this.parameters.size()) {
            int mode = this.getParameterMode(i);
            if (mode != 5) {
                if (ord == parIndex) {
                    if (!this.isOutParameter(i)) {
                        throw new SQLException("Invalid parameter number", "S1093", 466);
                    }
                    return this.paramRow.rowIndex[i];
                }
                ++ord;
            }
            ++i;
        }
        throw new SQLException("Invalid parameter number " + parameterIndex, "S1093", 466);
    }

    private int getParameterNumber(String name) throws SQLException {
        this.namedParameters = true;
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!name.equalsIgnoreCase(((CacheStatement.Parameter)this.parameters.get((int)i)).name)) continue;
            return i;
        }
        throw new SQLException("No such parameter: " + name, "S1093", 466);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ResultSet getResultSet(String oref) throws SQLException {
        if (oref == null) {
            return null;
        }
        CacheStatement statement = new CacheStatement(this.connection, 1003, 1007, null);
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            statement.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.GET_CACHE_RESULT_SET_OBJECT);
            statement.output.wire.set(oref);
            statement.output.wire.set(0);
            statement.output.send(this.connection.messageCount.getCount());
            int error = statement.input.readMessage(this, 0, 100);
            if (error == 100) {
                statement.fetchDone = true;
            }
            statement.columnInfo(statement.input.wire);
        }
        CacheResultSet crs = new CacheResultSet(statement, oref);
        if (!statement.fetchDone) {
            crs.requestFetch(this.connection.messageCount.getCount());
            statement.weakResultSetReference = new WeakReference<CacheResultSet>(crs);
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object fetchStruct(String oref) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.connection.outMessage.wire.writeHeader(this.serverCursorNumber, CacheConnection.GET_STRUCT_OBJECT);
            this.connection.outMessage.wire.set(oref);
            this.connection.outMessage.send(this.connection.messageCount.getCount());
            this.connection.inMessage.readMessage(this, 0, 0);
            ObjectFactory factory = this.connection.registerDatabase().getObjectFactory(this.connection);
            return factory.deserialize(this.connection.inMessage.wire.getSysList(this.connection.getConnectionInfo()));
        }
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getBigDecimal(this.getExecParam((int)i).name);
        }
        return this.outputParameterList.getBigDecimal(this.getListPosition(i), ((CacheStatement.Parameter)this.parameters.get((int)(i - 1))).scale);
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        if (this.execParams != null) {
            return this.getDate(this.getExecParam((int)i).name, cal);
        }
        return this.outputParameterList.getDate(this.getListPosition(i), cal);
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        if (this.execParams != null) {
            return this.getTime(this.getExecParam((int)i).name, cal);
        }
        return this.outputParameterList.getTime(this.getListPosition(i), cal);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        if (this.execParams != null) {
            return this.getTimestamp(this.getExecParam((int)i).name, cal);
        }
        return this.outputParameterList.getTimestamp(this.getListPosition(i), cal);
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(paramIndex, -1);
            return;
        }
        if (sqlType == 2002 || sqlType == 2001 || sqlType == 2000 || sqlType == 2006) {
            throw new SQLException("Type not supported: " + sqlType, "IM001");
        }
        this.registerOutParameter(paramIndex, sqlType);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getBlob(this.getExecParam((int)i).name);
        }
        if (this.getParameterTypeAbsolute(i) != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        String str = this.outputParameterList.getString(this.getListPosition(i));
        if (str == null) {
            return null;
        }
        CacheBlob blob = new CacheBlob(this.connection, str.getBytes(), this.serverCursorNumber);
        if (blob.isNull()) {
            return null;
        }
        return blob;
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        if (this.execParams != null) {
            return this.getClob(this.getExecParam((int)i).name);
        }
        if (this.getParameterTypeAbsolute(i) != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        String str = this.outputParameterList.getString(this.getListPosition(i));
        if (str == null) {
            return null;
        }
        CacheClob clob = new CacheClob(this.connection, str.getBytes(), this.serverCursorNumber);
        if (clob.isNull()) {
            return null;
        }
        return clob;
    }

    private void setExecParamMode(int parameterIndex, int scale) throws SQLException {
        ExecParameter execParameter = this.getExecParam(parameterIndex);
        if (execParameter.mode == 1 || execParameter.mode == 2) {
            execParameter.mode = 2;
        } else if (execParameter.mode == 0 || execParameter.mode == 4) {
            execParameter.mode = 4;
        }
        execParameter.bound = true;
        execParameter.scale = scale;
    }

    private void setExecParamMode(String parameterName, int scale) throws SQLException {
        ExecParameter execParameter = this.getExecParamByName(parameterName);
        if (execParameter == null) {
            throw new SQLException("No such parameter: " + parameterName);
        }
        execParameter.mode = 2;
        execParameter.bound = true;
        execParameter.scale = scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNamedGeneric(String parameterName, Object obj, Object whatever) throws SQLException {
        if (this.execParams != null) {
            ExecParameter execParameter = this.getExecParamByName(parameterName);
            if (execParameter == null) {
                throw new SQLException("No such parameter: " + parameterName);
            }
            execParameter.value = obj;
            execParameter.bound = true;
            return;
        }
        int index = this.getParameterNumber(parameterName);
        List list = this.parameters;
        synchronized (list) {
            ((CacheStatement.Parameter)this.parameters.get(index)).bind(obj, whatever, this.parameterSets);
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(parameterName, -1);
            return;
        }
        this.setParameterMode(this.getParameterNumber(parameterName));
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(parameterName, scale);
            return;
        }
        this.setParameterModeAndScale(this.getParameterNumber(parameterName), scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.execParams != null) {
            this.setExecParamMode(parameterName, -1);
            return;
        }
        this.setParameterMode(this.getParameterNumber(parameterName));
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNamedGeneric(parameterName, null, null);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNamedGeneric(parameterName, null, null);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.setNamedGeneric(parameterName, Float.valueOf(x), null);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        if (x.markSupported()) {
            x.mark(0);
        }
        this.setNamedGeneric(parameterName, new CacheStatement.StreamWrapper(x, 0, length), null);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        if (((CacheStatement.Parameter)this.parameters.get((int)this.getParameterNumber((String)parameterName))).type == -1) {
            throw new SQLException("Unsupported type conversion: (binary) InputStream to java.sql.Types.LONGVARCHAR.", "S1000");
        }
        if (x.markSupported()) {
            x.mark(0);
        }
        this.setNamedGeneric(parameterName, new CacheStatement.StreamWrapper(x, 1, length), null);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        if (targetSqlType == 2 || targetSqlType == 3) {
            this.setNamedGeneric(parameterName, x, new Integer(scale));
        } else {
            this.setNamedGeneric(parameterName, x, null);
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.setNamedGeneric(parameterName, x, null);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        this.setNamedGeneric(parameterName, new CacheStatement.StreamWrapper(reader, 4, length), null);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setNamedGeneric(parameterName, x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setNamedGeneric(parameterName, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setNamedGeneric(parameterName, x, cal);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        int index = this.getParameterNumber(parameterName);
        String str = this.outputParameterList.getString(this.paramRow.rowIndex[index]);
        if (str == null) {
            return null;
        }
        int jdbcType = ((CacheStatement.Parameter)this.parameters.get((int)index)).type;
        if (jdbcType == -4) {
            CacheInputStream x = new CacheInputStream(this.connection, str.getBytes(), this.serverCursorNumber, 1);
            if (x.isNull()) {
                return null;
            }
            return x.toUnicodeString();
        }
        if (jdbcType == -1) {
            CacheReader x = new CacheReader(this.connection, str.getBytes(), this.serverCursorNumber);
            if (x.isNull()) {
                return null;
            }
            return x.toUnicodeString();
        }
        return str;
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.outputParameterList.getBoolean(this.paramRow.rowIndex[this.getParameterNumber(parameterName)]);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.outputParameterList.getOneByte(this.paramRow.rowIndex[this.getParameterNumber(parameterName)]);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.outputParameterList.getShort(this.paramRow.rowIndex[this.getParameterNumber(parameterName)]);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.outputParameterList.getInt(this.paramRow.rowIndex[this.getParameterNumber(parameterName)]);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.outputParameterList.getLong(this.paramRow.rowIndex[this.getParameterNumber(parameterName)]);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.outputParameterList.getFloat(this.paramRow.rowIndex[this.getParameterNumber(parameterName)]);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.outputParameterList.getDouble(this.paramRow.rowIndex[this.getParameterNumber(parameterName)]);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.outputParameterList.getByteArray(this.paramRow.rowIndex[this.getParameterNumber(parameterName)]);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.outputParameterList.getDate(this.paramRow.rowIndex[this.getParameterNumber(parameterName)]);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.outputParameterList.getTime(this.paramRow.rowIndex[this.getParameterNumber(parameterName)]);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.outputParameterList.getTimestamp(this.paramRow.rowIndex[this.getParameterNumber(parameterName)]);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        int index = this.getParameterNumber(parameterName);
        Object obj = null;
        int offset = this.paramRow.rowIndex[index];
        Descriptor desc = (Descriptor)this.parameters.get(index);
        switch (desc.type) {
            case 12: {
                obj = this.outputParameterList.getString(offset);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                obj = this.outputParameterList.getInt(offset);
                break;
            }
            case 8: {
                obj = this.outputParameterList.getDouble(offset);
                break;
            }
            case 2: {
                obj = this.outputParameterList.getBigDecimal(offset, desc.scale);
                break;
            }
            case -7: {
                obj = this.outputParameterList.getBoolean(offset);
                break;
            }
            case 91: {
                obj = this.outputParameterList.getDate(offset);
                break;
            }
            case 92: {
                obj = this.outputParameterList.getTime(offset);
                break;
            }
            case 93: {
                obj = this.outputParameterList.getTimestamp(offset);
                break;
            }
            case -3: 
            case -2: {
                obj = this.outputParameterList.getByteArray(offset);
                break;
            }
            case -5: {
                obj = this.outputParameterList.getLong(offset);
                break;
            }
            case -1: {
                obj = this.getCharacterStream(offset);
                break;
            }
            case -51: {
                obj = this.getResultSet(this.outputParameterList.getString(offset));
                break;
            }
            case 2002: {
                obj = this.fetchStruct(this.outputParameterList.getString(offset));
                break;
            }
            default: {
                obj = this.outputParameterList.getString(offset);
            }
        }
        if (this.outputParameterList.isNull()) {
            return null;
        }
        return obj;
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        int index = this.getParameterNumber(parameterName);
        int scale = ((CacheStatement.Parameter)this.parameters.get((int)index)).scale;
        return this.outputParameterList.getBigDecimal(this.paramRow.rowIndex[index], scale);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.outputParameterList.getDate(this.paramRow.rowIndex[this.getParameterNumber(parameterName)], cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.outputParameterList.getTime(this.paramRow.rowIndex[this.getParameterNumber(parameterName)], cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.outputParameterList.getTimestamp(this.paramRow.rowIndex[this.getParameterNumber(parameterName)], cal);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        int index = this.getParameterNumber(parameterName);
        if (((CacheStatement.Parameter)this.parameters.get((int)index)).type != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        String str = this.outputParameterList.getString(this.paramRow.rowIndex[index]);
        if (str == null) {
            return null;
        }
        CacheBlob blob = new CacheBlob(this.connection, str.getBytes(), this.serverCursorNumber);
        if (blob.isNull()) {
            return null;
        }
        return blob;
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        int index = this.getParameterNumber(parameterName);
        if (((CacheStatement.Parameter)this.parameters.get((int)index)).type != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        String str = this.outputParameterList.getString(this.paramRow.rowIndex[index]);
        if (str == null) {
            return null;
        }
        CacheClob clob = new CacheClob(this.connection, str.getBytes(), this.serverCursorNumber);
        if (clob.isNull()) {
            return null;
        }
        return clob;
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public URL getURL(int i) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public synchronized InputStream getBinaryStream(int i) throws SQLException {
        CacheInputStream stream;
        if (this.execParams != null) {
            return this.getBinaryStream(this.getExecParam((int)i).name);
        }
        String str = this.outputParameterList.getString(this.getListPosition(i));
        if (str == null) {
            return null;
        }
        int type = this.getParameterTypeAbsolute(i);
        switch (type) {
            case -4: 
            case -1: {
                stream = new CacheInputStream(this.connection, str.getBytes(), this.serverCursorNumber, 1);
                break;
            }
            case -3: {
                stream = new CacheInputStream(this.getBytes(i), 1, type, this.getMaxFieldSize());
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
            }
        }
        if (stream.isNull()) {
            return null;
        }
        return stream;
    }

    public synchronized InputStream getBinaryStream(String parameterName) throws SQLException {
        CacheInputStream stream;
        int index = this.getParameterNumber(parameterName);
        String str = this.outputParameterList.getString(this.paramRow.rowIndex[index]);
        if (str == null) {
            return null;
        }
        int type = ((CacheStatement.Parameter)this.parameters.get((int)index)).type;
        switch (type) {
            case -4: 
            case -1: {
                stream = new CacheInputStream(this.connection, str.getBytes(), this.serverCursorNumber, 1);
                break;
            }
            case -3: {
                stream = new CacheInputStream(this.getBytes(parameterName), 1, type, this.getMaxFieldSize());
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
            }
        }
        if (stream.isNull()) {
            return null;
        }
        return stream;
    }

    @Override
    public synchronized Reader getCharacterStream(int i) throws SQLException {
        CacheReader reader;
        if (this.execParams != null) {
            return this.getCharacterStream(this.getExecParam((int)i).name);
        }
        String str = this.outputParameterList.getString(this.getListPosition(i));
        if (str == null) {
            return null;
        }
        switch (this.getParameterTypeAbsolute(i)) {
            case -4: 
            case -1: {
                reader = new CacheReader(this.connection, str.getBytes(), this.serverCursorNumber);
                break;
            }
            case -3: 
            case 12: {
                reader = new CacheReader(str);
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
            }
        }
        if (reader.isNull()) {
            return null;
        }
        return reader;
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        if (reader == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.getParameterNumber(parameterName);
        if (((CacheStatement.Parameter)this.parameters.get((int)index)).type != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream x, long length) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.getParameterNumber(parameterName);
        if (((CacheStatement.Parameter)this.parameters.get((int)index)).type != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setBinaryStream(parameterName, x, length);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        CacheReader reader;
        int index = this.getParameterNumber(parameterName);
        String str = this.outputParameterList.getString(this.paramRow.rowIndex[index]);
        if (str == null) {
            return null;
        }
        switch (((CacheStatement.Parameter)this.parameters.get((int)index)).type) {
            case -4: 
            case -1: {
                reader = new CacheReader(this.connection, str.getBytes(), this.serverCursorNumber);
                break;
            }
            case -3: 
            case 12: {
                reader = new CacheReader(str);
                break;
            }
            default: {
                throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
            }
        }
        if (reader.isNull()) {
            return null;
        }
        return reader;
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.getParameterNumber(parameterName);
        if (((CacheStatement.Parameter)this.parameters.get((int)index)).type != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setBinaryStream(parameterName, x.getBinaryStream(), (int)x.length());
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.getParameterNumber(parameterName);
        if (((CacheStatement.Parameter)this.parameters.get((int)index)).type != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setCharacterStream(parameterName, x.getCharacterStream(), (int)x.length());
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            int available = 0;
            try {
                available = x.available();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (available == 0 || available > Integer.MAX_VALUE) {
                throw new SQLException("Stream too long: " + length);
            }
            length = available;
        }
        this.setAsciiStream(parameterName, x, (int)length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            int available = 0;
            try {
                available = x.available();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (available == 0 || available > Integer.MAX_VALUE) {
                throw new SQLException("Stream too long: " + length);
            }
            length = available;
        }
        this.setBinaryStream(parameterName, x, (int)length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new SQLException("Stream too long: " + length);
        }
        this.setCharacterStream(parameterName, reader, (int)length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        if (x.markSupported()) {
            x.mark(0);
        }
        this.setNamedGeneric(parameterName, new CacheStatement.StreamWrapper(x, 0, -1), null);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        if (x == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.getParameterNumber(parameterName);
        if (((CacheStatement.Parameter)this.parameters.get((int)index)).type == -1) {
            throw new SQLException("Unsupported type conversion: (binary) InputStream to java.sql.Types.LONGVARCHAR.", "S1000");
        }
        if (x.markSupported()) {
            x.mark(0);
        }
        this.setNamedGeneric(parameterName, new CacheStatement.StreamWrapper(x, 1, -1), null);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        this.setNamedGeneric(parameterName, new CacheStatement.StreamWrapper(reader, 4, -1), null);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.getParameterNumber(parameterName);
        if (((CacheStatement.Parameter)this.parameters.get((int)index)).type != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setCharacterStream(parameterName, reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNamedGeneric(parameterName, null, null);
            return;
        }
        int index = this.getParameterNumber(parameterName);
        if (((CacheStatement.Parameter)this.parameters.get((int)index)).type != -4) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        this.setBinaryStream(parameterName, inputStream);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.makeSureUnicodeServer();
        this.setString(parameterName, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.makeSureUnicodeServer();
        this.setCharacterStream(parameterName, value, length);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        this.makeSureUnicodeServer();
        return this.getString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        this.makeSureUnicodeServer();
        return this.getString(parameterName);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        this.makeSureUnicodeServer();
        return this.getCharacterStream(parameterIndex);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.makeSureUnicodeServer();
        this.setCharacterStream(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.makeSureUnicodeServer();
        this.setClob(parameterName, reader, length);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        this.makeSureUnicodeServer();
        return this.getCharacterStream(parameterName);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.makeSureUnicodeServer();
        this.setClob(parameterName, reader);
    }

    public void makeSureUnicodeServer() throws SQLException {
        if (!this.connection.connectionInfo.isUnicodeServer) {
            throw new SQLException("Not connected to Unicode server.");
        }
    }

    @Override
    public RowId getRowId(int index) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.makeSureUnicodeServer();
        this.setClob(parameterName, (Clob)value);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        this.makeSureUnicodeServer();
        if (this.execParams != null) {
            return this.getNClob(this.getExecParam((int)parameterIndex).name);
        }
        if (this.getParameterTypeAbsolute(parameterIndex) != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        String str = this.outputParameterList.getString(this.getListPosition(parameterIndex));
        if (str == null) {
            return null;
        }
        CacheNClob nClob = new CacheNClob(this.connection, str.getBytes(), this.serverCursorNumber);
        if (nClob.isNull()) {
            return null;
        }
        return nClob;
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        this.makeSureUnicodeServer();
        int index = this.getParameterNumber(parameterName);
        if (((CacheStatement.Parameter)this.parameters.get((int)index)).type != -1) {
            throw new SQLException("Restricted data type attribute violation.", "07006", 7006);
        }
        String str = this.outputParameterList.getString(this.paramRow.rowIndex[index]);
        if (str == null) {
            return null;
        }
        CacheNClob nClob = new CacheNClob(this.connection, str.getBytes(), this.serverCursorNumber);
        if (nClob.isNull()) {
            return null;
        }
        return nClob;
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

