/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.ApiType;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.ISessionContainer;
import com.azure.cosmos.implementation.QueryCompatibilityMode;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.RxGatewayStoreModel;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConstants;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdFramer;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequest;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdResponse;
import com.azure.cosmos.implementation.http.HttpClient;
import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.implementation.http.HttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ThinClientStoreModel
extends RxGatewayStoreModel {
    private String globalDatabaseAccountName = null;
    private final Map<String, String> defaultHeaders;

    public ThinClientStoreModel(DiagnosticsClientContext clientContext, ISessionContainer sessionContainer, ConsistencyLevel defaultConsistencyLevel, UserAgentContainer userAgentContainer, GlobalEndpointManager globalEndpointManager, HttpClient httpClient) {
        super(clientContext, sessionContainer, defaultConsistencyLevel, QueryCompatibilityMode.Default, userAgentContainer, globalEndpointManager, httpClient, ApiType.SQL);
        String userAgent = userAgentContainer != null ? userAgentContainer.getUserAgent() : UserAgentContainer.BASE_USER_AGENT_STRING;
        this.defaultHeaders = Collections.singletonMap("User-Agent", userAgent);
    }

    @Override
    public Mono<RxDocumentServiceResponse> processMessage(RxDocumentServiceRequest request) {
        return super.processMessage(request);
    }

    @Override
    protected Map<String, String> getDefaultHeaders(ApiType apiType, UserAgentContainer userAgentContainer) {
        return this.defaultHeaders;
    }

    @Override
    public URI getRootUri(RxDocumentServiceRequest request) {
        return this.globalEndpointManager.resolveServiceEndpoint(request).getThinclientRegionalEndpoint();
    }

    @Override
    public StoreResponse unwrapToStoreResponse(RxDocumentServiceRequest request, int statusCode, HttpHeaders headers, ByteBuf content) {
        if (content == null || content.readableBytes() == 0) {
            return super.unwrapToStoreResponse(request, statusCode, headers, Unpooled.EMPTY_BUFFER);
        }
        if (RntbdFramer.canDecodeHead(content)) {
            RntbdResponse response = RntbdResponse.decode(content);
            if (response != null) {
                return super.unwrapToStoreResponse(request, response.getStatus().code(), new HttpHeaders(response.getHeaders().asMap(request.getActivityId())), response.getContent());
            }
            return super.unwrapToStoreResponse(request, statusCode, headers, null);
        }
        throw new IllegalStateException("Invalid rntbd response");
    }

    @Override
    public HttpRequest wrapInHttpRequest(RxDocumentServiceRequest request, URI requestUri) throws Exception {
        if (this.globalDatabaseAccountName == null) {
            this.globalDatabaseAccountName = this.globalEndpointManager.getLatestDatabaseAccount().getId();
        }
        request.setThinclientHeaders(request.getOperationType().name(), request.getResourceType().name(), this.globalDatabaseAccountName, request.getResourceId());
        byte[] epk = request.getPartitionKeyInternal().getEffectivePartitionKeyBytes(request.getPartitionKeyInternal(), request.getPartitionKeyDefinition());
        RntbdRequestArgs rntbdRequestArgs = new RntbdRequestArgs(request);
        HttpHeaders headers = this.getHttpHeaders();
        headers.set("x-ms-activity-id", request.getActivityId().toString());
        RntbdRequest rntbdRequest = RntbdRequest.from(rntbdRequestArgs);
        rntbdRequest.setHeaderValue(RntbdConstants.RntbdRequestHeader.EffectivePartitionKey, epk);
        ByteBuf byteBuf = Unpooled.buffer();
        rntbdRequest.encode(byteBuf, true);
        byte[] contentAsByteArray = new byte[byteBuf.writerIndex()];
        byteBuf.getBytes(0, contentAsByteArray, 0, byteBuf.writerIndex());
        return new HttpRequest(HttpMethod.POST, requestUri, requestUri.getPort(), headers, (Flux<byte[]>)Flux.just((Object)contentAsByteArray));
    }

    @Override
    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        Map<String, String> defaultHeaders = this.getDefaultHeaders();
        for (Map.Entry<String, String> header : defaultHeaders.entrySet()) {
            httpHeaders.set(header.getKey(), header.getValue());
        }
        return httpHeaders;
    }
}

