/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.ui;

import com.dbeaver.ee.mockdata.engine.model.tasks.EntityProperties;
import com.dbeaver.ee.mockdata.engine.model.tasks.MockDataSettings;
import com.dbeaver.ee.mockdata.ui.MockDataExecuteWizard;
import com.dbeaver.ee.mockdata.ui.internal.MockDataUIMessages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigPanel;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigPanelProvider;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.UIWidgets;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.dialogs.ObjectBrowserDialog;
import org.jkiss.utils.CommonUtils;

public class MockDataTaskConfigurator
implements DBTTaskConfigurator,
DBTTaskConfigPanelProvider {
    public MockDataExecuteWizard createTaskConfigWizard(@NotNull DBTTask taskConfiguration) {
        return new MockDataExecuteWizard(taskConfiguration);
    }

    public MockDataTaskConfigPanel createInputConfigurator(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTaskType taskType) {
        return new MockDataTaskConfigPanel();
    }

    public static class MockDataTaskConfigPanel
    implements DBTTaskConfigPanel {
        private final DBPProject currentProject = NavigatorUtils.getSelectedProject();
        private MockDataExecuteWizard sqlWizard;
        private Table objectsTable;
        Button removeButton;

        @Nullable
        public DBPDataSource getLastDataSource() {
            int itemCount = this.objectsTable.getItemCount();
            if (itemCount <= 0) {
                return null;
            }
            DBSObject databaseObject = (DBSObject)this.objectsTable.getItem(itemCount - 1).getData();
            return databaseObject == null ? null : databaseObject.getDataSource();
        }

        private void updateSettings(@NotNull Runnable propertyChangeListener) {
            this.saveSettings();
            propertyChangeListener.run();
            UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.objectsTable, (boolean)true));
        }

        private void addObjectToTable(@NotNull DBSObject object) {
            TableItem item = new TableItem(this.objectsTable, 0);
            item.setData((Object)object);
            item.setImage(0, DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)object)));
            item.setText(0, CommonUtils.getSingleLineString((String)CommonUtils.toString((Object)object.toString(), (String)"?")));
            item.setText(1, object.getDataSource().getContainer().getName());
            item.setImage(1, DBeaverIcons.getImage((DBPImage)object.getDataSource().getContainer().getDriver().getIcon()));
        }

        /*
         * WARNING - void declaration
         */
        public void createControl(@NotNull Composite parent, @NotNull TaskConfigurationWizard wizard, @NotNull Runnable propertyChangeListener) {
            void mockDataExecuteWizard;
            if (!(wizard instanceof MockDataExecuteWizard)) {
                return;
            }
            MockDataExecuteWizard mockDataExecuteWizard2 = (MockDataExecuteWizard)wizard;
            this.sqlWizard = mockDataExecuteWizard;
            Group group = UIUtils.createControlGroup((Composite)parent, (String)MockDataUIMessages.tools_mockdata_wizard_page_task_tables_group_label, (int)1, (int)1808, (int)0);
            this.objectsTable = new Table((Composite)group, 67588);
            this.objectsTable.setLayoutData((Object)new GridData(1808));
            this.objectsTable.setHeaderVisible(true);
            UIUtils.createTableColumn((Table)this.objectsTable, (int)0, (String)MockDataUIMessages.tools_mockdata_wizard_page_task_tables_object_column_label);
            UIUtils.createTableColumn((Table)this.objectsTable, (int)0, (String)MockDataUIMessages.tools_mockdata_wizard_page_task_tables_datasource_column_label);
            UIWidgets.createTableContextMenu((Table)this.objectsTable, null);
            Composite buttonsPanel = UIUtils.createComposite((Composite)group, (int)2);
            UIUtils.createDialogButton((Composite)buttonsPanel, (String)MockDataUIMessages.tools_mockdata_wizard_page_task_add_table_button_label, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
                List tables;
                DBPDataSource lastDataSource;
                Class<DBSDataManipulator> tableClass = DBSDataManipulator.class;
                DBNProjectDatabases rootNode = this.currentProject.getNavigatorModel().getRoot().getProjectNode(this.currentProject).getDatabases();
                DBNDataSource selNode = null;
                if (this.objectsTable.getItemCount() > 0 && (lastDataSource = this.getLastDataSource()) != null) {
                    selNode = rootNode.getDataSource(lastDataSource.getContainer().getId());
                }
                if ((tables = ObjectBrowserDialog.selectObjects((Shell)group.getShell(), (String)MockDataUIMessages.tools_mockdata_wizard_page_task_add_tables_title, (DBNNode)rootNode, (List)CommonUtils.singletonOrEmpty(selNode), (Class[])new Class[]{DBSInstance.class, DBSObjectContainer.class, tableClass}, (Class[])new Class[]{tableClass}, null)) != null) {
                    for (DBNNode node : tables) {
                        if (!(node instanceof DBNDatabaseNode)) continue;
                        DBSObject object = ((DBNDatabaseNode)node).getObject();
                        this.addObjectToTable(object);
                    }
                    this.updateSettings(propertyChangeListener);
                }
            }));
            this.removeButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)MockDataUIMessages.tools_mockdata_wizard_page_task_remove_table_button_label, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
                DBSObject object = (DBSObject)this.objectsTable.getItem(this.objectsTable.getSelectionIndex()).getData();
                if (UIUtils.confirmAction((String)MockDataUIMessages.tools_mockdata_wizard_page_task_remove_tables_title, (String)NLS.bind((String)MockDataUIMessages.tools_mockdata_wizard_page_task_remove_tables_message, (Object)CommonUtils.truncateString((String)object.getName(), (int)255)))) {
                    this.objectsTable.remove(this.objectsTable.getSelectionIndex());
                    this.updateSettings(propertyChangeListener);
                    this.updateRemoveButton();
                }
            }));
            this.removeButton.setEnabled(false);
            this.objectsTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateRemoveButton()));
        }

        private void updateRemoveButton() {
            if (this.removeButton == null) {
                return;
            }
            int selectionIndex = this.objectsTable.getSelectionIndex();
            DBSObject object = selectionIndex >= 0 ? (DBSObject)this.objectsTable.getItem(selectionIndex).getData() : null;
            this.removeButton.setEnabled(object != null);
        }

        public void loadSettings() {
            MockDataSettings settings = this.sqlWizard.getSettings();
            for (EntityProperties object : settings.getEntityPropertiesList()) {
                this.addObjectToTable(object.getInputObject());
            }
            UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.objectsTable, (boolean)true));
        }

        public void saveSettings() {
            if (this.objectsTable == null) {
                return;
            }
            MockDataSettings settings = this.sqlWizard.getSettings();
            ArrayList<EntityProperties> entityPropertiesList = new ArrayList<EntityProperties>();
            TableItem[] tableItemArray = this.objectsTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                DBSObject object = (DBSObject)item.getData();
                if (object != null) {
                    boolean found = false;
                    for (EntityProperties entityProperties : settings.getEntityPropertiesList()) {
                        if (!entityProperties.getInputObject().equals(object)) continue;
                        entityPropertiesList.add(entityProperties);
                        found = true;
                        break;
                    }
                    if (!found) {
                        EntityProperties entityProperties;
                        entityProperties = new EntityProperties(object);
                        entityPropertiesList.add(entityProperties);
                    }
                }
                ++n2;
            }
            settings.setEntityPropertiesList(entityPropertiesList);
        }

        public boolean isComplete() {
            if (this.objectsTable.getItemCount() == 0) {
                return false;
            }
            return this.objectsTable.getItemCount() > 0;
        }

        @Nullable
        public String getErrorMessage() {
            if (this.objectsTable.getItemCount() == 0) {
                return MockDataUIMessages.tools_mockdata_wizard_page_task_no_tables_selected_message;
            }
            return null;
        }
    }
}

