/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.ui;

import com.dbeaver.ee.mockdata.engine.model.tasks.MockDataSettings;
import com.dbeaver.ee.mockdata.ui.MockDataConfigurationWizardDialog;
import com.dbeaver.ee.mockdata.ui.MockDataExecuteWizard;
import com.dbeaver.ee.mockdata.ui.internal.MockDataUIMessages;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDocumentContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class MockDataGenerateToolCommandHandler
extends AbstractHandler {
    private List<DBSObject> selectedObjects;

    public MockDataGenerateToolCommandHandler() {
    }

    public MockDataGenerateToolCommandHandler(List<DBSObject> selectedObjects) {
        this.selectedObjects = selectedObjects;
    }

    public Object execute(ExecutionEvent event) {
        List selectedObjects = CommonUtils.isEmpty(this.selectedObjects) ? NavigatorUtils.getSelectedObjects((ISelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)) : this.selectedObjects;
        for (DBSObject dbsObject : selectedObjects) {
            DBPDataSource dataSource = dbsObject.getDataSource();
            if (dataSource != null && dataSource.getInfo().isReadOnlyData()) {
                UIUtils.showMessageBox((Shell)UIUtils.getActiveWorkbenchShell(), (String)"Read-only database", (String)("Database '" + dataSource.getContainer().getName() + "' is read-only.\nMock data generation is not possible."), (int)8);
                return null;
            }
            if (!((DBSDataContainer)dbsObject).isFeatureSupported("data.key.value") && !(dbsObject instanceof DBSDocumentContainer)) continue;
            DBWorkbench.getPlatformUI().showError(MockDataUIMessages.tools_mockdata_message_title, MockDataUIMessages.tools_mockdata_error_table_type_not_supported);
            return null;
        }
        MockDataSettings mockDataSettings = new MockDataSettings((Collection)selectedObjects);
        MockDataExecuteWizard wizard = new MockDataExecuteWizard(null, mockDataSettings);
        MockDataConfigurationWizardDialog dialog = new MockDataConfigurationWizardDialog(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), wizard, mockDataSettings);
        return dialog.open();
    }
}

