/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class RDMLogFormatter
extends Formatter {
    private int level = 0;

    @Override
    public String format(LogRecord rec) {
        Object[] parms = rec.getParameters();
        Throwable thrown = rec.getThrown();
        String msg = rec.getMessage();
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        buf.append("[" + dateFormat.format(date) + "] ");
        buf.append("(" + rec.getThreadID() + ") ");
        if (thrown != null || msg.startsWith("RETURN")) {
            --this.level;
        } else if (msg.startsWith("ENTRY")) {
            ++this.level;
        }
        for (int ii = 1; ii < this.level; ++ii) {
            buf.append(" ");
        }
        buf.append(rec.getSourceClassName() + " " + rec.getSourceMethodName() + " ");
        if (thrown != null) {
            buf.append(thrown.toString());
        } else {
            buf.append(MessageFormat.format(msg, parms));
        }
        buf.append("\n");
        return buf.toString();
    }
}

