/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.util;

import com.raima.rdm.util.BlobCacheFile;
import java.io.IOException;
import java.util.LinkedHashMap;

public class BlobCache {
    int maxentries;
    BlobCacheFile file;
    LinkedHashMap<Long, byte[]> hash;

    public BlobCache(int pagesize) throws IOException {
        this._init(pagesize, 16);
    }

    public BlobCache(int pagesize, int maxentries) throws IOException {
        this._init(pagesize, maxentries);
    }

    private void _init(int pagesize, int maxentries) throws IOException {
        if (maxentries < 1) {
            throw new IOException();
        }
        this.maxentries = maxentries;
        this.file = new BlobCacheFile(pagesize);
        this.hash = new LinkedHashMap();
    }

    private void makeRoom() throws IOException {
        if (this.hash.size() == this.maxentries) {
            long pageno = this.hash.keySet().iterator().next();
            byte[] page = (byte[])this.hash.remove(pageno);
            this.file.write(pageno, page);
        }
    }

    private void cacheResult(long pageno, byte[] page) throws IOException {
        this.makeRoom();
        this.hash.put(pageno, page);
    }

    public void close() {
        this.file.close();
        this.file = null;
        this.hash = null;
    }

    public byte[] readPage(long pageno) throws IOException {
        byte[] result = this.hash.get(pageno);
        if (result != null) {
            this.hash.remove(pageno);
        } else {
            result = this.file.read(pageno);
        }
        this.cacheResult(pageno, result);
        return result;
    }

    public void writePage(long pageno, byte[] data) throws IOException {
        if (this.hash.get(pageno) != null) {
            this.hash.remove(pageno);
        }
        this.cacheResult(pageno, data);
    }

    public void truncate(long pageno) throws IOException {
        this.file.truncate(pageno);
        for (long pno : this.hash.keySet()) {
            if (pno < pageno) continue;
            this.hash.remove(pno);
        }
    }

    public boolean exists(long pageno) {
        if (this.hash.containsKey(pageno)) {
            return true;
        }
        return this.file.exists(pageno);
    }
}

