/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.DateTimeConverter;
import com.raima.rdm.sql.RSQLParam;
import com.raima.rdm.util.BinaryConverter;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RPC;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;

public class RSQLStringParam
extends RSQLParam {
    String str;

    public RSQLStringParam() {
        super(8, (short)2);
    }

    public RSQLStringParam(String str) {
        super(8);
        this.str = str;
    }

    public RSQLStringParam(short t, String str) {
        super(8, t);
        this.str = str;
    }

    @Override
    public String getString() throws RDMException {
        return this.str;
    }

    @Override
    public byte[] getBytes() throws RDMException {
        return BinaryConverter.convertFromString(this.str);
    }

    @Override
    public boolean getBoolean() throws RDMException {
        return Boolean.valueOf(this.str);
    }

    @Override
    public byte getByte() throws RDMException {
        return Byte.valueOf(this.str);
    }

    @Override
    public short getShort() throws RDMException {
        return Short.valueOf(this.str);
    }

    @Override
    public int getInt() throws RDMException {
        return Integer.valueOf(this.str);
    }

    @Override
    public long getLong() throws RDMException {
        return Long.valueOf(this.str);
    }

    @Override
    public float getFloat() throws RDMException {
        return Float.valueOf(this.str).floatValue();
    }

    @Override
    public double getDouble() throws RDMException {
        return Double.valueOf(this.str);
    }

    @Override
    public int getDate() throws RDMException {
        return DateTimeConverter.RDateFromDate(Date.valueOf(this.str));
    }

    @Override
    public int getTime() throws RDMException {
        return DateTimeConverter.RTimeFromTime(Time.valueOf(this.str));
    }

    @Override
    public int[] getTimestamp() throws RDMException {
        return DateTimeConverter.RTimestampFromTimestamp(Timestamp.valueOf(this.str));
    }

    @Override
    public BigDecimal getDecimal() throws RDMException {
        return new BigDecimal(this.str);
    }

    @Override
    public UUID getGuid() throws RDMException {
        return UUID.fromString(this.str);
    }

    @Override
    public void setString(String str) throws RDMException {
        this.str = str;
    }

    @Override
    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(8);
        rpc.sendString(this.str);
    }

    @Override
    public void set(RPC rpc) throws IOException {
        this.str = rpc.getString();
    }
}

