/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.jdbc.RDMJDBCURL;
import com.raima.rdm.sql.RDMSQLException;
import com.raima.rdm.sql.RSQL;
import com.raima.rdm.sql.RSQLError;
import com.raima.rdm.sql.RSQLJNIStatement;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.util.JDBCURL;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMVersion;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.Manifest;

public class RSQLJNI
implements RSQL {
    long tfs_handle;
    long handle;
    short transStatus;
    SQLWarning warnings;
    String SQLState;
    String errMsg;
    int errorCode;
    String errorInfoMsg;
    static boolean loadedDLL = false;

    private native int rdmAllocTFS(String var1);

    private native int rdmAllocConn();

    private native int rdmSqlConnect(long var1, String var3);

    private native int rdmSqlDisconnect(long var1);

    private native int rdmSqlFree(long var1);

    private native int rdmSqlGetLastError(long var1);

    private native int rdmGetErrorMsg(int var1);

    private native int rdmSqlSetOptions(long var1, String var3);

    private native int rdmSqlSetOption(long var1, String var3, String var4);

    private native int rdmSqlEnd(long var1);

    private native int rdmSqlEndRollback(long var1);

    private native int rdmSqlSavepoint(long var1, String var3);

    private native int rdmSqlRollbackToSavepoint(long var1, String var3);

    private native int rdmSqlRelease(long var1, String var3);

    private native int rdmSqlTransStatus(long var1);

    private native int tfsAllocSql();

    private native int tfsFree(long var1);

    private native int setTmpPath(String var1);

    private static Manifest findManifest() {
        Manifest mf = null;
        try {
            Enumeration<URL> resources = RSQLJNI.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL manifest_url = resources.nextElement();
                if (!manifest_url.getPath().contains("rdmjdbc")) continue;
                mf = new Manifest(manifest_url.openStream());
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mf;
    }

    private static String getJNILibraryPath() {
        Manifest mf = RSQLJNI.findManifest();
        String libraryPath = null;
        if (mf != null) {
            libraryPath = mf.getMainAttributes().getValue("Jni-Path");
        }
        return libraryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSQLJNI(RDMJDBCURL url) throws RDMException {
        block23: {
            try {
                String options;
                int ret;
                String docroot = url.getDocroot();
                String tfstype = url.getTfsType();
                if (this.isAndroid()) {
                    docroot = this.androidInit(url, docroot);
                }
                if (docroot == null || docroot.isEmpty()) {
                    docroot = System.getProperty("user.dir");
                }
                if (tfstype == null || tfstype.isEmpty()) {
                    tfstype = "default";
                }
                if ((ret = this.rdmAllocTFS(options = String.format("docroot=%s;tfstype=%s", docroot, tfstype))) != 0) {
                    throw new RDMSQLException(ret);
                }
                this.warnings = null;
                RSQLJNI rSQLJNI = this;
                synchronized (rSQLJNI) {
                    this.tfsAllocSql();
                }
                if (ret != 0) {
                    throw new RDMSQLException(ret);
                }
                rSQLJNI = this;
                synchronized (rSQLJNI) {
                    ret = this.rdmSqlSetOption(this.handle, "defaultOpenMode", url.getOpenMode());
                }
                if (ret != 0) {
                    rSQLJNI = this;
                    synchronized (rSQLJNI) {
                        this.rdmSqlFree(this.handle);
                    }
                    this.tfsFree(this.tfs_handle);
                    this.handle = -1L;
                    throw new RDMSQLException(this, "rdmSqlSetOption('defaultOpenMode')");
                }
                LinkedList<String> dblist = url.getDbList();
                String dbnamelist = dblist.size() > 0 ? this.createDbNameList(dblist) : "";
                RSQLJNI rSQLJNI2 = this;
                synchronized (rSQLJNI2) {
                    ret = this.rdmSqlConnect(this.handle, dbnamelist);
                }
                if (ret == 0) break block23;
                rSQLJNI2 = this;
                synchronized (rSQLJNI2) {
                    this.rdmSqlFree(this.handle);
                }
                this.tfsFree(this.tfs_handle);
                this.handle = -1L;
                throw new RDMSQLException(this, "rdmSqlConnect()");
            }
            catch (Error e) {
                throw this.handleJNIError(e);
            }
        }
    }

    private boolean isAndroid() {
        return System.getProperty("java.runtime.name").equals("Android Runtime");
    }

    private String androidInit(JDBCURL url, String docroot) {
        String appname = url.getAppName();
        if (appname != null && appname != "") {
            String app = "/data/data/" + appname + "/files";
            String tmp = app + "/tmp";
            new File(tmp).mkdirs();
            this.setTmpPath(tmp);
            if (docroot == null) {
                docroot = app + "/docroot";
            }
        } else if (docroot == null) {
            docroot = "/sdcard/raima/docroot";
        }
        new File(docroot).mkdirs();
        return docroot;
    }

    private String createDbNameList(LinkedList<String> dblist) {
        boolean first = true;
        StringBuilder str = new StringBuilder();
        Iterator iter = dblist.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                str.append(";");
            }
            str.append((String)iter.next());
        }
        return str.toString();
    }

    public void setConnHandle(long conn_handle) {
        this.handle = conn_handle;
    }

    public void setTFSHandle(long tfs_handle) {
        this.tfs_handle = tfs_handle;
    }

    public long getTFSHandle() {
        return this.tfs_handle;
    }

    public long getConnHandle() {
        return this.handle;
    }

    public void setTransStatus(short transStatus) {
        this.transStatus = transStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws RDMException {
        block5: {
            try {
                if (this.handle == -1L) break block5;
                RSQLJNI rSQLJNI = this;
                synchronized (rSQLJNI) {
                    this.rdmSqlDisconnect(this.handle);
                    this.rdmSqlFree(this.handle);
                }
                this.tfsFree(this.tfs_handle);
                this.handle = -1L;
            }
            catch (Error e) {
                throw this.handleJNIError(e);
            }
        }
    }

    @Override
    public RSQLStatement createStatement(boolean cursorScrollable, boolean cursorUpdateable) throws RDMException {
        return new RSQLJNIStatement(this, cursorScrollable, cursorUpdateable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOptions(String options) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQLJNI rSQLJNI = this;
            synchronized (rSQLJNI) {
                ret = this.rdmSqlSetOptions(this.handle, options);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmSqlSetOptions()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOption(String keyword, String option) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQLJNI rSQLJNI = this;
            synchronized (rSQLJNI) {
                ret = this.rdmSqlSetOption(this.handle, keyword, option);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmSqlSetOption()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOption(String keyword, boolean option) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQLJNI rSQLJNI = this;
            synchronized (rSQLJNI) {
                String strValue = option ? "true" : "false";
                ret = this.rdmSqlSetOption(this.handle, keyword, strValue);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmSqlSetOption()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOption(String keyword, int option) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQLJNI rSQLJNI = this;
            synchronized (rSQLJNI) {
                String strValue = String.format("%d", option);
                ret = this.rdmSqlSetOption(this.handle, keyword, strValue);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmSqlSetOption()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean transStatus() throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQLJNI rSQLJNI = this;
            synchronized (rSQLJNI) {
                ret = this.rdmSqlTransStatus(this.handle);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmSqlTransStatus()");
            }
            return this.transStatus != 0;
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQLJNI rSQLJNI = this;
            synchronized (rSQLJNI) {
                ret = this.rdmSqlEnd(this.handle);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmSqlEnd()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQLJNI rSQLJNI = this;
            synchronized (rSQLJNI) {
                ret = this.rdmSqlEndRollback(this.handle);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmSqlEndRollback()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSavepoint(String id) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQLJNI rSQLJNI = this;
            synchronized (rSQLJNI) {
                ret = this.rdmSqlSavepoint(this.handle, id);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmSqlSavepoint()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackToSavepoint(String id) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQLJNI rSQLJNI = this;
            synchronized (rSQLJNI) {
                ret = this.rdmSqlRollbackToSavepoint(this.handle, id);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmSqlRollbackToSavepoint()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(String id) throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQLJNI rSQLJNI = this;
            synchronized (rSQLJNI) {
                ret = this.rdmSqlRelease(this.handle, id);
            }
            if (ret != 0) {
                throw new RDMSQLException(this, "rdmSqlRelease()");
            }
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    @Override
    public RSQLError getErrorMsg(int err) throws RDMException {
        try {
            if (this.rdmGetErrorMsg(err) != 0) {
                return null;
            }
            return new RSQLError("", this.SQLState, this.errMsg);
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLastError() throws RDMException {
        try {
            int ret;
            if (this.handle == -1L) {
                throw new RDMSQLException();
            }
            RSQLJNI rSQLJNI = this;
            synchronized (rSQLJNI) {
                ret = this.rdmSqlGetLastError(this.handle);
            }
            if (ret != 0 && ret != 10012) {
                throw new RDMSQLException(ret);
            }
            return this.errorCode;
        }
        catch (Error e) {
            throw this.handleJNIError(e);
        }
    }

    protected void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public int getErrorCode() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return this.errorCode;
    }

    @Override
    public String getErrorInfoMsg() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return this.errorInfoMsg;
    }

    protected void setSQLState(String SQLState) {
        this.SQLState = SQLState;
    }

    protected void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    protected void setErrorInfoMsg(String errorInfoMsg) {
        this.errorInfoMsg = errorInfoMsg;
    }

    private RDMException handleJNIError(Error e) {
        e.printStackTrace(System.err);
        return new RDMSQLException();
    }

    @Override
    public void clearWarnings() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        this.warnings = null;
    }

    @Override
    public SQLWarning getWarnings() throws RDMException {
        if (this.handle == -1L) {
            throw new RDMSQLException();
        }
        return this.warnings;
    }

    static {
        if (!loadedDLL) {
            ArrayList<String> libList = new ArrayList<String>();
            String verstr = "" + RDMVersion.getMajorVersion();
            if (System.getProperty("java.runtime.name").equals("Android Runtime")) {
                libList.add("rdmpsp-" + verstr);
                libList.add("rdmenc-" + verstr);
                libList.add("rdmtransport-" + verstr);
                libList.add("rdmbase-" + verstr);
                libList.add("rdmha-" + verstr);
                libList.add("rdmhttp-" + verstr);
                libList.add("rdmtfs-" + verstr);
                libList.add("rdmddl-" + verstr);
                libList.add("rdmrdm-" + verstr);
                libList.add("rdmsbase-" + verstr);
                libList.add("rdmxml-" + verstr);
                libList.add("rdmrsql-" + verstr);
            }
            libList.add("rdmjdbcjni-" + verstr);
            try {
                String libraryPath = RSQLJNI.getJNILibraryPath();
                for (String name : libList) {
                    if (libraryPath != null && !libraryPath.isEmpty()) {
                        String nativeName = System.mapLibraryName(name);
                        name = libraryPath.charAt(libraryPath.length() - 1) != File.separatorChar ? libraryPath + File.separatorChar + nativeName : libraryPath + nativeName;
                        System.load(name);
                        continue;
                    }
                    System.loadLibrary(name);
                }
                loadedDLL = true;
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println(e.getMessage());
                System.err.println("The following shared libraries must be available to load:");
                for (String name : libList) {
                    System.err.println("  " + name);
                }
                throw e;
            }
        }
    }
}

