/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.RSQLParam;
import com.raima.rdm.util.BinaryConverter;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RPC;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;

public class RSQLFloatParam
extends RSQLParam {
    float f;

    public RSQLFloatParam() {
        super(515, (short)3);
    }

    public RSQLFloatParam(float f) {
        super(515);
        this.f = f;
    }

    public RSQLFloatParam(short t, float f) {
        super(515, t);
        this.f = f;
    }

    @Override
    public String getString() throws RDMException {
        return Float.toString(this.f);
    }

    @Override
    public byte[] getBytes() throws RDMException {
        return BinaryConverter.convertFromFloat(this.f);
    }

    @Override
    public boolean getBoolean() throws RDMException {
        return (double)this.f != 0.0;
    }

    @Override
    public byte getByte() throws RDMException {
        return (byte)this.f;
    }

    @Override
    public short getShort() throws RDMException {
        return (short)this.f;
    }

    @Override
    public int getInt() throws RDMException {
        return (int)this.f;
    }

    @Override
    public long getLong() throws RDMException {
        return (long)this.f;
    }

    @Override
    public float getFloat() throws RDMException {
        return this.f;
    }

    @Override
    public double getDouble() throws RDMException {
        return this.f;
    }

    @Override
    public BigDecimal getDecimal() throws RDMException {
        return new BigDecimal(this.f, new MathContext(32));
    }

    @Override
    public void setDouble(double d) throws RDMException {
        this.f = (float)d;
    }

    @Override
    public void setFloat(float f) throws RDMException {
        this.f = f;
    }

    @Override
    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(515);
        rpc.sendFloat(this.f);
    }

    @Override
    public void set(RPC rpc) throws IOException {
        this.f = rpc.getFloat();
    }
}

