/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.sql;

import com.raima.rdm.sql.CLOBInputStream;
import com.raima.rdm.sql.CLOBReader;
import com.raima.rdm.sql.RSQLColumn;
import com.raima.rdm.sql.RSQLRowSet;
import com.raima.rdm.util.BinaryConverter;
import com.raima.rdm.util.RDMException;
import com.raima.rdm.util.RDMInvalidColumnTypeException;
import com.raima.rdm.util.RDMUnexpectedException;
import com.raima.rdm.util.RPC;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.UUID;

public class RSQLClobColumn
implements RSQLColumn {
    RSQLRowSet rs;
    int colno;
    int max;

    public RSQLClobColumn(RSQLRowSet rowset, int col, int max) {
        this.rs = rowset;
        this.colno = col;
        this.max = max;
    }

    @Override
    public boolean isNull() throws RDMException {
        return false;
    }

    @Override
    public String getString() throws RDMException {
        StringBuilder str = new StringBuilder();
        Reader rdr = this.getCharacterStream();
        char[] tmp = new char[1024];
        try {
            int len;
            while ((len = rdr.read(tmp)) != -1) {
                if (len > 0 && tmp[len - 1] == '\u0000') {
                    --len;
                }
                str.append(tmp, 0, len);
            }
        }
        catch (IOException e) {
            throw new RDMUnexpectedException(e.getMessage());
        }
        return str.toString();
    }

    @Override
    public byte[] getBytes() throws RDMException {
        return BinaryConverter.convertFromString(this.getString());
    }

    @Override
    public boolean getBoolean() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public byte getByte() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public short getShort() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public int getInt() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public long getLong() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public float getFloat() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public double getDouble() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public BigDecimal getBigDecimal() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Date getDate() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Date getDate(Calendar cal) throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Time getTime() throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Time getTime(Calendar cal) throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public Timestamp getTimestamp() throws RDMException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws RDMException {
        throw new RDMInvalidColumnTypeException();
    }

    @Override
    public UUID getUUID() throws RDMException {
        return UUID.fromString(this.getString());
    }

    @Override
    public InputStream getAsciiStream() throws RDMException {
        return new CLOBInputStream(this.rs, this.colno, this.max);
    }

    @Override
    public InputStream getBinaryStream() throws RDMException {
        return new CLOBInputStream(this.rs, this.colno, this.max);
    }

    @Override
    public Reader getCharacterStream() throws RDMException {
        return new CLOBReader(this.rs, this.colno, this.max);
    }

    @Override
    public Object getObject() throws RDMException {
        return this.getString();
    }

    public void send(RPC rpc) throws IOException {
        rpc.sendInt32(4104);
    }
}

