/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMBlob;
import com.raima.rdm.jdbc.RDMClob;
import com.raima.rdm.jdbc.RDMNClob;
import com.raima.rdm.jdbc.RDMResultSetMetaData;
import com.raima.rdm.jdbc.RDMStatement;
import com.raima.rdm.sql.RSQLRowArray;
import com.raima.rdm.sql.RSQLRowSet;
import com.raima.rdm.sql.RSQLStatement;
import com.raima.rdm.util.RDMException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;

public class RDMResultSet
implements ResultSet {
    RDMResultSetMetaData meta;
    RDMStatement stmt;
    RSQLStatement sqlstmt;
    RSQLRowSet rowset = null;
    RSQLRowArray rowarray = null;
    SQLWarning warnings;
    int row = -1;
    int rows;
    int maxRows;
    int numcols;
    int offset;
    int fetchSize;
    int lastResultRow = -1;
    boolean done = false;
    boolean lastnull = false;
    boolean getKey = false;
    InputStream currentStream = null;
    Reader currentReader = null;
    boolean cursorBeforeFirst = true;
    boolean cursorAfterLast = false;
    private Logger logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    private static final String className = "RDMResultSet";
    private static final String invalidColumnType = "invalid column type";
    private static final String absolute_name = "absolute";
    private static final String afterLast_name = "afterLast";
    private static final String beforeFirst_name = "beforeFirst";
    private static final String cancelRowUpdates_name = "cancelRowUpdates";
    private static final String clearWarnings_name = "clearWarnings";
    private static final String close_name = "close";
    private static final String deleteRow_name = "deleteRow";
    private static final String findColumn_name = "findColumn";
    private static final String first_name = "first";
    private static final String getArray_name = "getArray";
    private static final String getAsciiStream_name = "getAsciiStream";
    private static final String getBigDecimal = "getBigDecimal";
    private static final String getBinaryStream_name = "getBinaryStream";
    private static final String getBlob_name = "getBlob";
    private static final String getBoolean_name = "getBoolean";
    private static final String getByte_name = "getByte";
    private static final String getBytes_name = "getBytes";
    private static final String getCharacterStream_name = "getChracterStream";
    private static final String getClob_name = "getClob";
    private static final String getConcurrency_name = "getConcurrency";
    private static final String getCursorName_name = "getCursorName";
    private static final String getDate_name = "getDate";
    private static final String getDouble_name = "getDouble";
    private static final String getFetchDirection_name = "getFetchDirection";
    private static final String getFetchSize_name = "getFetchSize";
    private static final String getFloat_name = "getFloat";
    private static final String getInt_name = "getInt";
    private static final String getLong_name = "getLong";
    private static final String getMetaData_name = "getMetaData";
    private static final String getNCharacterStream_name = "getNCharacterStream";
    private static final String getNClob_name = "getNClob";
    private static final String getNString_name = "getNString";
    private static final String getObject_name = "getObject";
    private static final String getRef_name = "getRef";
    private static final String getRow_name = "getRow";
    private static final String getRowId_name = "getRowId";
    private static final String getShort_name = "getShort";
    private static final String getSQLXML_name = "getSQLXML";
    private static final String getStatement_name = "getStatement";
    private static final String getString_name = "getString";
    private static final String getTime_name = "getTime";
    private static final String getTimestamp_name = "getTimestamp";
    private static final String getType_name = "getType";
    private static final String getUnicodeStream_name = "getUnicodeStream";
    private static final String getURL_name = "getURL";
    private static final String getWarnings_name = "getWarnings";
    private static final String insertRow_name = "insertRow";
    private static final String isAfterLast_name = "isAfterLast";
    private static final String isBeforeFirst_name = "isBeforeFirst";
    private static final String isFirst_name = "isFirst";
    private static final String isLast_name = "isLast";
    private static final String last_name = "last";
    private static final String moveToCurrentRow_name = "moveToCurrentRow";
    private static final String moveToInsertRow_name = "moveToInsertRow";
    private static final String next_name = "next";
    private static final String previous_name = "previous";
    private static final String refreshRow_name = "refreshRow";
    private static final String relative_name = "relative";
    private static final String rowDeleted_name = "rowDeleted";
    private static final String rowInserted_name = "rowInserted";
    private static final String rowUpdated_name = "rowUpdated";
    private static final String setFetchDirection_name = "setFetchDirection";
    private static final String setFetchSize_name = "setFetchSize";
    private static final String updateArray_name = "updateArray";
    private static final String updateAsciiStream_name = "updateAsciiStream";
    private static final String updateBigDecimal_name = "updateBigDecimal";
    private static final String updateBinaryStream_name = "updateBinaryStream";
    private static final String updateBlob_name = "updateBlob";
    private static final String updateBoolean_name = "updateBoolean";
    private static final String updateByte_name = "updateByte";
    private static final String updateBytes_name = "updateBytes";
    private static final String updateCharacterStream_name = "updateCharacterStream";
    private static final String updateClob_name = "updateClob";
    private static final String updateDate_name = "updateDate";
    private static final String updateDouble_name = "updateDouble";
    private static final String updateFloat_name = "updateFloat";
    private static final String updateInt_name = "updateInt";
    private static final String updateLong_name = "updateLong";
    private static final String updateNCharacterStream_name = "updateNCharacterStream";
    private static final String updateNClob_name = "updateNClob";
    private static final String updateNString_name = "updateNString";
    private static final String updateNull_name = "updateNull";
    private static final String updateObject_name = "updateObject";
    private static final String updateRef_name = "updateRef";
    private static final String updateRow_name = "updateRow";
    private static final String updateRowId_name = "updateRowId";
    private static final String updateShort_name = "updateShort";
    private static final String updateSQLXML_name = "updateSQLXML";
    private static final String updateString_name = "updateString";
    private static final String updateTime_name = "updateTime";
    private static final String updateTimestamp_name = "updateTimestamp";
    private static final String wasNull_name = "wasNull";

    protected RDMResultSet(RDMStatement stmt, int maxRows) throws SQLException {
        if (stmt == null) {
            throw new SQLException("Invalid RDMStatement");
        }
        this.stmt = stmt;
        this.sqlstmt = stmt.getSQLStatement();
        this.meta = new RDMResultSetMetaData(this.sqlstmt);
        this.row = -1;
        this.rows = 0;
        this.offset = 0;
        this.fetchSize = stmt.getFetchSize();
        this.numcols = this.sqlstmt.getNumCols();
        if (this.numcols == 0) {
            this.getKey = true;
            this.numcols = 1;
        }
        this.maxRows = maxRows;
    }

    protected RSQLRowSet getRowSet() {
        return this.rowset;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.logger.entering(className, absolute_name, row);
        this._validate(absolute_name);
        boolean flag = this.getKey ? this.absoluteKey(row) : this.absoluteRow(row);
        this.logger.exiting(className, last_name, flag);
        return flag;
    }

    private boolean absoluteKey(int row) throws SQLException {
        boolean ret;
        try {
            if (row == 0) {
                this.row = -1;
                ret = false;
            } else {
                int numKeys = this.sqlstmt.getNumGeneratedKeys();
                if (numKeys == 0) {
                    ret = false;
                } else {
                    int tempRow = row < 0 ? numKeys + row : row - 1;
                    if (tempRow < 0 || tempRow >= numKeys) {
                        ret = false;
                    } else {
                        ret = true;
                        this.row = tempRow;
                        this.rowset = this.sqlstmt.getGeneratedKey(this.row);
                    }
                }
            }
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return ret;
    }

    private boolean absoluteRow(int rowNumber) throws SQLException {
        SQLWarning warning;
        boolean flag = false;
        this.clearWarnings();
        this.closeCurrentStream();
        this.sqlstmt.clearWarnings();
        try {
            this.rowarray = this.sqlstmt.fetchAbsolute(rowNumber, this.fetchSize);
            this.rows = this.rowarray == null ? 0 : this.rowarray.getFetchedRows();
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        this.offset += this.rows;
        if (this.maxRows > 0 && this.rows + this.offset > this.maxRows) {
            this.rows = this.maxRows - this.offset;
        }
        if ((warning = this.sqlstmt.getWarnings()) != null) {
            this.warnings = warning;
        }
        if (this.rows > 0) {
            flag = true;
            this.row = 0;
            this.rowset = this.rowarray.getRowSet(this.row);
        }
        return flag;
    }

    @Override
    public void afterLast() throws SQLException {
        this.logger.entering(className, afterLast_name);
        this._validate(afterLast_name);
        throw this.createSQLException(afterLast_name, "afterLast() not available for forward only ResultSets");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.logger.entering(className, beforeFirst_name);
        this._validate(beforeFirst_name);
        this.row = -1;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.logger.entering(className, cancelRowUpdates_name);
        this._validate(cancelRowUpdates_name);
        throw this.createSQLException(cancelRowUpdates_name, "Cannot update a read only result set");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.logger.entering(className, clearWarnings_name);
        this._validate(clearWarnings_name);
        this.warnings = null;
        this.logger.exiting(className, clearWarnings_name);
    }

    @Override
    public void close() throws SQLException {
        this.logger.entering(className, close_name);
        if (this.stmt != null) {
            this.closeCurrentStream();
            try {
                this.sqlstmt.close();
            }
            catch (RDMException rDMException) {
                // empty catch block
            }
            this.stmt = null;
        }
        this.logger.exiting(className, close_name);
    }

    @Override
    public void deleteRow() throws SQLException {
        this.logger.entering(className, deleteRow_name);
        this._validate(deleteRow_name);
        throw this.createSQLFeatureNotSupportedException(updateRow_name, "Updates not supported in ResultSets");
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        this.logger.entering(className, findColumn_name, columnName);
        this._validate(findColumn_name);
        int columnIndex = this._findColumn(findColumn_name, columnName);
        this.logger.exiting(className, findColumn_name, columnIndex);
        return columnIndex;
    }

    @Override
    public boolean first() throws SQLException {
        this.logger.entering(className, first_name);
        this._validate(first_name);
        boolean flag = this.getKey ? this.firstKey() : this.firstRow();
        this.logger.exiting(className, first_name, flag);
        return flag;
    }

    private boolean firstKey() throws SQLException {
        boolean ret;
        try {
            int numKeys = this.sqlstmt.getNumGeneratedKeys();
            if (numKeys == 0) {
                ret = false;
            } else {
                ret = true;
                this.row = 0;
                this.rowset = this.sqlstmt.getGeneratedKey(this.row);
            }
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return ret;
    }

    private boolean firstRow() throws SQLException {
        SQLWarning warning;
        boolean flag = false;
        this.clearWarnings();
        this.closeCurrentStream();
        this.sqlstmt.clearWarnings();
        try {
            this.rowarray = this.sqlstmt.fetchFirst(this.fetchSize);
            this.rows = this.rowarray == null ? 0 : this.rowarray.getFetchedRows();
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        this.offset += this.rows;
        if (this.maxRows > 0 && this.rows + this.offset > this.maxRows) {
            this.rows = this.maxRows - this.offset;
        }
        if ((warning = this.sqlstmt.getWarnings()) != null) {
            this.warnings = warning;
        }
        if (this.rows > 0) {
            flag = true;
            this.row = 0;
            this.rowset = this.rowarray.getRowSet(this.row);
        }
        return flag;
    }

    private Array _getArray(String methodName, int i) throws SQLException {
        this.closeCurrentStream();
        throw this.createSQLFeatureNotSupportedException(methodName, "Arrays not supported");
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.logger.entering(className, getArray_name, i);
        this._validateColumn(getArray_name, i);
        Array array = this._getArray(getArray_name, i);
        this.logger.exiting(className, getArray_name, array);
        return array;
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        this.logger.entering(className, getArray_name, columnName);
        int columnIndex = this._validateColumn(getArray_name, columnName);
        Array array = this._getArray(getArray_name, columnIndex);
        this.logger.exiting(className, getArray_name, array);
        return array;
    }

    private InputStream _getAsciiStream(int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            this.currentStream = this.rowset.getAsciiStream(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return this.currentStream;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.logger.entering(className, getAsciiStream_name, columnIndex);
        this._validateColumn(getAsciiStream_name, columnIndex);
        InputStream stream = this._getAsciiStream(columnIndex);
        this.logger.exiting(className, getAsciiStream_name, stream);
        return stream;
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        this.logger.entering(className, getAsciiStream_name, columnName);
        int columnIndex = this._validateColumn(getAsciiStream_name, columnName);
        InputStream stream = this._getAsciiStream(columnIndex);
        this.logger.exiting(className, getAsciiStream_name, stream);
        return stream;
    }

    private BigDecimal _getBigDecimal(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            return this.rowset.getBigDecimal(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.logger.entering(className, getBigDecimal, columnIndex);
        this._validateColumn(getBigDecimal, columnIndex);
        BigDecimal bd = this._getBigDecimal(getBigDecimal, columnIndex);
        this.logger.exiting(className, getBigDecimal, bd);
        return bd;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.logger.entering(className, getBigDecimal, new Object[]{columnIndex, scale});
        this._validateColumn(getBigDecimal, columnIndex);
        throw this.createSQLFeatureNotSupportedException(getBigDecimal, "function is deprecated and not supported");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.logger.entering(className, getBigDecimal, columnName);
        int columnIndex = this._validateColumn(getBigDecimal, columnName);
        BigDecimal bd = this._getBigDecimal(getBigDecimal, columnIndex);
        this.logger.exiting(className, getBigDecimal, bd);
        return bd;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.logger.entering(className, getBigDecimal, new Object[]{columnName, scale});
        throw this.createSQLFeatureNotSupportedException(getBigDecimal, "function is deprecated and not supported");
    }

    private InputStream _getBinaryStream(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            this.currentStream = this.rowset.getBinaryStream(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return this.currentStream;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.logger.entering(className, getBinaryStream_name, columnIndex);
        this._validateColumn(getBinaryStream_name, columnIndex);
        InputStream stream = this._getBinaryStream(getBinaryStream_name, columnIndex);
        this.logger.exiting(className, getBinaryStream_name, stream);
        return stream;
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        this.logger.entering(className, getBinaryStream_name, columnName);
        int columnIndex = this._validateColumn(getBinaryStream_name, columnName);
        InputStream stream = this._getBinaryStream(getBinaryStream_name, columnIndex);
        this.logger.exiting(className, getBinaryStream_name, stream);
        return stream;
    }

    private Blob _getBlob(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            return new RDMBlob(this.rowset.getBinaryStream(columnIndex));
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.logger.entering(className, getBlob_name, columnIndex);
        this._validateColumn(getBlob_name, columnIndex);
        Blob blob = this._getBlob(getBlob_name, columnIndex);
        this.logger.exiting(className, getBlob_name, blob);
        return blob;
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        this.logger.entering(className, getBlob_name, columnName);
        int columnIndex = this._validateColumn(getBlob_name, columnName);
        Blob blob = this._getBlob(getBlob_name, columnIndex);
        this.logger.exiting(className, getBlob_name, blob);
        return blob;
    }

    private boolean _getBoolean(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return false;
            }
            this.lastnull = false;
            return this.rowset.getBoolean(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.logger.entering(className, getBoolean_name, columnIndex);
        this._validateColumn(getBoolean_name, columnIndex);
        boolean flag = this._getBoolean(getBoolean_name, columnIndex);
        this.logger.exiting(className, getBoolean_name, flag);
        return flag;
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        this.logger.entering(className, getBoolean_name, columnName);
        int columnIndex = this._validateColumn(getBoolean_name, columnName);
        boolean flag = this._getBoolean(getBoolean_name, columnIndex);
        this.logger.exiting(className, getBoolean_name, flag);
        return flag;
    }

    private byte _getByte(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return 0;
            }
            this.lastnull = false;
            return this.rowset.getByte(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.logger.entering(className, getByte_name, columnIndex);
        this._validateColumn(getByte_name, columnIndex);
        byte b = this._getByte(getByte_name, columnIndex);
        this.logger.exiting(className, getByte_name, b);
        return b;
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        this.logger.entering(className, getByte_name, columnName);
        int columnIndex = this._validateColumn(getByte_name, columnName);
        byte b = this._getByte(getByte_name, columnIndex);
        this.logger.exiting(className, getByte_name, b);
        return b;
    }

    private byte[] _getBytes(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            return this.rowset.getBytes(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.logger.entering(className, getBytes_name, columnIndex);
        this._validateColumn(getBytes_name, columnIndex);
        byte[] bytes = this._getBytes(getBytes_name, columnIndex);
        this.logger.exiting(className, getBytes_name, bytes);
        return bytes;
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        this.logger.entering(className, getBytes_name, columnName);
        int columnIndex = this._validateColumn(getBytes_name, columnName);
        byte[] bytes = this._getBytes(getBytes_name, columnIndex);
        this.logger.exiting(className, getBytes_name, bytes);
        return bytes;
    }

    private Reader _getCharacterStream(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            this.currentReader = this.rowset.getCharacterStream(columnIndex);
            return this.currentReader;
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.logger.entering(className, getCharacterStream_name, columnIndex);
        this._validateColumn(getCharacterStream_name, columnIndex);
        Reader reader = this._getCharacterStream(getCharacterStream_name, columnIndex);
        this.logger.exiting(className, getCharacterStream_name, reader);
        return reader;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        this.logger.entering(className, getCharacterStream_name, columnName);
        int columnIndex = this._validateColumn(getCharacterStream_name, columnName);
        Reader reader = this._getCharacterStream(getCharacterStream_name, columnIndex);
        this.logger.exiting(className, getCharacterStream_name, reader);
        return reader;
    }

    private Clob _getClob(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            return new RDMClob(this.rowset.getCharacterStream(columnIndex));
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.logger.entering(className, getClob_name, columnIndex);
        this._validateColumn(getClob_name, columnIndex);
        Clob clob = this._getClob(getClob_name, columnIndex);
        this.logger.exiting(className, getClob_name, clob);
        return clob;
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        this.logger.entering(className, getClob_name, columnName);
        int columnIndex = this._validateColumn(getClob_name, columnName);
        Clob clob = this._getClob(getClob_name, columnIndex);
        this.logger.exiting(className, getClob_name, clob);
        return clob;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.logger.entering(className, getConcurrency_name);
        this._validate(getConcurrency_name);
        int res = 1007;
        this.logger.exiting(className, getConcurrency_name, res);
        return res;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.logger.entering(className, getCursorName_name);
        throw this.createSQLException(getCursorName_name, "Non-updatable result sets do not support names");
    }

    private Date _getDate(String methodName, int columnIndex, Calendar cal) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            return this.rowset.getDate(columnIndex, cal);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.logger.entering(className, getDate_name, columnIndex);
        this._validateColumn(getDate_name, columnIndex);
        Date date = this._getDate(getDate_name, columnIndex, Calendar.getInstance(TimeZone.getDefault()));
        this.logger.exiting(className, getDate_name, date);
        return date;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.logger.entering(className, getDate_name, new Object[]{columnIndex, cal});
        this._validateColumn(getDate_name, columnIndex);
        Date date = this._getDate(getDate_name, columnIndex, cal);
        this.logger.exiting(className, getDate_name, date);
        return date;
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        this.logger.entering(className, getDate_name, columnName);
        int columnIndex = this._validateColumn(getDate_name, columnName);
        Date date = this._getDate(getDate_name, columnIndex, Calendar.getInstance(TimeZone.getDefault()));
        this.logger.exiting(className, getDate_name, date);
        return date;
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        this.logger.entering(className, getDate_name, new Object[]{columnName, cal});
        int columnIndex = this._validateColumn(getDate_name, columnName);
        Date date = this._getDate(getDate_name, columnIndex, cal);
        this.logger.exiting(className, getDate_name, date);
        return date;
    }

    private double _getDouble(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return 0.0;
            }
            this.lastnull = false;
            return this.rowset.getDouble(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.logger.entering(className, getDouble_name, columnIndex);
        this._validateColumn(getDouble_name, columnIndex);
        double d = this._getDouble(getDouble_name, columnIndex);
        this.logger.exiting(className, getDouble_name, d);
        return d;
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        this.logger.entering(className, getDouble_name, columnName);
        int columnIndex = this._validateColumn(getDouble_name, columnName);
        double d = this._getDouble(getDouble_name, columnIndex);
        this.logger.exiting(className, getDouble_name, d);
        return d;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.logger.entering(className, getFetchDirection_name);
        this._validate(getFetchDirection_name);
        int dir = 1000;
        this.logger.exiting(className, getFetchDirection_name, dir);
        return dir;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.logger.entering(className, getFetchSize_name);
        this._validate(getFetchSize_name);
        this.logger.exiting(className, getFetchSize_name, this.fetchSize);
        return this.fetchSize;
    }

    private float _getFloat(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return 0.0f;
            }
            this.lastnull = false;
            return this.rowset.getFloat(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.logger.entering(className, getFloat_name, columnIndex);
        this._validateColumn(getFloat_name, columnIndex);
        float f = this._getFloat(getFloat_name, columnIndex);
        this.logger.exiting(className, getFloat_name, Float.valueOf(f));
        return f;
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        this.logger.entering(className, getFloat_name, columnName);
        int columnIndex = this._validateColumn(getFloat_name, columnName);
        float f = this._getFloat(getFloat_name, columnIndex);
        this.logger.exiting(className, getFloat_name, Float.valueOf(f));
        return f;
    }

    @Override
    public int getHoldability() throws SQLException {
        String methodName = "getHoldability";
        this.logger.entering(className, methodName);
        this._validate(methodName);
        int holdability = 2;
        this.logger.exiting(className, methodName, holdability);
        return holdability;
    }

    private int _getInt(int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return 0;
            }
            this.lastnull = false;
            return this.rowset.getInt(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.logger.entering(className, getInt_name, columnIndex);
        this._validateColumn(getInt_name, columnIndex);
        int i = this._getInt(columnIndex);
        this.logger.exiting(className, getInt_name, i);
        return i;
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        this.logger.entering(className, getInt_name, columnName);
        int columnIndex = this._validateColumn(getInt_name, columnName);
        int i = this.getInt(columnIndex);
        this.logger.exiting(className, getInt_name, i);
        return i;
    }

    private long _getLong(int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return 0L;
            }
            this.lastnull = false;
            return this.rowset.getLong(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.logger.entering(className, getLong_name, columnIndex);
        this._validateColumn(getLong_name, columnIndex);
        long l = this._getLong(columnIndex);
        this.logger.exiting(className, getLong_name, l);
        return l;
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        this.logger.entering(className, getLong_name, columnName);
        int columnIndex = this._validateColumn(getLong_name, columnName);
        long l = this._getLong(columnIndex);
        this.logger.exiting(className, getLong_name, l);
        return l;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.logger.entering(className, getMetaData_name);
        this._validate(getMetaData_name);
        this.logger.exiting(className, getMetaData_name, this.meta);
        return this.meta;
    }

    private Reader _getNCharacterStream(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            this.currentReader = this.rowset.getCharacterStream(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return this.currentReader;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.logger.entering(className, getNCharacterStream_name, columnIndex);
        this._validateColumn(getNCharacterStream_name, columnIndex);
        Reader x = this._getNCharacterStream(getNCharacterStream_name, columnIndex);
        this.logger.exiting(className, getNCharacterStream_name, x);
        return x;
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        this.logger.entering(className, getNCharacterStream_name, columnName);
        int columnIndex = this._validateColumn(getNCharacterStream_name, columnName);
        Reader x = this._getNCharacterStream(getNCharacterStream_name, columnIndex);
        this.logger.exiting(className, getNCharacterStream_name, x);
        return x;
    }

    private NClob _getNClob(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            return new RDMNClob(this.rowset.getCharacterStream(columnIndex));
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.logger.entering(className, getNClob_name, columnIndex);
        this._validateColumn(getNClob_name, columnIndex);
        NClob x = this._getNClob(getNClob_name, columnIndex);
        this.logger.exiting(className, getNClob_name, x);
        return x;
    }

    @Override
    public NClob getNClob(String columnName) throws SQLException {
        this.logger.entering(className, getNClob_name, columnName);
        int columnIndex = this._validateColumn(getNClob_name, columnName);
        NClob x = this._getNClob(getNClob_name, columnIndex);
        this.logger.exiting(className, getNClob_name, x);
        return x;
    }

    private String _getNString(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            return this.rowset.getString(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.logger.entering(className, getNString_name, columnIndex);
        this._validateColumn(getNString_name, columnIndex);
        String x = this._getNString(getNString_name, columnIndex);
        this.logger.exiting(className, getNString_name, x);
        return x;
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        this.logger.entering(className, getNString_name, columnName);
        int columnIndex = this._validateColumn(getNString_name, columnName);
        String x = this._getNString(getNString_name, columnIndex);
        this.logger.exiting(className, getNString_name, x);
        return x;
    }

    private Object _getObject(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            return this.rowset.getObject(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.logger.entering(className, getObject_name, columnIndex);
        this._validateColumn(getObject_name, columnIndex);
        Object o = this._getObject(getObject_name, columnIndex);
        this.logger.exiting(className, getObject_name, o);
        return o;
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        this.logger.entering(className, getObject_name, new Object[]{columnIndex, map});
        if (map != null) {
            this._addWarning("Ignoring unsupported map in getObject");
        }
        this._validateColumn(getObject_name, columnIndex);
        Object o = this._getObject(getObject_name, columnIndex);
        this.logger.exiting(className, getObject_name, o);
        return o;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        this.logger.entering(className, getObject_name, columnName);
        int columnIndex = this._validateColumn(getObject_name, columnName);
        Object o = this._getObject(getObject_name, columnIndex);
        this.logger.exiting(className, getObject_name, o);
        return o;
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        this.logger.entering(className, getObject_name, new Object[]{columnName, map});
        if (map != null) {
            this._addWarning("Ignoring unsupported map in getObject");
        }
        int columnIndex = this._validateColumn(getObject_name, columnName);
        Object o = this._getObject(getObject_name, columnIndex);
        this.logger.exiting(className, getObject_name, o);
        return o;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.logger.entering(className, getObject_name, new Object[]{columnIndex, type});
        throw this.createSQLFeatureNotSupportedException(getObject_name, "not supported");
    }

    @Override
    public <T> T getObject(String columnName, Class<T> type) throws SQLException {
        this.logger.entering(className, getObject_name, new Object[]{columnName, type});
        throw this.createSQLFeatureNotSupportedException(getObject_name, "not supported");
    }

    private Ref _getRef(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        throw this.createSQLFeatureNotSupportedException(methodName, "getRef not supported");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.logger.entering(className, getRef_name, columnIndex);
        this._validateColumn(getRef_name, columnIndex);
        Ref r = this._getRef(getRef_name, columnIndex);
        this.logger.exiting(className, getRef_name, r);
        return r;
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        this.logger.entering(className, getRef_name, columnName);
        int columnIndex = this._validateColumn(getRef_name, columnName);
        Ref r = this._getRef(getRef_name, columnIndex);
        this.logger.exiting(className, getRef_name, r);
        return r;
    }

    @Override
    public int getRow() throws SQLException {
        this.logger.entering(className, getRow_name);
        this._validate(getRow_name);
        this.logger.exiting(className, getRow_name, this.row + 1);
        return this.row + 1;
    }

    private RowId _getRowId(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        throw this.createSQLFeatureNotSupportedException(methodName, "getRowId not supported");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.logger.entering(className, getRowId_name, columnIndex);
        this._validateColumn(getRowId_name, columnIndex);
        RowId r = this._getRowId(getRowId_name, columnIndex);
        this.logger.exiting(className, getRowId_name, r);
        return r;
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        this.logger.entering(className, getRowId_name, columnName);
        int columnIndex = this._validateColumn(getRowId_name, columnName);
        RowId r = this._getRowId(getRowId_name, columnIndex);
        this.logger.exiting(className, getRowId_name, r);
        return r;
    }

    private short _getShort(int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return 0;
            }
            this.lastnull = false;
            return this.rowset.getShort(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.logger.entering(className, getShort_name, columnIndex);
        this._validateColumn(getShort_name, columnIndex);
        short s = this._getShort(columnIndex);
        this.logger.exiting(className, getShort_name, s);
        return s;
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        this.logger.entering(className, getShort_name, columnName);
        int columnIndex = this._validateColumn(getShort_name, columnName);
        short s = this._getShort(columnIndex);
        this.logger.exiting(className, getShort_name, s);
        return s;
    }

    private SQLXML _getSQLXML(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        throw this.createSQLFeatureNotSupportedException(methodName, "getSQLXML not supported");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.logger.entering(className, getSQLXML_name, columnIndex);
        this._validateColumn(getSQLXML_name, columnIndex);
        SQLXML x = this._getSQLXML(getSQLXML_name, columnIndex);
        this.logger.exiting(className, getSQLXML_name, x);
        return x;
    }

    @Override
    public SQLXML getSQLXML(String columnName) throws SQLException {
        this.logger.entering(className, getSQLXML_name, columnName);
        int columnIndex = this._validateColumn(getSQLXML_name, columnName);
        SQLXML x = this._getSQLXML(getSQLXML_name, columnIndex);
        this.logger.exiting(className, getSQLXML_name, x);
        return x;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.logger.entering(className, getStatement_name);
        this._validate(getStatement_name);
        this.logger.exiting(className, getStatement_name, this.stmt);
        return this.stmt;
    }

    private String _getString(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            return this.rowset.getString(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.logger.entering(className, getString_name, columnIndex);
        this._validateColumn(getString_name, columnIndex);
        String str = this._getString(getString_name, columnIndex);
        this.logger.exiting(className, getString_name, str);
        return str;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        this.logger.entering(className, getString_name, columnName);
        int columnIndex = this._validateColumn(getString_name, columnName);
        String str = this._getString(getString_name, columnIndex);
        this.logger.exiting(className, getString_name, str);
        return str;
    }

    public Time _getTime(String methodName, int columnIndex, Calendar cal) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            return this.rowset.getTime(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.logger.entering(className, getTime_name, columnIndex);
        this._validateColumn(getTime_name, columnIndex);
        Time tm = this._getTime(getTime_name, columnIndex, Calendar.getInstance(TimeZone.getDefault()));
        this.logger.exiting(className, getTime_name, tm);
        return tm;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.logger.entering(className, getTime_name, new Object[]{columnIndex, cal});
        this._validateColumn(getTime_name, columnIndex);
        Time tm = this._getTime(getTime_name, columnIndex, cal);
        this.logger.exiting(className, getTime_name, tm);
        return tm;
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        this.logger.entering(className, getTime_name, columnName);
        int columnIndex = this._validateColumn(getTime_name, columnName);
        Time tm = this._getTime(getTime_name, columnIndex, Calendar.getInstance(TimeZone.getDefault()));
        this.logger.exiting(className, getTime_name, tm);
        return tm;
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        this.logger.entering(className, getTime_name, new Object[]{columnName, cal});
        int columnIndex = this._validateColumn(getTime_name, columnName);
        Time tm = this._getTime(getTime_name, columnIndex, cal);
        this.logger.exiting(className, getTime_name, tm);
        return tm;
    }

    private Timestamp _getTimestamp(String methodName, int columnIndex, Calendar cal) throws SQLException {
        this.closeCurrentStream();
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            return this.rowset.getTimestamp(columnIndex);
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.logger.entering(className, getTimestamp_name, columnIndex);
        this._validateColumn(getTimestamp_name, columnIndex);
        Timestamp ts = this._getTimestamp(getTimestamp_name, columnIndex, Calendar.getInstance(TimeZone.getDefault()));
        this.logger.exiting(className, getTimestamp_name, ts);
        return ts;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.logger.entering(className, getTimestamp_name, new Object[]{columnIndex, cal});
        this._validateColumn(getTimestamp_name, columnIndex);
        Timestamp ts = this._getTimestamp(getTimestamp_name, columnIndex, cal);
        this.logger.exiting(className, getTimestamp_name, ts);
        return ts;
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        this.logger.entering(className, getTimestamp_name, columnName);
        int columnIndex = this._validateColumn(getTimestamp_name, columnName);
        Timestamp ts = this._getTimestamp(getTimestamp_name, columnIndex, Calendar.getInstance(TimeZone.getDefault()));
        this.logger.exiting(className, getTimestamp_name, ts);
        return ts;
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.logger.entering(className, getTimestamp_name, new Object[]{columnName, cal});
        int columnIndex = this._validateColumn(getTimestamp_name, columnName);
        Timestamp ts = this._getTimestamp(getTimestamp_name, columnIndex, cal);
        this.logger.exiting(className, getTimestamp_name, ts);
        return ts;
    }

    @Override
    public int getType() throws SQLException {
        this.logger.entering(className, getType_name);
        this._validate(getType_name);
        int type = 1003;
        this.logger.exiting(className, getType_name, type);
        return type;
    }

    private InputStream _getUnicodeStream(String methodName, int columnIndex) throws SQLException {
        this.closeCurrentStream();
        throw this.createSQLFeatureNotSupportedException(methodName, "function has been decremented and is not supported");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.logger.entering(className, getUnicodeStream_name, columnIndex);
        this._validateColumn(getUnicodeStream_name, columnIndex);
        InputStream stream = this._getUnicodeStream(getUnicodeStream_name, columnIndex);
        this.logger.exiting(className, getUnicodeStream_name, stream);
        return stream;
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        this.logger.entering(className, getUnicodeStream_name, columnName);
        int columnIndex = this._validateColumn(getUnicodeStream_name, columnName);
        InputStream stream = this._getUnicodeStream(getUnicodeStream_name, columnIndex);
        this.logger.exiting(className, getUnicodeStream_name, stream);
        return stream;
    }

    private URL _getURL(String methodName, int columnIndex) throws SQLException {
        URL url;
        try {
            if (this.rowset.isNull(columnIndex)) {
                this.lastnull = true;
                return null;
            }
            this.lastnull = false;
            url = new URL(this.rowset.getString(columnIndex));
        }
        catch (MalformedURLException e) {
            SQLException sqlex = new SQLException("URL is malformed");
            this.logger.throwing(className, methodName, sqlex);
            throw sqlex;
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return url;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.logger.entering(className, getURL_name, columnIndex);
        this._validateColumn(getURL_name, columnIndex);
        URL url = this._getURL(getURL_name, columnIndex);
        this.logger.exiting(className, getURL_name, url);
        return url;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        this.logger.entering(className, getURL_name, columnName);
        int columnIndex = this._validateColumn(getURL_name, columnName);
        URL url = this._getURL(getURL_name, columnIndex);
        this.logger.exiting(className, getURL_name, url);
        return url;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.logger.entering(className, getWarnings_name);
        this._validate(getWarnings_name);
        this.logger.exiting(className, getWarnings_name, this.warnings);
        return this.warnings;
    }

    @Override
    public void insertRow() throws SQLException {
        this.logger.entering(className, insertRow_name);
        this._validate(insertRow_name);
        throw this.createSQLFeatureNotSupportedException(insertRow_name, "insertRow method not supported");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.logger.entering(className, isAfterLast_name);
        this._validate(isAfterLast_name);
        boolean flag = this.getKey ? this.isAfterLastKey() : this.isAfterLastRow();
        this.logger.exiting(className, isAfterLast_name, flag);
        return flag;
    }

    private boolean isAfterLastKey() throws SQLException {
        int numKeys = this.sqlstmt.getNumGeneratedKeys();
        boolean ret = numKeys != 0 && this.row != numKeys;
        return ret;
    }

    private boolean isAfterLastRow() throws SQLException {
        boolean flag = false;
        this.clearWarnings();
        this.closeCurrentStream();
        this.sqlstmt.clearWarnings();
        try {
            short cursorStatus = this.sqlstmt.getCursorStatus();
            if (cursorStatus == 4) {
                flag = true;
            }
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return flag;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.logger.entering(className, isBeforeFirst_name);
        this._validate(isBeforeFirst_name);
        boolean flag = this.getKey ? this.isBeforeFirstKey() : this.isBeforeFirstRow();
        this.logger.exiting(className, isBeforeFirst_name, flag);
        return flag;
    }

    private boolean isBeforeFirstKey() throws SQLException {
        int numKeys = this.sqlstmt.getNumGeneratedKeys();
        boolean ret = numKeys != 0 && this.row == -1;
        return ret;
    }

    private boolean isBeforeFirstRow() throws SQLException {
        boolean flag = false;
        this.clearWarnings();
        this.closeCurrentStream();
        this.sqlstmt.clearWarnings();
        try {
            short cursorStatus = this.sqlstmt.getCursorStatus();
            if (cursorStatus == 0) {
                flag = true;
            }
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return flag;
    }

    @Override
    public boolean isClosed() throws SQLException {
        String methodName = "isClosed";
        this.logger.entering(className, methodName);
        boolean flag = this.stmt == null;
        this.logger.exiting(className, methodName, flag);
        return flag;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.logger.entering(className, isFirst_name);
        this._validate(isFirst_name);
        boolean flag = this.getKey ? this.isFirstKey() : this.isFirstRow();
        this.logger.exiting(className, isFirst_name, flag);
        return flag;
    }

    private boolean isFirstKey() throws SQLException {
        int numKeys = this.sqlstmt.getNumGeneratedKeys();
        boolean ret = numKeys != 0 && this.row == 0;
        return ret;
    }

    private boolean isFirstRow() throws SQLException {
        boolean flag = false;
        this.clearWarnings();
        this.closeCurrentStream();
        this.sqlstmt.clearWarnings();
        try {
            short cursorStatus = this.sqlstmt.getCursorStatus();
            if (cursorStatus == 1) {
                flag = true;
            }
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return flag;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.logger.entering(className, isLast_name);
        this._validate(isLast_name);
        boolean flag = this.getKey ? this.isLastKey() : this.isLastRow();
        this.logger.exiting(className, isLast_name, flag);
        return flag;
    }

    private boolean isLastKey() throws SQLException {
        int numKeys = this.sqlstmt.getNumGeneratedKeys();
        boolean ret = numKeys != 0 && this.row == numKeys - 1;
        return ret;
    }

    private boolean isLastRow() throws SQLException {
        boolean flag = false;
        this.clearWarnings();
        this.closeCurrentStream();
        this.sqlstmt.clearWarnings();
        try {
            short cursorStatus = this.sqlstmt.getCursorStatus();
            if (cursorStatus == 3) {
                flag = true;
            }
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return flag;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodName = "isWrapperFor";
        this.logger.entering(className, methodName, iface);
        boolean result = iface.isInstance(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    @Override
    public boolean last() throws SQLException {
        this.logger.entering(className, last_name);
        this._validate(last_name);
        boolean flag = this.getKey ? this.lastKey() : this.lastRow();
        this.logger.exiting(className, last_name, flag);
        return flag;
    }

    private boolean lastKey() throws SQLException {
        boolean ret;
        try {
            int numKeys = this.sqlstmt.getNumGeneratedKeys();
            if (numKeys == 0) {
                ret = false;
            } else {
                ret = true;
                this.row = numKeys - 1;
                this.rowset = this.sqlstmt.getGeneratedKey(this.row);
            }
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return ret;
    }

    private boolean lastRow() throws SQLException {
        SQLWarning warning;
        boolean flag = false;
        this.clearWarnings();
        this.closeCurrentStream();
        this.sqlstmt.clearWarnings();
        try {
            this.rowarray = this.sqlstmt.fetchLast();
            this.rows = this.rowarray == null ? 0 : this.rowarray.getFetchedRows();
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        this.offset += this.rows;
        if (this.maxRows > 0 && this.rows + this.offset > this.maxRows) {
            this.rows = this.maxRows - this.offset;
        }
        if ((warning = this.sqlstmt.getWarnings()) != null) {
            this.warnings = warning;
        }
        if (this.rows > 0) {
            flag = true;
            this.row = this.rows - 1;
            this.rowset = this.rowarray.getRowSet(0);
        }
        return flag;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.logger.entering(className, moveToCurrentRow_name);
        this._validate(moveToCurrentRow_name);
        this.logger.exiting(className, moveToCurrentRow_name);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.logger.entering(className, moveToInsertRow_name);
        this._validate(moveToInsertRow_name);
        throw this.createSQLFeatureNotSupportedException(moveToInsertRow_name, "inserts are not supported in ResultSets");
    }

    @Override
    public boolean next() throws SQLException {
        this.logger.entering(className, next_name);
        this._validate(next_name);
        boolean flag = this.getKey ? this.nextKey() : this.nextRow();
        this.logger.exiting(className, next_name, flag);
        return flag;
    }

    private boolean nextKey() throws SQLException {
        boolean flag;
        try {
            this.rowset = this.sqlstmt.getGeneratedKey(++this.row);
            flag = this.rowset != null;
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return flag;
    }

    private boolean nextRow() throws SQLException {
        boolean flag = false;
        if (this.row + 1 == this.rows) {
            this.row = -1;
        }
        if (this.row == -1) {
            if (this.done) {
                this.close();
            } else {
                SQLWarning warning;
                this.clearWarnings();
                this.closeCurrentStream();
                this.sqlstmt.clearWarnings();
                try {
                    this.rowarray = this.sqlstmt.fetchNext(this.fetchSize);
                    this.rows = this.rowarray == null ? 0 : this.rowarray.getFetchedRows();
                }
                catch (RDMException e) {
                    throw e.createSQLException();
                }
                this.offset += this.rows;
                if (this.rows < this.fetchSize) {
                    this.done = true;
                }
                if (this.maxRows > 0 && this.rows + this.offset > this.maxRows) {
                    this.rows = this.maxRows - this.offset;
                }
                if ((warning = this.sqlstmt.getWarnings()) != null) {
                    this.warnings = warning;
                }
                if (this.rows > 0) {
                    flag = true;
                    this.rowset = this.rowarray.getRowSet(++this.row);
                }
            }
        } else {
            flag = true;
            this.rowset = this.rowarray.getRowSet(++this.row);
        }
        return flag;
    }

    @Override
    public boolean previous() throws SQLException {
        this.logger.entering(className, previous_name);
        this._validate(previous_name);
        boolean flag = this.getKey ? this.previousKey() : this.previousRow();
        this.logger.exiting(className, next_name, flag);
        return flag;
    }

    private boolean previousKey() throws SQLException {
        boolean flag;
        try {
            this.rowset = this.sqlstmt.getGeneratedKey(--this.row);
            flag = this.rowset != null;
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return flag;
    }

    private boolean previousRow() throws SQLException {
        boolean flag = false;
        if (this.row == 0) {
            SQLWarning warning;
            this.row = -1;
            this.clearWarnings();
            this.closeCurrentStream();
            this.sqlstmt.clearWarnings();
            try {
                this.rowarray = this.sqlstmt.fetchPrior(this.fetchSize);
                this.rows = this.rowarray == null ? 0 : this.rowarray.getFetchedRows();
            }
            catch (RDMException e) {
                throw e.createSQLException();
            }
            this.offset += this.rows;
            if (this.maxRows > 0 && this.rows + this.offset > this.maxRows) {
                this.rows = this.maxRows - this.offset;
            }
            if ((warning = this.sqlstmt.getWarnings()) != null) {
                this.warnings = warning;
            }
            if (this.rows > 0) {
                flag = true;
                this.rowset = this.rowarray.getRowSet(++this.row);
            }
        } else {
            flag = true;
            this.rowset = this.rowarray.getRowSet(--this.row);
        }
        return flag;
    }

    @Override
    public void refreshRow() throws SQLException {
        this.logger.entering(className, refreshRow_name);
        this._validate(refreshRow_name);
        this.logger.exiting(className, refreshRow_name);
    }

    @Override
    public boolean relative(int rowNumber) throws SQLException {
        this.logger.entering(className, relative_name, this.rows);
        this._validate(relative_name);
        boolean flag = this.getKey ? this.relativeKey(rowNumber) : this.relativeRow(rowNumber);
        this.logger.exiting(className, relative_name, flag);
        return flag;
    }

    private boolean relativeKey(int rowNumber) throws SQLException {
        boolean ret;
        try {
            int newNumber = this.row + rowNumber;
            if (newNumber < 0) {
                ret = false;
            } else {
                int numKeys = this.sqlstmt.getNumGeneratedKeys();
                if (numKeys == 0 || newNumber >= numKeys) {
                    ret = false;
                } else {
                    ret = true;
                    this.row = newNumber;
                    this.rowset = this.sqlstmt.getGeneratedKey(this.row);
                }
            }
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
        return ret;
    }

    private boolean relativeRow(int rowNumber) throws SQLException {
        boolean flag = false;
        int newNumber = this.row + rowNumber;
        if (newNumber < 0 || newNumber >= this.rows) {
            SQLWarning warning;
            this.row = -1;
            this.clearWarnings();
            this.closeCurrentStream();
            this.sqlstmt.clearWarnings();
            try {
                this.rowarray = this.sqlstmt.fetchRelative(newNumber, this.fetchSize);
                this.rows = this.rowarray == null ? 0 : this.rowarray.getFetchedRows();
            }
            catch (RDMException e) {
                throw e.createSQLException();
            }
            this.offset += this.rows;
            if (this.maxRows > 0 && this.rows + this.offset > this.maxRows) {
                this.rows = this.maxRows - this.offset;
            }
            if ((warning = this.sqlstmt.getWarnings()) != null) {
                this.warnings = warning;
            }
            if (this.rows > 0) {
                flag = true;
                this.rowset = this.rowarray.getRowSet(++this.row);
            }
        } else {
            flag = true;
            this.row = newNumber;
            this.rowset = this.rowarray.getRowSet(this.row);
        }
        return flag;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.logger.entering(className, rowDeleted_name);
        this._validate(rowDeleted_name);
        this.logger.exiting(className, rowDeleted_name, false);
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.logger.entering(className, rowInserted_name);
        this._validate(rowInserted_name);
        this.logger.exiting(className, rowInserted_name, false);
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.logger.entering(className, rowUpdated_name);
        this._validate(rowUpdated_name);
        this.logger.exiting(className, rowUpdated_name, false);
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.logger.entering(className, setFetchDirection_name, direction);
        this._validate(setFetchDirection_name);
        if (direction != 1000) {
            throw this.createSQLException(setFetchDirection_name, "Cannot change fetch direction");
        }
        this.logger.exiting(className, setFetchDirection_name);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.logger.entering(className, setFetchSize_name, rows);
        this._validate(setFetchSize_name);
        if (rows < 0 || this.maxRows > 0 && rows > this.maxRows) {
            throw this.createSQLException(setFetchSize_name, "Invalid fetch size amount");
        }
        this.fetchSize = rows;
        this.logger.exiting(className, setFetchSize_name);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodName = "unwrap";
        this.logger.entering(className, methodName, iface);
        if (!iface.isInstance(this)) {
            throw this.createSQLException(methodName, "not an instance");
        }
        T result = iface.cast(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    private void _updateArray(String methodName, int columnIndex, Array x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.logger.entering(className, updateArray_name, new Object[]{columnIndex, x});
        this._validateColumn(updateArray_name, columnIndex);
        this._updateArray(updateArray_name, columnIndex, x);
        this.logger.exiting(className, updateArray_name);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.logger.entering(className, updateArray_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateArray_name, columnName);
        this._updateArray(updateArray_name, columnIndex, x);
        this.logger.exiting(className, updateArray_name);
    }

    private void _updateAsciiStream(String methodName, int columnIndex, InputStream x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    private void _updateAsciiStream(String methodName, int columnIndex, InputStream x, long length) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.logger.entering(className, updateAsciiStream_name, new Object[]{columnIndex, x});
        this._validateColumn(updateAsciiStream_name, columnIndex);
        this._updateAsciiStream(updateAsciiStream_name, columnIndex, x);
        this.logger.exiting(className, updateAsciiStream_name);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x) throws SQLException {
        this.logger.entering(className, updateAsciiStream_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateAsciiStream_name, columnName);
        this._updateAsciiStream(updateAsciiStream_name, columnIndex, x);
        this.logger.exiting(className, updateAsciiStream_name);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.logger.entering(className, updateAsciiStream_name, new Object[]{columnIndex, x, length});
        this._validateColumn(updateAsciiStream_name, columnIndex);
        this._updateAsciiStream(updateAsciiStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateAsciiStream_name);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.logger.entering(className, updateAsciiStream_name, new Object[]{columnName, x, length});
        int columnIndex = this._validateColumn(updateAsciiStream_name, columnName);
        this._updateAsciiStream(updateAsciiStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateAsciiStream_name);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.logger.entering(className, updateAsciiStream_name, new Object[]{columnIndex, x, length});
        this._validateColumn(updateAsciiStream_name, columnIndex);
        this._updateAsciiStream(updateAsciiStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateAsciiStream_name);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, long length) throws SQLException {
        this.logger.entering(className, updateAsciiStream_name, new Object[]{columnName, x, length});
        int columnIndex = this._validateColumn(updateAsciiStream_name, columnName);
        this._updateAsciiStream(updateAsciiStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateAsciiStream_name);
    }

    private void _updateBigDecimal(String methodName, int columnIndex, BigDecimal x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.logger.entering(className, updateBigDecimal_name, new Object[]{columnIndex, x});
        this._validateColumn(updateBigDecimal_name, columnIndex);
        this._updateBigDecimal(updateBigDecimal_name, columnIndex, x);
        this.logger.exiting(className, updateBigDecimal_name);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.logger.entering(className, updateBigDecimal_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateBigDecimal_name, columnName);
        this._updateBigDecimal(updateBigDecimal_name, columnIndex, x);
        this.logger.exiting(className, updateBigDecimal_name);
    }

    private void _updateBinaryStream(String methodName, int columnIndex, InputStream x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    private void _updateBinaryStream(String methodName, int columnIndex, InputStream x, long length) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.logger.entering(className, updateBinaryStream_name, new Object[]{columnIndex, x});
        this._validateColumn(updateBinaryStream_name, columnIndex);
        this._updateBinaryStream(updateBinaryStream_name, columnIndex, x);
        this.logger.exiting(className, updateBinaryStream_name);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x) throws SQLException {
        this.logger.entering(className, updateBinaryStream_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateBinaryStream_name, columnName);
        this._updateBinaryStream(updateBinaryStream_name, columnIndex, x);
        this.logger.exiting(className, updateBinaryStream_name);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.logger.entering(className, updateBinaryStream_name, new Object[]{columnIndex, x, length});
        this._validateColumn(updateBinaryStream_name, columnIndex);
        this._updateBinaryStream(updateBinaryStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateBinaryStream_name);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.logger.entering(className, updateBinaryStream_name, new Object[]{columnName, x, length});
        int columnIndex = this._validateColumn(updateBinaryStream_name, columnName);
        this._updateBinaryStream(updateBinaryStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateBinaryStream_name);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.logger.entering(className, updateBinaryStream_name, new Object[]{columnIndex, x, length});
        this._validateColumn(updateBinaryStream_name, columnIndex);
        this._updateBinaryStream(updateBinaryStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateBinaryStream_name);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, long length) throws SQLException {
        this.logger.entering(className, updateBinaryStream_name, new Object[]{columnName, x, length});
        int columnIndex = this._validateColumn(updateBinaryStream_name, columnName);
        this._updateBinaryStream(updateBinaryStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateBinaryStream_name);
    }

    private void _updateBlob(String methodName, int columnIndex, Blob x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    private void _updateBlob(String methodName, int columnIndex, InputStream x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    private void _updateBlob(String methodName, int columnIndex, InputStream x, long length) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.logger.entering(className, updateBlob_name, new Object[]{columnIndex, x});
        this._validateColumn(updateBlob_name, columnIndex);
        this._updateBlob(updateBlob_name, columnIndex, x);
        this.logger.exiting(className, updateBlob_name);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.logger.entering(className, updateBlob_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateBlob_name, columnName);
        this._updateBlob(updateBlob_name, columnIndex, x);
        this.logger.exiting(className, updateBlob_name);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        this.logger.entering(className, updateBlob_name, new Object[]{columnIndex, x});
        this._validateColumn(updateBlob_name, columnIndex);
        this._updateBlob(updateBlob_name, columnIndex, x);
        this.logger.exiting(className, updateBlob_name);
    }

    @Override
    public void updateBlob(String columnName, InputStream x) throws SQLException {
        this.logger.entering(className, updateBlob_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateBlob_name, columnName);
        this._updateBlob(updateBlob_name, columnIndex, x);
        this.logger.exiting(className, updateBlob_name);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        this.logger.entering(className, updateBlob_name, new Object[]{columnIndex, x, length});
        this._validateColumn(updateBlob_name, columnIndex);
        this._updateBlob(updateBlob_name, columnIndex, x, length);
        this.logger.exiting(className, updateBlob_name);
    }

    @Override
    public void updateBlob(String columnName, InputStream x, long length) throws SQLException {
        this.logger.entering(className, updateBlob_name, new Object[]{columnName, x, length});
        int columnIndex = this._validateColumn(updateBlob_name, columnName);
        this._updateBlob(updateBlob_name, columnIndex, x, length);
        this.logger.exiting(className, updateBlob_name);
    }

    private void _updateBoolean(String methodName, int columnIndex, boolean x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.logger.entering(className, updateBoolean_name, new Object[]{columnIndex, x});
        this._validateColumn(updateBoolean_name, columnIndex);
        this._updateBoolean(updateBoolean_name, columnIndex, x);
        this.logger.exiting(className, updateBoolean_name);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.logger.entering(className, updateBoolean_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateBoolean_name, columnName);
        this._updateBoolean(updateBoolean_name, columnIndex, x);
        this.logger.exiting(className, updateBoolean_name);
    }

    private void _updateByte(String methodName, int columnIndex, byte x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.logger.entering(className, updateByte_name, new Object[]{columnIndex, x});
        this._validateColumn(updateByte_name, columnIndex);
        this._updateByte(updateByte_name, columnIndex, x);
        this.logger.exiting(className, updateByte_name);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.logger.entering(className, updateByte_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateByte_name, columnName);
        this._updateByte(updateByte_name, columnIndex, x);
        this.logger.exiting(className, updateByte_name);
    }

    private void _updateBytes(String methodName, int columnIndex, byte[] x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.logger.entering(className, updateBytes_name, new Object[]{columnIndex, x});
        this._validateColumn(updateBytes_name, columnIndex);
        this._updateBytes(updateBytes_name, columnIndex, x);
        this.logger.exiting(className, updateBytes_name);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.logger.entering(className, updateBytes_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateBytes_name, columnName);
        this._updateBytes(updateBytes_name, columnIndex, x);
        this.logger.exiting(className, updateBytes_name);
    }

    private void _updateCharacterStream(String methodName, int columnIndex, Reader x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    private void _updateCharacterStream(String methodName, int columnIndex, Reader x, long length) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.logger.entering(className, updateCharacterStream_name, new Object[]{columnIndex, x});
        this._validateColumn(updateCharacterStream_name, columnIndex);
        this._updateCharacterStream(updateCharacterStream_name, columnIndex, x);
        this.logger.exiting(className, updateCharacterStream_name);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x) throws SQLException {
        this.logger.entering(className, updateCharacterStream_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateCharacterStream_name, columnName);
        this._updateCharacterStream(updateCharacterStream_name, columnIndex, x);
        this.logger.exiting(className, updateCharacterStream_name);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.logger.entering(className, updateCharacterStream_name, new Object[]{columnIndex, x, length});
        this._validateColumn(updateCharacterStream_name, columnIndex);
        this._updateCharacterStream(updateCharacterStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateCharacterStream_name);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.logger.entering(className, updateCharacterStream_name, new Object[]{columnName, x, length});
        int columnIndex = this._validateColumn(updateCharacterStream_name, columnName);
        this._updateCharacterStream(updateCharacterStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateCharacterStream_name);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.logger.entering(className, updateCharacterStream_name, new Object[]{columnIndex, x, length});
        this._validateColumn(updateCharacterStream_name, columnIndex);
        this._updateCharacterStream(updateCharacterStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateCharacterStream_name);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, long length) throws SQLException {
        this.logger.entering(className, updateCharacterStream_name, new Object[]{columnName, x, length});
        int columnIndex = this._validateColumn(updateCharacterStream_name, columnName);
        this._updateCharacterStream(updateCharacterStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateCharacterStream_name);
    }

    private void _updateClob(String methodName, int columnIndex, Clob x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    private void _updateClob(String methodName, int columnIndex, Reader x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    private void _updateClob(String methodName, int columnIndex, Reader x, long length) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.logger.entering(className, updateClob_name, new Object[]{columnIndex, x});
        this._validateColumn(updateClob_name, columnIndex);
        this._updateClob(updateClob_name, columnIndex, x);
        this.logger.exiting(className, updateClob_name);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.logger.entering(className, updateClob_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateClob_name, columnName);
        this._updateClob(updateClob_name, columnIndex, x);
        this.logger.exiting(className, updateClob_name);
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        this.logger.entering(className, updateClob_name, new Object[]{columnIndex, x});
        this._validateColumn(updateClob_name, columnIndex);
        this._updateClob(updateClob_name, columnIndex, x);
        this.logger.exiting(className, updateClob_name);
    }

    @Override
    public void updateClob(String columnName, Reader x) throws SQLException {
        this.logger.entering(className, updateClob_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateClob_name, columnName);
        this._updateClob(updateClob_name, columnIndex, x);
        this.logger.exiting(className, updateClob_name);
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        this.logger.entering(className, updateClob_name, new Object[]{columnIndex, x, length});
        this._validateColumn(updateClob_name, columnIndex);
        this._updateClob(updateClob_name, columnIndex, x, length);
        this.logger.exiting(className, updateClob_name);
    }

    @Override
    public void updateClob(String columnName, Reader x, long length) throws SQLException {
        this.logger.entering(className, updateClob_name, new Object[]{columnName, x, length});
        int columnIndex = this._validateColumn(updateClob_name, columnName);
        this._updateClob(updateClob_name, columnIndex, x, length);
        this.logger.exiting(className, updateClob_name);
    }

    private void _updateDate(String methodName, int columnIndex, Date x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.logger.entering(className, updateDate_name, new Object[]{columnIndex, x});
        this._validateColumn(updateDate_name, columnIndex);
        this._updateDate(updateDate_name, columnIndex, x);
        this.logger.exiting(className, updateDate_name);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.logger.entering(className, updateDate_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateDate_name, columnName);
        this._updateDate(updateDate_name, columnIndex, x);
        this.logger.exiting(className, updateDate_name);
    }

    private void _updateDouble(String methodName, int columnIndex, double x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.logger.entering(className, updateDouble_name, new Object[]{columnIndex, x});
        this._validateColumn(updateDouble_name, columnIndex);
        this._updateDouble(updateDouble_name, columnIndex, x);
        this.logger.exiting(className, updateDouble_name);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.logger.entering(className, updateDouble_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateDouble_name, columnName);
        this._updateDouble(updateDouble_name, columnIndex, x);
        this.logger.exiting(className, updateDouble_name);
    }

    private void _updateFloat(String methodName, int columnIndex, float x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.logger.entering(className, updateFloat_name, new Object[]{columnIndex, Float.valueOf(x)});
        this._validateColumn(updateFloat_name, columnIndex);
        this._updateFloat(updateFloat_name, columnIndex, x);
        this.logger.exiting(className, updateFloat_name);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.logger.entering(className, updateFloat_name, new Object[]{columnName, Float.valueOf(x)});
        int columnIndex = this._validateColumn(updateFloat_name, columnName);
        this._updateFloat(updateFloat_name, columnIndex, x);
        this.logger.exiting(className, updateFloat_name);
    }

    private void _updateInt(String methodName, int columnIndex, int x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.logger.entering(className, updateInt_name, new Object[]{columnIndex, x});
        this._validateColumn(updateInt_name, columnIndex);
        this._updateInt(updateInt_name, columnIndex, x);
        this.logger.exiting(className, updateInt_name);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.logger.entering(className, updateInt_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateInt_name, columnName);
        this._updateInt(updateInt_name, columnIndex, x);
        this.logger.exiting(className, updateInt_name);
    }

    private void _updateLong(String methodName, int columnIndex, long x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.logger.entering(className, updateLong_name, new Object[]{columnIndex, x});
        this._validateColumn(updateLong_name, columnIndex);
        this._updateLong(updateLong_name, columnIndex, x);
        this.logger.exiting(className, updateLong_name);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.logger.entering(className, updateLong_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateLong_name, columnName);
        this._updateLong(updateLong_name, columnIndex, x);
        this.logger.exiting(className, updateLong_name);
    }

    private void _updateNCharacterStream(String methodName, int columnIndex, Reader x, long length) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.logger.entering(className, updateNCharacterStream_name, new Object[]{columnIndex, x, length});
        this._validateColumn(updateNCharacterStream_name, columnIndex);
        this._updateNCharacterStream(updateNCharacterStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateNCharacterStream_name);
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        this.logger.entering(className, updateNCharacterStream_name, new Object[]{columnName, x, length});
        int columnIndex = this._validateColumn(updateNCharacterStream_name, columnName);
        this._updateNCharacterStream(updateNCharacterStream_name, columnIndex, x, length);
        this.logger.exiting(className, updateNCharacterStream_name);
    }

    private void _updateNCharacterStream(String methodName, int columnIndex, Reader x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.logger.entering(className, updateNCharacterStream_name, new Object[]{columnIndex, x});
        this._validateColumn(updateNCharacterStream_name, columnIndex);
        this._updateNCharacterStream(updateNCharacterStream_name, columnIndex, x);
        this.logger.exiting(className, updateNCharacterStream_name);
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x) throws SQLException {
        this.logger.entering(className, updateNCharacterStream_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateNCharacterStream_name, columnName);
        this._updateNCharacterStream(updateNCharacterStream_name, columnIndex, x);
        this.logger.exiting(className, updateNCharacterStream_name);
    }

    private void _updateNClob(String methodName, int columnIndex, NClob x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    private void _updateNClob(String methodName, int columnIndex, Reader x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    private void _updateNClob(String methodName, int columnIndex, Reader x, long length) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        this.logger.entering(className, updateNClob_name, new Object[]{columnIndex, x});
        this._validateColumn(updateNClob_name, columnIndex);
        this._updateNClob(updateNClob_name, columnIndex, x);
        this.logger.exiting(className, updateNClob_name);
    }

    @Override
    public void updateNClob(String columnName, NClob x) throws SQLException {
        this.logger.entering(className, updateNClob_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateNClob_name, columnName);
        this._updateNClob(updateNClob_name, columnIndex, x);
        this.logger.exiting(className, updateNClob_name);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x) throws SQLException {
        this.logger.entering(className, updateNClob_name, new Object[]{columnIndex, x});
        this._validateColumn(updateNClob_name, columnIndex);
        this._updateNClob(updateNClob_name, columnIndex, x);
        this.logger.exiting(className, updateNClob_name);
    }

    @Override
    public void updateNClob(String columnName, Reader x) throws SQLException {
        this.logger.entering(className, updateNClob_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateNClob_name, columnName);
        this._updateNClob(updateNClob_name, columnIndex, x);
        this.logger.exiting(className, updateNClob_name);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        this.logger.entering(className, updateNClob_name, new Object[]{columnIndex, x, length});
        this._validateColumn(updateNClob_name, columnIndex);
        this._updateNClob(updateNClob_name, columnIndex, x, length);
        this.logger.exiting(className, updateNClob_name);
    }

    @Override
    public void updateNClob(String columnName, Reader x, long length) throws SQLException {
        this.logger.entering(className, updateNClob_name, new Object[]{columnName, x, length});
        int columnIndex = this._validateColumn(updateNClob_name, columnName);
        this._updateNClob(updateNClob_name, columnIndex, x, length);
        this.logger.exiting(className, updateNClob_name);
    }

    private void _updateNString(String methodName, int columnIndex, String x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        this.logger.entering(className, updateNString_name, new Object[]{columnIndex, x});
        this._validateColumn(updateNString_name, columnIndex);
        this._updateNString(updateNString_name, columnIndex, x);
        this.logger.exiting(className, updateNString_name);
    }

    @Override
    public void updateNString(String columnName, String x) throws SQLException {
        this.logger.entering(className, updateNString_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateNString_name, columnName);
        this._updateNString(updateNString_name, columnIndex, x);
        this.logger.exiting(className, updateNString_name);
    }

    private void _updateNull(String methodName, int columnIndex) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.logger.entering(className, updateNull_name, columnIndex);
        this._validateColumn(updateNull_name, columnIndex);
        this._updateNull(updateNull_name, columnIndex);
        this.logger.exiting(className, updateNull_name);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.logger.entering(className, updateNull_name, columnName);
        int columnIndex = this._validateColumn(updateNull_name, columnName);
        this._updateNull(updateNull_name, columnIndex);
        this.logger.exiting(className, updateNull_name);
    }

    private void _updateObject(String methodName, int columnIndex, Object x, int scale) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.logger.entering(className, updateObject_name, new Object[]{columnIndex, x});
        this._validateColumn(updateObject_name, columnIndex);
        this._updateObject(updateObject_name, columnIndex, x, 0);
        this.logger.exiting(className, updateObject_name);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.logger.entering(className, updateObject_name, new Object[]{columnIndex, x, scale});
        this._validateColumn(updateObject_name, columnIndex);
        this._updateObject(updateObject_name, columnIndex, x, scale);
        this.logger.exiting(className, updateObject_name);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.logger.entering(className, updateObject_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateObject_name, columnName);
        this._updateObject(updateObject_name, columnIndex, x, 0);
        this.logger.exiting(className, updateObject_name);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.logger.entering(className, updateObject_name, new Object[]{columnName, x, scale});
        int columnIndex = this._validateColumn(updateObject_name, columnName);
        this._updateObject(updateObject_name, columnIndex, x, scale);
        this.logger.exiting(className, updateObject_name);
    }

    private void _updateRef(String methodName, int columnIndex, Ref x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.logger.entering(className, updateRef_name, new Object[]{columnIndex, x});
        this._validateColumn(updateRef_name, columnIndex);
        this._updateRef(updateRef_name, columnIndex, x);
        this.logger.exiting(className, updateRef_name);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.logger.entering(className, updateRef_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateRef_name, columnName);
        this._updateRef(updateRef_name, columnIndex, x);
        this.logger.exiting(className, updateRef_name);
    }

    @Override
    public void updateRow() throws SQLException {
        this.logger.entering(className, updateRow_name);
        this._validate(updateRow_name);
        throw this.createSQLFeatureNotSupportedException(updateRow_name, "Updates not supported in ResultSets");
    }

    private void _updateRowId(String methodName, int columnIndex, RowId x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.logger.entering(className, updateRowId_name, new Object[]{columnIndex, x});
        this._validateColumn(updateRowId_name, columnIndex);
        this._updateRowId(updateRowId_name, columnIndex, x);
        this.logger.exiting(className, updateRowId_name);
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        this.logger.entering(className, updateRowId_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateRowId_name, columnName);
        this._updateRowId(updateRowId_name, columnIndex, x);
        this.logger.exiting(className, updateRowId_name);
    }

    private void _updateShort(String methodName, int columnIndex, short x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.logger.entering(className, updateShort_name, new Object[]{columnIndex, x});
        this._validateColumn(updateShort_name, columnIndex);
        this._updateShort(updateShort_name, columnIndex, x);
        this.logger.exiting(className, updateShort_name);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.logger.entering(className, updateShort_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateShort_name, columnName);
        this._updateShort(updateShort_name, columnIndex, x);
        this.logger.exiting(className, updateShort_name);
    }

    private void _updateSQLXML(String methodName, int columnIndex, SQLXML x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        this.logger.entering(className, updateSQLXML_name, new Object[]{columnIndex, x});
        this._validateColumn(updateSQLXML_name, columnIndex);
        this._updateSQLXML(updateSQLXML_name, columnIndex, x);
        this.logger.exiting(className, updateSQLXML_name);
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML x) throws SQLException {
        this.logger.entering(className, updateSQLXML_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateSQLXML_name, columnName);
        this._updateSQLXML(updateSQLXML_name, columnIndex, x);
        this.logger.exiting(className, updateSQLXML_name);
    }

    private void _updateString(String methodName, int columnIndex, String x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.logger.entering(className, updateString_name, new Object[]{columnIndex, x});
        this._validateColumn(updateString_name, columnIndex);
        this._updateString(updateString_name, columnIndex, x);
        this.logger.exiting(className, updateString_name);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.logger.entering(className, updateString_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateString_name, columnName);
        this._updateString(updateString_name, columnIndex, x);
        this.logger.exiting(className, updateString_name);
    }

    private void _updateTime(String methodName, int columnIndex, Time x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.logger.entering(className, updateTime_name, new Object[]{columnIndex, x});
        this._validateColumn(updateTime_name, columnIndex);
        this._updateTime(updateTime_name, columnIndex, x);
        this.logger.exiting(className, updateTime_name);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.logger.entering(className, updateTime_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateTime_name, columnName);
        this._updateTime(updateTime_name, columnIndex, x);
        this.logger.exiting(className, updateTime_name);
    }

    private void _updateTimestamp(String methodName, int columnIndex, Timestamp x) throws SQLException {
        throw this.createSQLFeatureNotSupportedException(methodName, "Updates not supported in ResultSets");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.logger.entering(className, updateTimestamp_name, new Object[]{columnIndex, x});
        this._validateColumn(updateTimestamp_name, columnIndex);
        this._updateTimestamp(updateTimestamp_name, columnIndex, x);
        this.logger.exiting(className, updateTimestamp_name);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.logger.entering(className, updateTimestamp_name, new Object[]{columnName, x});
        int columnIndex = this._validateColumn(updateTimestamp_name, columnName);
        this._updateTimestamp(updateTimestamp_name, columnIndex, x);
        this.logger.exiting(className, updateTimestamp_name);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.logger.entering(className, wasNull_name);
        this._validate(wasNull_name);
        this.logger.exiting(className, wasNull_name, this.lastnull);
        return this.lastnull;
    }

    private void closeCurrentStream() {
        if (this.currentStream != null) {
            try {
                this.currentStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.currentStream = null;
        }
        if (this.currentReader != null) {
            try {
                this.currentReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.currentReader = null;
        }
    }

    private void _validate(String methodName) throws SQLException {
        if (this.stmt == null) {
            throw this.createSQLException(methodName, "ResultSet closed");
        }
    }

    private void _validateColumn(String methodName, int columnIndex) throws SQLException {
        this._validate(methodName);
        if (this.rowset == null || this.row < 0) {
            throw this.createSQLException(methodName, "No current row");
        }
        if (columnIndex < 1 || columnIndex > this.numcols) {
            throw this.createSQLException(methodName, "Invalid column number, columnIndex = " + columnIndex + ", numcols = " + this.numcols);
        }
    }

    private int _validateColumn(String methodName, String columnName) throws SQLException {
        this._validate(methodName);
        if (this.rowset == null || this.row < 0) {
            throw this.createSQLException(methodName, "No current row");
        }
        return this._findColumn(methodName, columnName);
    }

    private int _findColumn(String methodName, String columnName) throws SQLException {
        for (int ii = 1; ii <= this.numcols; ++ii) {
            if (!this.meta.getColumnName(ii).equals(columnName)) continue;
            return ii;
        }
        throw this.createSQLException(methodName, "ResultSet does not contain name '" + columnName + "'");
    }

    private void _addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            this.warnings.setNextWarning(warning);
        }
    }

    private void _addWarning(String msg) {
        this._addWarning(new SQLWarning(msg));
    }

    private SQLException createSQLFeatureNotSupportedException(String methodName, String error) throws SQLException {
        SQLFeatureNotSupportedException sqlex = new SQLFeatureNotSupportedException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }

    private SQLException createSQLException(String methodName, String str) throws SQLException {
        SQLException sqlex = new SQLException(str);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }
}

