/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.jdbc.RDMStatement;
import com.raima.rdm.sql.RSQLParamDesc;
import com.raima.rdm.util.RDMException;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.logging.Logger;

public class RDMParameterMetaData
implements ParameterMetaData {
    int numparms;
    RDMStatement stmt;
    RSQLParamDesc[] params;
    private Logger logger = Logger.getLogger("com.raima.rdm.jdbc.API");
    private static final String className = "RDMParameterMetaData";

    protected RDMParameterMetaData(RDMStatement stmt, int numparms) {
        this.stmt = stmt;
        this.numparms = numparms;
        this.params = null;
    }

    public void close() {
        String methodName = "close";
        this.logger.entering(className, methodName);
        this.stmt = null;
        this.params = null;
        this.logger.exiting(className, methodName);
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        String methodName = "getParameterClassName";
        this.logger.entering(className, methodName, param);
        this._validateParm(methodName, param);
        String str = this.params[param - 1].getClassName();
        this.logger.exiting(className, methodName, str);
        return str;
    }

    @Override
    public int getParameterCount() throws SQLException {
        String methodName = "getParameterCount";
        this.logger.entering(className, methodName);
        this.logger.exiting(className, methodName, this.numparms);
        return this.numparms;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        String methodName = "getParameterMode";
        this.logger.entering(className, methodName, param);
        this._validateParm(methodName, param);
        int ret = this.params[param - 1].getMode();
        this.logger.exiting(className, methodName, ret);
        return ret;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        String methodName = "getParameterType";
        this.logger.entering(className, methodName, param);
        this._validateParm(methodName, param);
        int ret = this.params[param - 1].getType();
        this.logger.exiting(className, methodName, ret);
        return ret;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        String methodName = "getParameterTypeName";
        this.logger.entering(className, methodName, param);
        this._validateParm(methodName, param);
        String str = this.params[param - 1].getTypeName();
        this.logger.exiting(className, methodName, str);
        return str;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        String methodName = "getPrecision";
        this.logger.entering(className, methodName, param);
        this._validateParm(methodName, param);
        int ret = this.params[param - 1].getPrecision();
        this.logger.exiting(className, methodName, ret);
        return ret;
    }

    @Override
    public int getScale(int param) throws SQLException {
        String methodName = "getScale";
        this.logger.entering(className, methodName, param);
        this._validateParm(methodName, param);
        int ret = this.params[param - 1].getScale();
        this.logger.exiting(className, methodName, ret);
        return ret;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        String methodName = "isNullable";
        this.logger.entering(className, methodName, param);
        this._validateParm(methodName, param);
        int ret = this.params[param - 1].getNullable();
        this.logger.exiting(className, methodName, ret);
        return ret;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        String methodName = "isSigned";
        this.logger.entering(className, methodName, param);
        this._validateParm(methodName, param);
        boolean val = true;
        this.logger.exiting(className, methodName, val);
        return val;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodName = "isWrapperFor";
        this.logger.entering(className, methodName, iface);
        boolean result = iface.isInstance(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodName = "unwrap";
        this.logger.entering(className, methodName, iface);
        if (!iface.isInstance(this)) {
            throw this.createSQLException(methodName, "not an instance");
        }
        T result = iface.cast(this);
        this.logger.exiting(className, methodName, result);
        return result;
    }

    private void _validate(String methodName) throws SQLException {
        if (this.stmt != null) {
            throw this.createSQLException(methodName, "Invalid ParameterMetaData");
        }
    }

    private void _validateParm(String methodName, int param) throws SQLException {
        this._validate(methodName);
        if (param < 1 || param > this.numparms) {
            throw this.createSQLException(methodName, "Invalid parameter number");
        }
        --param;
        if (this.params == null) {
            this.params = new RSQLParamDesc[this.numparms];
        }
        try {
            if (this.params[param] == null) {
                this.params[param] = this.stmt.getSQLStatement().describeParam(param);
            }
        }
        catch (RDMException e) {
            throw e.createSQLException();
        }
    }

    private SQLException createSQLException(String methodName, String error) throws SQLException {
        SQLException sqlex = new SQLException(error);
        this.logger.throwing(className, methodName, sqlex);
        return sqlex;
    }
}

