/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.util.ClobHandler;
import java.io.IOException;
import java.io.OutputStream;

class RDMClobOutputStream
extends OutputStream {
    long pos;
    ClobHandler clobhandler;

    RDMClobOutputStream(ClobHandler clobhandler, long pos) {
        this.pos = pos;
        this.clobhandler = clobhandler;
    }

    @Override
    public void close() {
        this.clobhandler = null;
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b == null ? 0 : b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.clobhandler == null) {
            throw new IOException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        char[] carray = new char[len];
        for (int ii = 0; ii < len; ++ii) {
            carray[ii] = (char)b[off + ii];
        }
        this.clobhandler.write(this.pos, carray);
        this.pos += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.clobhandler == null) {
            throw new IOException();
        }
        char[] ca = new char[]{(char)b};
        this.clobhandler.write(this.pos, ca);
        ++this.pos;
    }
}

