/*
 * Decompiled with CFR 0.152.
 */
package com.raima.rdm.jdbc;

import com.raima.rdm.util.BlobHandler;
import java.io.IOException;
import java.io.InputStream;

class RDMBlobInputStream
extends InputStream {
    long pos;
    long maxlen;
    long markpos;
    BlobHandler blobhandler;

    public RDMBlobInputStream(BlobHandler blobhandler) throws IOException {
        this.pos = 0L;
        this.markpos = 0L;
        this.blobhandler = blobhandler;
        this.maxlen = blobhandler.size();
    }

    public RDMBlobInputStream(BlobHandler blobhandler, long pos, long len) throws IOException {
        this.pos = pos;
        this.markpos = pos;
        this.blobhandler = blobhandler;
        this.maxlen = len;
    }

    @Override
    public int available() throws IOException {
        if (this.blobhandler == null) {
            throw new IOException();
        }
        return (int)Math.min(this.maxlen, Integer.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
        this.blobhandler = null;
    }

    @Override
    public void mark(int readlimit) {
        this.markpos = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.blobhandler == null) {
            throw new IOException();
        }
        int b = this.blobhandler.read(this.pos);
        if (b != -1) {
            ++this.pos;
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b == null ? 0 : b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.blobhandler == null) {
            throw new IOException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if ((len = this.blobhandler.read(this.pos, b, off, len)) != -1) {
            this.pos += (long)len;
        }
        return len;
    }

    @Override
    public void reset() throws IOException {
        if (this.blobhandler == null) {
            throw new IOException();
        }
        this.pos = this.markpos;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.blobhandler == null) {
            throw new IOException();
        }
        long skipped = Math.min(n, this.maxlen - this.pos);
        if (skipped < 0L || skipped > this.maxlen) {
            skipped = n;
        }
        this.pos += skipped;
        return skipped;
    }
}

